/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.library.client.util.breadcrumb;

import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.guvnor.common.services.project.model.WorkspaceProject;
import org.guvnor.structure.organizationalunit.OrganizationalUnit;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.kie.workbench.common.screens.library.client.util.LibraryPlaces;
import org.kie.workbench.common.screens.library.client.util.ResourceUtils;
import org.kie.workbench.common.screens.library.client.util.TranslationUtils;
import org.kie.workbench.common.screens.library.client.util.breadcrumb.ProjectBranchBreadcrumb;
import org.uberfire.backend.vfs.Path;
import org.uberfire.ext.widgets.common.client.breadcrumbs.UberfireBreadcrumbs;
import org.uberfire.ext.widgets.common.client.breadcrumbs.widget.BreadcrumbPresenter;

@Dependent
public class LibraryBreadcrumbs {
    private LibraryPlaces libraryPlaces;
    private UberfireBreadcrumbs breadcrumbs;
    private TranslationUtils translationUtils;
    private TranslationService ts;
    private ResourceUtils resourceUtils;
    private ProjectBranchBreadcrumb projectBranchBreadcrumb;

    @Inject
    public LibraryBreadcrumbs(UberfireBreadcrumbs breadcrumbs, TranslationUtils translationUtils, TranslationService ts, ResourceUtils resourceUtils, ProjectBranchBreadcrumb projectBranchBreadcrumb) {
        this.breadcrumbs = breadcrumbs;
        this.translationUtils = translationUtils;
        this.ts = ts;
        this.resourceUtils = resourceUtils;
        this.projectBranchBreadcrumb = projectBranchBreadcrumb;
    }

    public void init(LibraryPlaces libraryPlaces) {
        this.libraryPlaces = libraryPlaces;
    }

    public void clear() {
        this.breadcrumbs.clearBreadcrumbs("LibraryPerspective");
    }

    public void setupForSpacesScreen() {
        this.clear();
        this.breadcrumbs.addBreadCrumb("LibraryPerspective", this.translationUtils.getOrganizationalUnitAliasInPlural(), this.libraryPlaces::goToOrganizationalUnits);
    }

    public void setupForSpace(OrganizationalUnit space) {
        this.setupForSpacesScreen();
        this.breadcrumbs.addBreadCrumb("LibraryPerspective", space.getName(), this.libraryPlaces::goToLibrary);
    }

    public void setupForProject(WorkspaceProject project) {
        this.setupForSpace(project.getOrganizationalUnit());
        this.breadcrumbs.addBreadCrumb("LibraryPerspective", project.getName(), () -> this.libraryPlaces.goToProject(this.libraryPlaces.getActiveWorkspace()));
        this.breadcrumbs.addBreadCrumb("LibraryPerspective", (BreadcrumbPresenter)this.projectBranchBreadcrumb.setup(project.getRepository().getBranches()));
    }

    public void setupForTrySamples(OrganizationalUnit space) {
        this.setupForSpace(space);
        this.breadcrumbs.addBreadCrumb("LibraryPerspective", this.ts.getTranslation("TrySamples"), this.libraryPlaces::goToTrySamples);
    }

    public void setupForAsset(WorkspaceProject project, Path path) {
        this.setupForProject(project);
        this.breadcrumbs.addBreadCrumb("LibraryPerspective", this.resourceUtils.getBaseFileName(path), () -> this.libraryPlaces.goToAsset(path));
    }

    public void setupForSubmitChangeRequest(WorkspaceProject project) {
        this.setupForProject(project);
        this.breadcrumbs.addBreadCrumb("LibraryPerspective", this.ts.getTranslation("SubmitChangeRequest"), () -> this.libraryPlaces.goToSubmitChangeRequestScreen());
    }

    public void setupForChangeRequestReview(WorkspaceProject project, long changeRequestId) {
        this.setupForProject(project);
        this.breadcrumbs.addBreadCrumb("LibraryPerspective", this.ts.format("ChangeRequestAndId", new Object[]{changeRequestId}), () -> this.libraryPlaces.goToChangeRequestReviewScreen(changeRequestId));
    }
}

