/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.library.client.widgets.example.branchselector;

import com.google.gwt.user.client.ui.Widget;
import elemental2.dom.HTMLDivElement;
import elemental2.dom.HTMLElement;
import javax.inject.Inject;
import javax.inject.Named;
import org.gwtbootstrap3.client.ui.Button;
import org.gwtbootstrap3.client.ui.ModalFooter;
import org.gwtbootstrap3.client.ui.constants.ButtonType;
import org.jboss.errai.ui.client.local.api.elemental2.IsElement;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.kie.workbench.common.screens.library.client.widgets.example.branchselector.BranchSelectorPopUpPresenter;
import org.uberfire.ext.editor.commons.client.file.popups.CommonModalBuilder;
import org.uberfire.ext.widgets.common.client.common.BusyPopup;
import org.uberfire.ext.widgets.common.client.common.popups.BaseModal;
import org.uberfire.ext.widgets.common.client.common.popups.footers.GenericModalFooter;
import org.uberfire.mvp.Command;

@Templated
public class BranchSelectorPopUpView
implements BranchSelectorPopUpPresenter.View,
IsElement {
    private BranchSelectorPopUpPresenter presenter;
    private BaseModal modal;
    @Inject
    private TranslationService ts;
    @Inject
    @DataField(value="body")
    HTMLDivElement body;
    @Inject
    @DataField(value="error")
    HTMLDivElement error;
    @Inject
    @Named(value="span")
    @DataField(value="error-message")
    HTMLElement errorMessage;
    @Inject
    @Named(value="span")
    @DataField(value="branch-selector-container")
    HTMLElement branchSelectorContainer;

    public void init(BranchSelectorPopUpPresenter presenter) {
        this.presenter = presenter;
        this.modalSetup();
    }

    @Override
    public HTMLElement getBranchSelectorContainer() {
        return this.branchSelectorContainer;
    }

    private void modalSetup() {
        this.modal = new CommonModalBuilder().addHeader(this.ts.format("BranchesToBeImported", new Object[0])).addBody((HTMLElement)this.body).addFooter(this.footer()).build();
    }

    private ModalFooter footer() {
        GenericModalFooter footer = new GenericModalFooter();
        footer.add((Widget)this.cancelButton());
        footer.add((Widget)this.addButton());
        return footer;
    }

    private Button addButton() {
        return this.button(this.ts.format("Ok", new Object[0]), () -> this.presenter.defineBranches(), ButtonType.PRIMARY);
    }

    private Button cancelButton() {
        return this.button(this.ts.format("Cancel", new Object[0]), () -> this.presenter.cancel(), ButtonType.DEFAULT);
    }

    private Button button(String text, Command command, ButtonType type) {
        Button button = new Button(text, event -> command.execute());
        button.setType(type);
        return button;
    }

    @Override
    public void showError(String errorMessage) {
        this.errorMessage.textContent = errorMessage;
        this.error.hidden = false;
    }

    private void errorSetup() {
        this.error.hidden = true;
    }

    @Override
    public String getMainIsRequiredMessage() {
        return this.ts.format("DefaultBranchIsRequired", new Object[0]);
    }

    @Override
    public String getAtLeastMainIsRequiredMessage() {
        return this.ts.format("AtLeastDefaultBranchIsRequired", new Object[0]);
    }

    @Override
    public void show() {
        this.errorSetup();
        this.modal.show();
    }

    @Override
    public void hide() {
        this.modal.hide();
    }

    public void showBusyIndicator(String message) {
        BusyPopup.showMessage((String)message);
    }

    public void hideBusyIndicator() {
        BusyPopup.close();
    }
}

