/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.library.client.perspective;

import com.google.gwt.user.client.Window;
import java.util.List;
import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.guvnor.common.services.project.context.WorkspaceProjectContextChangeEvent;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.kie.workbench.common.screens.library.client.util.LibraryPlaces;
import org.uberfire.backend.vfs.Path;
import org.uberfire.backend.vfs.VFSService;
import org.uberfire.client.annotations.Perspective;
import org.uberfire.client.annotations.WorkbenchPerspective;
import org.uberfire.client.workbench.events.PerspectiveChange;
import org.uberfire.client.workbench.panels.impl.MultiListWorkbenchPanelPresenter;
import org.uberfire.lifecycle.OnClose;
import org.uberfire.lifecycle.OnStartup;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.workbench.events.NotificationEvent;
import org.uberfire.workbench.model.PanelDefinition;
import org.uberfire.workbench.model.PerspectiveDefinition;
import org.uberfire.workbench.model.impl.PerspectiveDefinitionImpl;

@ApplicationScoped
@WorkbenchPerspective(identifier="LibraryPerspective")
public class LibraryPerspective {
    private LibraryPlaces libraryPlaces;
    private Event<WorkspaceProjectContextChangeEvent> projectContextChangeEvent;
    private Caller<VFSService> vfsServices;
    private Event<NotificationEvent> notificationEvent;
    private TranslationService ts;
    private PerspectiveDefinition perspectiveDefinition;
    private boolean refresh = true;
    private String projectPath;

    public LibraryPerspective() {
    }

    @Inject
    public LibraryPerspective(LibraryPlaces libraryPlaces, Event<WorkspaceProjectContextChangeEvent> projectContextChangeEvent, Caller<VFSService> vfsServices, Event<NotificationEvent> notificationEvent, TranslationService ts) {
        this.libraryPlaces = libraryPlaces;
        this.projectContextChangeEvent = projectContextChangeEvent;
        this.vfsServices = vfsServices;
        this.notificationEvent = notificationEvent;
        this.ts = ts;
    }

    @Perspective
    public PerspectiveDefinition buildPerspective() {
        if (this.perspectiveDefinition == null) {
            this.perspectiveDefinition = new PerspectiveDefinitionImpl(MultiListWorkbenchPanelPresenter.class.getName());
            this.perspectiveDefinition.setName("Library Perspective");
        }
        return this.perspectiveDefinition;
    }

    @OnStartup
    public void onStartup(PlaceRequest placeRequest) {
        this.projectPath = (this.getWindowParameterMap().containsKey("path") ? this.getWindowParameterMap().get("path").get(0) : "").trim();
        this.refresh = Boolean.parseBoolean(placeRequest.getParameter("refresh", "true"));
        this.libraryPlaces.init(this);
    }

    public void perspectiveChangeEvent(@Observes PerspectiveChange event) {
        if (event.getIdentifier().equals("LibraryPerspective")) {
            if (this.refresh) {
                if (this.projectPath != null && !this.projectPath.isEmpty()) {
                    this.libraryPlaces.refresh(() -> {
                        if (this.getRootPanel() != null) {
                            ((VFSService)this.vfsServices.call(path -> this.libraryPlaces.goToProject((Path)path), (o, throwable) -> {
                                this.notificationEvent.fire((Object)new NotificationEvent(this.ts.format("InvalidProjectPath", new Object[0]), NotificationEvent.NotificationType.ERROR));
                                return false;
                            })).get(this.projectPath);
                        }
                    });
                } else {
                    this.libraryPlaces.refresh(() -> {
                        if (this.getRootPanel() != null) {
                            this.libraryPlaces.goToLibrary();
                        }
                    });
                }
            } else {
                this.libraryPlaces.refresh(() -> {});
            }
        }
    }

    @OnClose
    public void onClose() {
        this.projectContextChangeEvent.fire((Object)new WorkspaceProjectContextChangeEvent());
    }

    Map<String, List<String>> getWindowParameterMap() {
        return Window.Location.getParameterMap();
    }

    public PanelDefinition getRootPanel() {
        return this.buildPerspective().getRoot();
    }
}

