/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.library.client.screens;

import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import org.jboss.errai.common.client.api.IsElement;
import org.jboss.errai.common.client.dom.HTMLElement;
import org.uberfire.client.mvp.UberElement;
import org.uberfire.mvp.Command;

public class AssetList
implements IsElement {
    private static final int DEFAULT_STEP = 15;
    private View view;
    private Command command;
    private List<HTMLElement> elements = new ArrayList<HTMLElement>();
    private int step = 15;
    private int pageNumber = 1;

    @Inject
    public AssetList(View view) {
        this.view = view;
        view.init(this);
        view.setStep(this.step);
        view.setPageNumber(this.pageNumber);
    }

    public void resetPageRangeIndicator() {
        this.updateToFirstPage();
        this.view.range(1, this.step);
        this.view.hideEmptyState();
    }

    public void clear() {
        this.elements.clear();
        this.view.clearAssets();
        this.view.hideEmptyState();
    }

    public void add(HTMLElement element) {
        this.elements.add(element);
        this.view.add(element);
        this.view.range(this.getFirstIndex() + 1, this.getFirstIndex() + this.elements.size());
        this.setupForwardBackwardButtons();
    }

    private void setupForwardBackwardButtons() {
        this.view.setBackwardDisabled(this.getFirstIndex() == 0);
        this.view.setForwardDisabled(this.isThereRoomOnThisPage());
    }

    private boolean isThereRoomOnThisPage() {
        return this.step > this.elements.size();
    }

    public void showEmptyState(String topic, String message) {
        this.view.showEmptyStateMessage(topic, message);
    }

    public Integer getStep() {
        return this.step;
    }

    public void onChangeAmountOfItemsShown(int step) {
        this.step = step;
        this.updateToFirstPage();
        this.command.execute();
    }

    private void updateToFirstPage() {
        this.pageNumber = 1;
        this.view.setPageNumber(this.pageNumber);
    }

    public void onToFirstPage() {
        this.pageNumber = 1;
        this.view.setPageNumber(this.pageNumber);
        this.command.execute();
    }

    public void onToNextPage() {
        if (!this.isThereRoomOnThisPage()) {
            ++this.pageNumber;
            this.view.setPageNumber(this.pageNumber);
            this.command.execute();
        }
    }

    public void onToPrevious() {
        if (this.pageNumber > 1) {
            --this.pageNumber;
            this.view.setPageNumber(this.pageNumber);
            this.command.execute();
        }
    }

    public void onPageNumberChange(int pageNumber) {
        this.pageNumber = pageNumber > 0 ? pageNumber : 1;
        this.command.execute();
    }

    public HTMLElement getElement() {
        return this.view.getElement();
    }

    public void addChangeHandler(Command command) {
        this.command = command;
    }

    public int getFirstIndex() {
        int result = this.pageNumber * this.step - this.step;
        if (result < 1) {
            return 0;
        }
        return result;
    }

    public static interface View
    extends UberElement<AssetList> {
        public void setForwardDisabled(boolean var1);

        public void setBackwardDisabled(boolean var1);

        public void range(int var1, int var2);

        public void clearAssets();

        public void hideEmptyState();

        public void add(HTMLElement var1);

        public void showEmptyStateMessage(String var1, String var2);

        public void setPageNumber(int var1);

        public void setStep(int var1);
    }
}

