/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.library.client.screens;

import com.google.gwt.event.dom.client.ClickEvent;
import javax.inject.Inject;
import org.jboss.errai.common.client.dom.Anchor;
import org.jboss.errai.common.client.dom.Div;
import org.jboss.errai.common.client.dom.HTMLElement;
import org.jboss.errai.common.client.dom.Input;
import org.jboss.errai.common.client.dom.ListItem;
import org.jboss.errai.common.client.dom.Node;
import org.jboss.errai.common.client.dom.Span;
import org.jboss.errai.ui.client.local.api.IsElement;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.EventHandler;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.kie.workbench.common.screens.library.client.screens.LibraryScreen;

@Templated
public class LibraryView
implements LibraryScreen.View,
IsElement {
    private LibraryScreen presenter;
    @Inject
    private TranslationService ts;
    @Inject
    @DataField(value="title")
    Span title;
    @Inject
    @DataField(value="description-text")
    Span descriptionText;
    @Inject
    @DataField(value="edit-icon")
    Span editIcon;
    @Inject
    @DataField(value="change-description")
    Anchor changeDescription;
    @Inject
    @DataField(value="cancel-description-editor")
    Anchor cancelDescriptionEditor;
    @Inject
    @DataField(value="description-input")
    Input descriptionInput;
    @Inject
    @DataField(value="description-editor")
    Span descriptionEditor;
    @Inject
    @DataField(value="delete-project")
    Anchor deleteProject;
    @Inject
    @DataField(value="projects-tab-container")
    ListItem projectsTabContainer;
    @Inject
    @DataField(value="projects-tab")
    Anchor projectsTab;
    @Inject
    @DataField(value="projects-count")
    Span projectsCount;
    @Inject
    @DataField(value="contributors-tab-container")
    ListItem contributorsTabContainer;
    @Inject
    @DataField(value="contributors-tab")
    Anchor contributorsTab;
    @Inject
    @DataField(value="contributors-count")
    Span contributorsCount;
    @Inject
    @DataField(value="metrics-tab-container")
    ListItem metricsTabContainer;
    @Inject
    @DataField(value="metrics-tab")
    Anchor metricsTab;
    @Inject
    @DataField(value="settings-tab-container")
    ListItem settingsTabContainer;
    @Inject
    @DataField(value="settings-tab")
    Anchor settingsTab;
    @Inject
    @DataField(value="main-container")
    Div mainContainer;

    public void init(LibraryScreen presenter) {
        this.presenter = presenter;
        boolean userCanCreateProjects = presenter.userCanCreateProjects();
        boolean userCanDeleteOrganizationalUnit = presenter.userCanDeleteOrganizationalUnit();
        this.deleteProject.setHidden(!userCanDeleteOrganizationalUnit);
    }

    @EventHandler(value={"delete-project"})
    public void delete(ClickEvent event) {
        this.presenter.delete();
    }

    @EventHandler(value={"projects-tab"})
    public void showProjects(ClickEvent event) {
        this.projectsTabContainer.getClassList().add("active");
        this.contributorsTabContainer.getClassList().remove("active");
        this.metricsTabContainer.getClassList().remove("active");
        this.settingsTabContainer.getClassList().remove("active");
        this.presenter.showProjects();
    }

    @EventHandler(value={"contributors-tab"})
    public void showContributors(ClickEvent event) {
        this.projectsTabContainer.getClassList().remove("active");
        this.contributorsTabContainer.getClassList().add("active");
        this.metricsTabContainer.getClassList().remove("active");
        this.settingsTabContainer.getClassList().remove("active");
        this.presenter.showContributors();
    }

    @EventHandler(value={"metrics-tab"})
    public void showMetrics(ClickEvent event) {
        this.projectsTabContainer.getClassList().remove("active");
        this.contributorsTabContainer.getClassList().remove("active");
        this.metricsTabContainer.getClassList().add("active");
        this.settingsTabContainer.getClassList().remove("active");
        this.presenter.showMetrics();
    }

    @EventHandler(value={"settings-tab"})
    public void showSettings(ClickEvent event) {
        this.projectsTabContainer.getClassList().remove("active");
        this.contributorsTabContainer.getClassList().remove("active");
        this.metricsTabContainer.getClassList().remove("active");
        this.settingsTabContainer.getClassList().add("active");
        this.presenter.showSettings();
    }

    @EventHandler(value={"edit-icon"})
    public void onEditClicked(ClickEvent clickEvent) {
        this.showDescriptionEditor();
    }

    @EventHandler(value={"description-text"})
    public void onDescriptionClickedfinal(ClickEvent clickEvent) {
        this.showDescriptionEditor();
    }

    @EventHandler(value={"change-description"})
    public void onChangeDescription(ClickEvent clickEvent) {
        this.presenter.changeDescription(this.descriptionInput.getValue());
    }

    @EventHandler(value={"cancel-description-editor"})
    public void onCancelDescriptionEditor(ClickEvent clickEvent) {
        this.showDescriptionText();
    }

    @Override
    public void setTitle(String title) {
        this.title.setTextContent(title);
    }

    @Override
    public void setDescription(String description) {
        this.descriptionText.setTextContent("");
        this.showDescriptionText();
        if (description != null && !description.isEmpty()) {
            this.descriptionText.setHidden(false);
            this.descriptionText.setTextContent(description);
            this.descriptionText.setTitle(description);
        }
    }

    @Override
    public void setProjectsCount(int count) {
        this.projectsCount.setTextContent(String.valueOf(count));
    }

    @Override
    public void setContributorsCount(int count) {
        this.contributorsCount.setTextContent(String.valueOf(count));
    }

    @Override
    public void updateContent(HTMLElement content) {
        this.mainContainer.setTextContent("");
        this.mainContainer.appendChild((Node)content);
    }

    @Override
    public boolean isProjectsTabActive() {
        return this.projectsTabContainer.getClassList().contains("active");
    }

    @Override
    public boolean isContributorsTabActive() {
        return this.contributorsTabContainer.getClassList().contains("active");
    }

    @Override
    public boolean isMetricsTabActive() {
        return this.metricsTabContainer.getClassList().contains("active");
    }

    @Override
    public boolean isSettingsTabActive() {
        return this.settingsTabContainer.getClassList().contains("active");
    }

    @Override
    public void showSettingsTab(boolean isVisible) {
        this.settingsTab.setHidden(!isVisible);
        this.settingsTabContainer.setHidden(!isVisible);
    }

    private void showDescriptionText() {
        this.descriptionEditor.setHidden(true);
        this.descriptionText.setHidden(false);
        this.editIcon.setHidden(false);
    }

    private void showDescriptionEditor() {
        this.descriptionText.setHidden(true);
        this.editIcon.setHidden(true);
        this.descriptionEditor.setHidden(false);
        this.descriptionInput.setValue(this.descriptionText.getTextContent());
    }
}

