/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.library.client.screens;

import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.TreeSet;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.guvnor.common.services.project.client.context.WorkspaceProjectContext;
import org.guvnor.common.services.project.client.security.ProjectController;
import org.guvnor.common.services.project.events.NewProjectEvent;
import org.guvnor.common.services.project.model.POM;
import org.guvnor.common.services.project.model.WorkspaceProject;
import org.guvnor.structure.organizationalunit.OrganizationalUnit;
import org.guvnor.structure.repositories.Repository;
import org.guvnor.structure.repositories.RepositoryRemovedEvent;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.dom.HTMLElement;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.kie.workbench.common.screens.library.api.LibraryInfo;
import org.kie.workbench.common.screens.library.api.LibraryService;
import org.kie.workbench.common.screens.library.api.ProjectAssetListUpdated;
import org.kie.workbench.common.screens.library.api.ProjectCountUpdate;
import org.kie.workbench.common.screens.library.api.Routed;
import org.kie.workbench.common.screens.library.client.util.LibraryPlaces;
import org.kie.workbench.common.screens.library.client.widgets.common.TileWidget;
import org.kie.workbench.common.screens.library.client.widgets.library.AddProjectButtonPresenter;
import org.uberfire.client.mvp.UberElement;
import org.uberfire.ext.widgets.common.client.common.HasBusyIndicator;
import org.uberfire.mvp.Command;
import org.uberfire.spaces.Space;

public class PopulatedLibraryScreen {
    private static final Comparator<TileWidget<WorkspaceProject>> comparator = Comparator.comparing(tile -> ((WorkspaceProject)tile.getContent()).getName().toUpperCase());
    private View view;
    private LibraryPlaces libraryPlaces;
    private Caller<LibraryService> libraryService;
    private ProjectController projectController;
    private WorkspaceProjectContext projectContext;
    private Event<ProjectCountUpdate> projectCountUpdateEvent;
    private ManagedInstance<TileWidget<WorkspaceProject>> tileWidgets;
    private AddProjectButtonPresenter addProjectButtonPresenter;
    TreeSet<TileWidget<WorkspaceProject>> libraryTiles = new TreeSet<TileWidget<WorkspaceProject>>(comparator);

    @Inject
    public PopulatedLibraryScreen(View view, LibraryPlaces libraryPlaces, Caller<LibraryService> libraryService, ProjectController projectController, WorkspaceProjectContext projectContext, ManagedInstance<TileWidget<WorkspaceProject>> tileWidgets, AddProjectButtonPresenter addProjectButtonPresenter, Event<ProjectCountUpdate> projectCountUpdateEvent) {
        this.view = view;
        this.libraryPlaces = libraryPlaces;
        this.libraryService = libraryService;
        this.projectController = projectController;
        this.projectContext = projectContext;
        this.projectCountUpdateEvent = projectCountUpdateEvent;
        this.tileWidgets = tileWidgets;
        this.addProjectButtonPresenter = addProjectButtonPresenter;
    }

    @PostConstruct
    public void setup() {
        this.view.init(this);
        if (this.userCanCreateProjects()) {
            this.addProjectButtonPresenter.enableTrySamples();
            this.addProjectButtonPresenter.enableImportProject();
            this.view.addAction(this.addProjectButtonPresenter.getView().getElement());
        }
        ((LibraryService)this.libraryService.call(this::setupLibrary)).getLibraryInfo(this.getOrganizationalUnit());
    }

    private OrganizationalUnit getOrganizationalUnit() {
        return (OrganizationalUnit)this.projectContext.getActiveOrganizationalUnit().orElseThrow(() -> new IllegalStateException("Cannot get library info without an active organizational unit."));
    }

    private void setupLibrary(LibraryInfo libraryInfo) {
        this.view.clearFilterText();
        this.libraryTiles.clear();
        libraryInfo.getProjects().stream().map(this::createProjectWidget).collect(Collectors.toCollection(() -> this.libraryTiles));
        this.updateView(this.libraryTiles);
    }

    public List<TileWidget<WorkspaceProject>> filterProjects(String filter) {
        List<TileWidget<WorkspaceProject>> filteredProjects = this.libraryTiles.stream().filter(p -> ((WorkspaceProject)p.getContent()).getName().toUpperCase().contains(filter.toUpperCase())).collect(Collectors.toList());
        this.updateView(filteredProjects);
        return filteredProjects;
    }

    private void updateView(Collection<TileWidget<WorkspaceProject>> projects) {
        this.view.clearProjects();
        this.projectCountUpdateEvent.fire((Object)new ProjectCountUpdate(projects.size(), this.getOrganizationalUnit().getSpace()));
        projects.forEach(project -> this.view.addProject((TileWidget<WorkspaceProject>)project));
    }

    private TileWidget<WorkspaceProject> createProjectWidget(WorkspaceProject project) {
        TileWidget tileWidget = (TileWidget)this.tileWidgets.get();
        tileWidget.setContent(project);
        if (project.getMainModule() != null) {
            POM pom = project.getMainModule().getPom();
            tileWidget.init(project.getName(), pom != null ? pom.getDescription() : "", this.selectCommand(project));
            this.updateAssetCount(tileWidget);
        } else {
            tileWidget.init(project.getName(), "", this.selectCommand(project));
        }
        this.libraryTiles.add(tileWidget);
        return tileWidget;
    }

    private void updateAssetCount(TileWidget<WorkspaceProject> tileWidget) {
        ((LibraryService)this.libraryService.call(tileWidget::setNumberOfAssets)).getNumberOfAssets(tileWidget.getContent());
    }

    public boolean userCanCreateProjects() {
        return this.projectController.canCreateProjects(this.libraryPlaces.getActiveSpace());
    }

    public int getProjectsCount() {
        return this.libraryTiles.size();
    }

    Command selectCommand(WorkspaceProject project) {
        return () -> this.libraryPlaces.goToProject(project);
    }

    public View getView() {
        return this.view;
    }

    public void onNewProjectEvent(@Observes NewProjectEvent e) {
        this.projectContext.getActiveOrganizationalUnit().ifPresent(organizationalUnit -> {
            if (this.eventOnCurrentSpace((OrganizationalUnit)organizationalUnit, e.getWorkspaceProject().getSpace())) {
                Optional<TileWidget<WorkspaceProject>> workspaceOptional = this.findTile(e.getWorkspaceProject());
                if (workspaceOptional.isPresent()) {
                    return;
                }
                TileWidget<WorkspaceProject> tile = this.createProjectWidget(e.getWorkspaceProject());
                Optional<TileWidget<WorkspaceProject>> optional = Optional.ofNullable(this.libraryTiles.higher(tile));
                if (optional.isPresent()) {
                    this.view.addProject(tile, optional.get());
                } else {
                    this.view.addProject(tile);
                }
                this.projectCountUpdateEvent.fire((Object)new ProjectCountUpdate(this.libraryTiles.size(), this.getOrganizationalUnit().getSpace()));
            }
        });
    }

    public void onRepositoryRemovedEvent(@Observes RepositoryRemovedEvent e) {
        this.projectContext.getActiveOrganizationalUnit().ifPresent(p -> {
            if (this.eventOnCurrentSpace((OrganizationalUnit)p, e.getRepository().getSpace())) {
                this.findTile(e.getRepository()).ifPresent(tile -> {
                    this.view.removeProject((TileWidget<WorkspaceProject>)tile);
                    this.libraryTiles.remove(tile);
                    this.tileWidgets.destroy(tile);
                    this.projectCountUpdateEvent.fire((Object)new ProjectCountUpdate(this.libraryTiles.size(), this.getOrganizationalUnit().getSpace()));
                });
            }
        });
    }

    private Optional<TileWidget<WorkspaceProject>> findTile(WorkspaceProject project) {
        return this.findTile((TileWidget<WorkspaceProject> tile) -> ((WorkspaceProject)tile.getContent()).equals((Object)project));
    }

    private Optional<TileWidget<WorkspaceProject>> findTile(Repository repository) {
        return this.findTile((TileWidget<WorkspaceProject> tile) -> ((WorkspaceProject)tile.getContent()).getRepository().getIdentifier().equals(repository.getIdentifier()));
    }

    private Optional<TileWidget<WorkspaceProject>> findTile(Predicate<TileWidget<WorkspaceProject>> filter) {
        return this.libraryTiles.stream().filter(filter).findAny();
    }

    boolean eventOnCurrentSpace(OrganizationalUnit organizationalUnit, Space space) {
        return organizationalUnit.getSpace().getName().equalsIgnoreCase(space.getName());
    }

    public void onAssetListUpdated(@Observes @Routed ProjectAssetListUpdated event) {
        if (event.getProject().getSpace().equals((Object)this.getOrganizationalUnit().getSpace())) {
            this.findTile(event.getProject()).ifPresent(this::updateAssetCount);
        }
    }

    public static interface View
    extends UberElement<PopulatedLibraryScreen>,
    HasBusyIndicator {
        public void clearProjects();

        public void addProject(TileWidget<WorkspaceProject> var1);

        public void addProject(TileWidget<WorkspaceProject> var1, TileWidget<WorkspaceProject> var2);

        public void removeProject(TileWidget<WorkspaceProject> var1);

        public void addAction(HTMLElement var1);

        public void clearFilterText();
    }
}

