/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.library.client.screens.importrepository;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.user.client.ui.Widget;
import javax.inject.Inject;
import org.gwtbootstrap3.client.ui.Button;
import org.gwtbootstrap3.client.ui.ModalFooter;
import org.gwtbootstrap3.client.ui.constants.ButtonType;
import org.jboss.errai.common.client.dom.Anchor;
import org.jboss.errai.common.client.dom.Div;
import org.jboss.errai.common.client.dom.HTMLElement;
import org.jboss.errai.common.client.dom.Input;
import org.jboss.errai.common.client.dom.Span;
import org.jboss.errai.ui.client.local.api.IsElement;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.EventHandler;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.kie.workbench.common.screens.library.client.screens.importrepository.ImportRepositoryPopUpPresenter;
import org.uberfire.ext.editor.commons.client.file.popups.CommonModalBuilder;
import org.uberfire.ext.widgets.common.client.common.BusyPopup;
import org.uberfire.ext.widgets.common.client.common.popups.BaseModal;
import org.uberfire.ext.widgets.common.client.common.popups.footers.GenericModalFooter;
import org.uberfire.mvp.Command;

@Templated
public class ImportRepositoryPopUpView
implements ImportRepositoryPopUpPresenter.View,
IsElement {
    private ImportRepositoryPopUpPresenter presenter;
    @Inject
    private TranslationService ts;
    private BaseModal modal;
    @Inject
    @DataField(value="body")
    Div body;
    @Inject
    @DataField(value="error")
    Div error;
    @Inject
    @DataField(value="error-message")
    Span errorMessage;
    @Inject
    @DataField(value="repository-url")
    Input repositoryURL;
    @Inject
    @DataField(value="show-hide-authentication-options")
    Anchor showHideAuthenticationOptions;
    @Inject
    @DataField(value="authentication-options")
    Div authenticationOptions;
    @Inject
    @DataField(value="user-name")
    Input userName;
    @Inject
    @DataField(value="password")
    Input password;

    public void init(ImportRepositoryPopUpPresenter presenter) {
        this.presenter = presenter;
        this.modalSetup();
    }

    @Override
    public String getRepositoryURL() {
        return this.repositoryURL.getValue();
    }

    @Override
    public String getUserName() {
        String userName = this.userName.getValue();
        return userName == null || userName.isEmpty() ? null : userName;
    }

    @Override
    public String getPassword() {
        String password = this.password.getValue();
        return password == null || password.isEmpty() ? null : password;
    }

    @Override
    public void show() {
        this.errorSetup();
        this.authenticationOptions.setHidden(true);
        this.modal.show();
    }

    @Override
    public void showError(String errorMessage) {
        this.errorMessage.setTextContent(errorMessage);
        this.error.setHidden(false);
    }

    @Override
    public String getLoadingMessage() {
        return this.ts.format("Loading", new Object[0]);
    }

    @Override
    public String getNoProjectsToImportMessage() {
        return this.ts.format("NoProjectsToImport", new Object[0]);
    }

    @Override
    public String getEmptyRepositoryURLValidationMessage() {
        String repositoryURL = this.ts.format("RepositoryURL", new Object[0]);
        return this.ts.format("EmptyFieldValidation", new Object[]{repositoryURL});
    }

    @Override
    public void hide() {
        this.modal.hide();
    }

    @EventHandler(value={"show-hide-authentication-options"})
    public void showAuthenticationOptions(ClickEvent clickEvent) {
        if (this.authenticationOptions.getHidden()) {
            this.authenticationOptions.setHidden(false);
            this.showHideAuthenticationOptions.setTextContent(this.ts.format("HideAuthenticationOptions", new Object[0]));
        } else {
            this.authenticationOptions.setHidden(true);
            this.showHideAuthenticationOptions.setTextContent(this.ts.format("ShowAuthenticationOptions", new Object[0]));
            this.userName.setValue("");
            this.password.setValue("");
        }
    }

    private void modalSetup() {
        this.modal = new CommonModalBuilder().addHeader(this.ts.format("ImportProject", new Object[0])).addBody((HTMLElement)this.body).addFooter(this.footer()).build();
    }

    private ModalFooter footer() {
        GenericModalFooter footer = new GenericModalFooter();
        footer.add((Widget)this.cancelButton());
        footer.add((Widget)this.addButton());
        return footer;
    }

    private Button addButton() {
        return this.button(this.ts.format("Import", new Object[0]), () -> this.presenter.importRepository(), ButtonType.PRIMARY);
    }

    private Button cancelButton() {
        return this.button(this.ts.format("Cancel", new Object[0]), () -> this.presenter.cancel(), ButtonType.DEFAULT);
    }

    private void errorSetup() {
        this.error.setHidden(true);
    }

    private Button button(String text, Command command, ButtonType type) {
        Button button = new Button(text, event -> command.execute());
        button.setType(type);
        return button;
    }

    public void showBusyIndicator(String message) {
        BusyPopup.showMessage((String)message);
    }

    public void hideBusyIndicator() {
        BusyPopup.close();
    }
}

