/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.library.client.screens.organizationalunit.contributors.tab;

import elemental2.promise.Promise;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.jboss.errai.common.client.dom.HTMLElement;
import org.jboss.errai.common.client.dom.elemental2.Elemental2DomUtil;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.kie.workbench.common.screens.library.client.screens.organizationalunit.contributors.tab.ContributorsListItemPresenter;
import org.kie.workbench.common.screens.library.client.screens.organizationalunit.contributors.tab.ContributorsListService;
import org.uberfire.client.mvp.UberElement;
import org.uberfire.client.promise.Promises;
import org.uberfire.security.Contributor;
import org.uberfire.security.ContributorType;

public class ContributorsListPresenter {
    private View view;
    private ManagedInstance<ContributorsListItemPresenter> contributorsListItemPresenters;
    private Elemental2DomUtil elemental2DomUtil;
    Promises promises;
    ContributorsListService contributorsListService;
    Consumer<Integer> contributorsCountChangedCallback;
    List<Contributor> contributors;
    List<ContributorsListItemPresenter> items = new ArrayList<ContributorsListItemPresenter>();
    List<String> validUsernames;

    @Inject
    public ContributorsListPresenter(View view, ManagedInstance<ContributorsListItemPresenter> contributorsListItemPresenters, Elemental2DomUtil elemental2DomUtil, Promises promises) {
        this.view = view;
        this.contributorsListItemPresenters = contributorsListItemPresenters;
        this.elemental2DomUtil = elemental2DomUtil;
        this.promises = promises;
    }

    public void setup(ContributorsListService contributorsListService, Consumer<Integer> contributorsCountChangedCallback) {
        this.contributorsListService = contributorsListService;
        this.contributorsCountChangedCallback = contributorsCountChangedCallback;
        this.refresh();
        this.contributorsListService.onExternalChange(this::refresh);
    }

    public void refresh() {
        this.contributorsListService.getContributors(this::refresh);
    }

    private void refresh(Collection<Contributor> contributors) {
        this.contributors = new ArrayList<Contributor>(contributors);
        this.contributors.sort(Contributor.COMPARATOR);
        this.view.init(this);
        this.contributorsListService.getValidUsernames(validUsernames -> {
            this.validUsernames = validUsernames;
            this.updateContributors();
            this.contributorsCountChangedCallback.accept(contributors.size());
        });
    }

    public void updateContributors() {
        this.updateView(this.contributors);
    }

    public void filterContributors(String filter) {
        List<Contributor> filteredContributors = this.contributors.stream().filter(c -> c.getUsername().toUpperCase().contains(filter.toUpperCase())).collect(Collectors.toList());
        this.updateView(filteredContributors);
    }

    private void updateView(List<Contributor> contributors) {
        this.view.clearContributors();
        this.items = new ArrayList<ContributorsListItemPresenter>();
        contributors.stream().forEach(contributor -> {
            ContributorsListItemPresenter contributorsListItemPresenter = (ContributorsListItemPresenter)this.contributorsListItemPresenters.get();
            contributorsListItemPresenter.setup((Contributor)contributor, this, this.contributorsListService);
            this.view.addContributor(this.elemental2DomUtil.asHTMLElement(contributorsListItemPresenter.getView().getElement()));
            this.items.add(contributorsListItemPresenter);
        });
    }

    public void addContributor() {
        this.canEditContributors(ContributorType.CONTRIBUTOR).then(canEditContributors -> {
            if (canEditContributors.booleanValue()) {
                this.itemIsBeingEdited();
                ContributorsListItemPresenter newContributorItem = (ContributorsListItemPresenter)this.contributorsListItemPresenters.get();
                newContributorItem.setupNew(this, this.contributorsListService);
                this.view.addNewContributor(this.elemental2DomUtil.asHTMLElement(newContributorItem.getView().getElement()));
                this.items.add(newContributorItem);
            }
            return this.promises.resolve();
        });
    }

    public void itemIsBeingEdited() {
        this.items.stream().forEach(i -> i.hideActions());
        this.view.hideAddContributor();
    }

    public void itemIsNotBeingEdited() {
        this.items.stream().forEach(i -> i.showActions());
        this.view.showAddContributor();
    }

    public Promise<Boolean> canEditContributors(ContributorType type) {
        return this.contributorsListService.canEditContributors(this.contributors, type);
    }

    public List<String> getValidUsernames() {
        return this.validUsernames;
    }

    public View getView() {
        return this.view;
    }

    public static interface View
    extends UberElement<ContributorsListPresenter> {
        public void clearContributors();

        public void addContributor(HTMLElement var1);

        public void addNewContributor(HTMLElement var1);

        public void clearFilterText();

        public void showAddContributor();

        public void hideAddContributor();
    }
}

