/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.library.client.screens.project.branch.delete;

import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.guvnor.structure.repositories.Branch;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.ErrorCallback;
import org.kie.workbench.common.screens.library.api.LibraryService;
import org.kie.workbench.common.screens.library.client.util.LibraryPlaces;
import org.uberfire.client.mvp.UberElemental;
import org.uberfire.ext.widgets.common.client.callbacks.HasBusyIndicatorDefaultErrorCallback;
import org.uberfire.ext.widgets.common.client.common.HasBusyIndicator;

public class DeleteBranchPopUpScreen {
    private Branch branch;
    private View view;
    private Caller<LibraryService> libraryService;
    private LibraryPlaces libraryPlaces;

    @Inject
    public DeleteBranchPopUpScreen(View view, Caller<LibraryService> libraryService, LibraryPlaces libraryPlaces) {
        this.view = view;
        this.libraryService = libraryService;
        this.libraryPlaces = libraryPlaces;
    }

    @PostConstruct
    public void setup() {
        this.view.init(this);
    }

    public void show(Branch branch) {
        this.branch = branch;
        this.view.show(branch.getName());
    }

    public void delete() {
        String confirmedName = this.view.getConfirmedName();
        if (!this.branch.getName().equals(confirmedName)) {
            this.view.showError(this.view.getWrongConfirmedNameValidationMessage());
            return;
        }
        this.view.showBusyIndicator(this.view.getDeletingMessage());
        ((LibraryService)this.libraryService.call(v -> {
            this.view.hideBusyIndicator();
            this.view.hide();
        }, (ErrorCallback)new HasBusyIndicatorDefaultErrorCallback((HasBusyIndicator)this.view))).removeBranch(this.libraryPlaces.getActiveWorkspace(), this.branch);
    }

    public void cancel() {
        this.view.hide();
    }

    public static interface View
    extends UberElemental<DeleteBranchPopUpScreen>,
    HasBusyIndicator {
        public String getConfirmedName();

        public void show(String var1);

        public void showError(String var1);

        public void hide();

        public String getWrongConfirmedNameValidationMessage();

        public String getDeletingMessage();
    }
}

