/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.library.client.screens.project.changerequest.review.tab.overview;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.KeyUpEvent;
import elemental2.dom.HTMLAnchorElement;
import elemental2.dom.HTMLButtonElement;
import elemental2.dom.HTMLDivElement;
import elemental2.dom.HTMLElement;
import elemental2.dom.HTMLInputElement;
import elemental2.dom.HTMLLabelElement;
import elemental2.dom.HTMLTextAreaElement;
import elemental2.dom.Node;
import javax.inject.Inject;
import javax.inject.Named;
import org.gwtbootstrap3.client.ui.HelpBlock;
import org.jboss.errai.common.client.dom.elemental2.Elemental2DomUtil;
import org.jboss.errai.ui.client.local.api.elemental2.IsElement;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.EventHandler;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.kie.workbench.common.screens.library.client.screens.project.changerequest.review.comment.CommentItemPresenter;
import org.kie.workbench.common.screens.library.client.screens.project.changerequest.review.tab.overview.OverviewScreenPresenter;
import org.uberfire.client.views.pfly.widgets.ValidationState;

@Templated
public class OverviewScreenView
implements OverviewScreenPresenter.View,
IsElement {
    private static final String PLACE_HOLDER = "placeholder";
    private static final String EMPTY_CONTENT = "";
    private OverviewScreenPresenter presenter;
    @Inject
    @DataField(value="status")
    @Named(value="span")
    private HTMLElement status;
    @Inject
    @DataField(value="author")
    @Named(value="span")
    private HTMLElement author;
    @Inject
    @DataField(value="created-date")
    @Named(value="span")
    private HTMLElement createdDate;
    @Inject
    @DataField(value="summary")
    @Named(value="span")
    private HTMLElement summary;
    @Inject
    @DataField(value="edit-summary")
    private HTMLAnchorElement editSummary;
    @Inject
    @DataField(value="summary-edit-group")
    private HTMLDivElement summaryEditGroup;
    @Inject
    @DataField(value="summary-edit-input")
    private HTMLInputElement summaryEditInput;
    @Inject
    @DataField(value="summary-edit-save")
    private HTMLButtonElement summaryEditSave;
    @Inject
    @DataField(value="summary-edit-cancel")
    private HTMLButtonElement summaryEditCancel;
    @Inject
    @DataField(value="clear-summary-button")
    private HTMLButtonElement clearSummary;
    @Inject
    @DataField(value="description")
    @Named(value="pre")
    private HTMLElement description;
    @Inject
    @DataField(value="edit-description")
    private HTMLAnchorElement editDescription;
    @Inject
    @DataField(value="description-edit-group")
    private HTMLDivElement descriptionEditGroup;
    @Inject
    @DataField(value="description-edit-input")
    private HTMLTextAreaElement descriptionEditInput;
    @Inject
    @DataField(value="description-edit-save")
    private HTMLButtonElement descriptionEditSave;
    @Inject
    @DataField(value="description-edit-cancel")
    private HTMLButtonElement descriptionEditCancel;
    @Inject
    @DataField(value="source-branch")
    @Named(value="span")
    private HTMLElement sourceBranch;
    @Inject
    @DataField(value="target-branch")
    @Named(value="span")
    private HTMLElement targetBranch;
    @Inject
    @DataField(value="comment-list")
    private HTMLDivElement commentList;
    @Inject
    @DataField(value="add-comment-button")
    private HTMLButtonElement addCommentButton;
    @Inject
    @DataField(value="comment-input-group")
    private HTMLDivElement commentInputGroup;
    @Inject
    @DataField(value="comment-input-help-inline")
    private HelpBlock commentInputHelpInline;
    @Inject
    @DataField(value="comment-input")
    private HTMLTextAreaElement commentInput;
    @Inject
    @DataField(value="conflict-warning")
    private HTMLDivElement conflictWarning;
    @Inject
    @DataField(value="comment-page-indicator")
    private HTMLLabelElement commentPageIndicator;
    @Inject
    @DataField(value="comment-total-pages")
    @Named(value="span")
    private HTMLElement commentTotalPages;
    @Inject
    @DataField(value="comment-current-page")
    private HTMLInputElement commentCurrentPage;
    @Inject
    @DataField(value="comment-prev-page")
    private HTMLButtonElement commentPrevPage;
    @Inject
    @DataField(value="comment-next-page")
    private HTMLButtonElement commentNextPage;
    @Inject
    @DataField(value="comments-toolbar")
    private HTMLDivElement commentsToolbar;
    @Inject
    @DataField(value="comments-header")
    @Named(value="h3")
    private HTMLElement commentsHeader;
    @Inject
    @DataField(value="revert-failed-tooltip")
    @Named(value="span")
    private HTMLElement revertFailedTooltip;
    @Inject
    private Elemental2DomUtil domUtil;

    public void init(OverviewScreenPresenter presenter) {
        this.presenter = presenter;
    }

    @Override
    public void setStatus(String status) {
        this.status.textContent = status;
    }

    @Override
    public void setAuthor(String author) {
        this.author.textContent = author;
    }

    @Override
    public void setCreatedDate(String createdDate) {
        this.createdDate.textContent = createdDate;
    }

    @Override
    public void setSummary(String summary) {
        this.summary.textContent = summary;
    }

    @Override
    public String getSummaryInputText() {
        return this.summaryEditInput.value;
    }

    @Override
    public void setDescription(String description) {
        this.description.textContent = description;
    }

    @Override
    public String getDescriptionInputText() {
        return this.descriptionEditInput.value;
    }

    @Override
    public void setSourceBranch(String sourceBranch) {
        this.sourceBranch.textContent = sourceBranch;
    }

    @Override
    public void setTargetBranch(String targetBranch) {
        this.targetBranch.textContent = targetBranch;
    }

    @Override
    public void setCommentsHeader(String header) {
        this.commentsHeader.textContent = header;
    }

    @Override
    public void setCommentInputPlaceHolder(String placeHolder) {
        this.commentInput.setAttribute(PLACE_HOLDER, placeHolder);
    }

    @Override
    public void addCommentItem(CommentItemPresenter.View item) {
        this.commentList.appendChild((Node)item.getElement());
    }

    @Override
    public void clearCommentList() {
        this.domUtil.removeAllElementChildren((Node)this.commentList);
    }

    @Override
    public void setCommentInputError(String errorMsg) {
        this.commentInputGroup.classList.add(new String[]{ValidationState.ERROR.getCssName()});
        this.commentInputHelpInline.setText(errorMsg);
    }

    @Override
    public void clearCommentInputError() {
        this.commentInputGroup.classList.remove(new String[]{ValidationState.ERROR.getCssName()});
        this.commentInputHelpInline.clearError();
    }

    @Override
    public String getCommentText() {
        return this.commentInput.value;
    }

    @Override
    public void clearCommentInputField() {
        this.commentInput.value = EMPTY_CONTENT;
        this.clearCommentInputError();
    }

    @Override
    public void enableSummaryEditMode(boolean isEnabled) {
        if (isEnabled) {
            this.summaryEditSave.disabled = true;
            this.summaryEditInput.value = this.summary.textContent;
            this.summary.hidden = true;
            this.editSummary.hidden = true;
            this.summaryEditGroup.hidden = false;
        } else {
            this.summary.hidden = false;
            this.editSummary.hidden = false;
            this.summaryEditGroup.hidden = true;
        }
    }

    @Override
    public void enableDescriptionEditMode(boolean isEnabled) {
        if (isEnabled) {
            this.descriptionEditSave.disabled = true;
            this.descriptionEditInput.value = this.description.textContent;
            this.description.hidden = true;
            this.editDescription.hidden = true;
            this.descriptionEditGroup.hidden = false;
        } else {
            this.description.hidden = false;
            this.editDescription.hidden = false;
            this.descriptionEditGroup.hidden = true;
        }
    }

    @Override
    public void showEditModes(boolean isVisible) {
        this.editSummary.hidden = !isVisible;
        this.editDescription.hidden = !isVisible;
    }

    @Override
    public void showConflictWarning(boolean isVisible) {
        this.conflictWarning.hidden = !isVisible;
    }

    @Override
    public void resetAll() {
        this.showCommentsToolbar(false);
        this.showConflictWarning(false);
        this.clearCommentInputField();
        this.clearCommentList();
        this.enableSummaryEditMode(false);
        this.enableDescriptionEditMode(false);
        this.showRevertFailedTooltip(false);
        this.summary.textContent = EMPTY_CONTENT;
        this.description.textContent = EMPTY_CONTENT;
        this.status.textContent = EMPTY_CONTENT;
        this.author.textContent = EMPTY_CONTENT;
        this.createdDate.textContent = EMPTY_CONTENT;
        this.sourceBranch.textContent = EMPTY_CONTENT;
        this.targetBranch.textContent = EMPTY_CONTENT;
        this.commentsHeader.textContent = EMPTY_CONTENT;
    }

    @Override
    public void setCommentCurrentPage(int currentPage) {
        this.commentCurrentPage.value = String.valueOf(currentPage);
    }

    @Override
    public void setCommentPageIndicator(String pageIndicatorText) {
        this.commentPageIndicator.textContent = pageIndicatorText;
    }

    @Override
    public void setCommentTotalPages(String totalText) {
        this.commentTotalPages.textContent = totalText;
    }

    @Override
    public void enableCommentPreviousButton(boolean isEnabled) {
        this.commentPrevPage.disabled = !isEnabled;
    }

    @Override
    public void enableCommentNextButton(boolean isEnabled) {
        this.commentNextPage.disabled = !isEnabled;
    }

    @Override
    public void showCommentsToolbar(boolean isVisible) {
        this.commentsToolbar.hidden = !isVisible;
    }

    @Override
    public void setRevertFailedTooltipText(String tooltip) {
        this.revertFailedTooltip.title = tooltip;
    }

    @Override
    public void showRevertFailedTooltip(boolean isVisible) {
        this.revertFailedTooltip.hidden = !isVisible;
    }

    @EventHandler(value={"add-comment-button"})
    public void onAddCommentButtonClicked(ClickEvent event) {
        this.presenter.addComment();
    }

    @EventHandler(value={"edit-summary"})
    public void onEditSummaryClicked(ClickEvent event) {
        this.presenter.startEditSummary();
    }

    @EventHandler(value={"edit-description"})
    public void onEditDescriptionClicked(ClickEvent event) {
        this.presenter.startEditDescription();
    }

    @EventHandler(value={"summary-edit-save"})
    public void onSummaryEditSaveClicked(ClickEvent event) {
        this.presenter.saveSummaryEdition();
    }

    @EventHandler(value={"summary-edit-cancel"})
    public void onSummaryEditCancelClicked(ClickEvent event) {
        this.presenter.cancelSummaryEdition();
    }

    @EventHandler(value={"description-edit-save"})
    public void onDescriptionEditSaveClicked(ClickEvent event) {
        this.presenter.saveDescriptionEdition();
    }

    @EventHandler(value={"description-edit-cancel"})
    public void onDescriptionEditCancelClicked(ClickEvent event) {
        this.presenter.cancelDescriptionEdition();
    }

    @EventHandler(value={"summary-edit-input"})
    public void onSummaryEditInputKeyUp(KeyUpEvent event) {
        this.checkSummarySaveButtonState();
    }

    @EventHandler(value={"description-edit-input"})
    public void onDescriptionEditInputKeyUp(KeyUpEvent event) {
        this.checkDescriptionSaveButtonState();
    }

    @EventHandler(value={"clear-summary-button"})
    public void onClearSummaryClicked(ClickEvent event) {
        this.summaryEditInput.value = EMPTY_CONTENT;
        this.checkSummarySaveButtonState();
        this.summaryEditInput.focus();
    }

    @EventHandler(value={"comment-current-page"})
    public void onCommentCurrentPageKeyUp(KeyUpEvent event) {
        String pageNumber = this.commentCurrentPage.value;
        if (pageNumber.matches("\\d+")) {
            this.presenter.setCommentCurrentPage(Integer.parseInt(pageNumber));
        }
    }

    @EventHandler(value={"comment-next-page"})
    public void onCommentNextPageClicked(ClickEvent event) {
        this.presenter.nextCommentPage();
    }

    @EventHandler(value={"comment-prev-page"})
    public void onCommentPrevPageClicked(ClickEvent event) {
        this.presenter.prevCommentPage();
    }

    private void checkSummarySaveButtonState() {
        this.summaryEditSave.disabled = this.summaryEditInput.value == null || this.summaryEditInput.value.trim().equals(EMPTY_CONTENT) || this.summaryEditInput.value.equals(this.summary.textContent);
    }

    private void checkDescriptionSaveButtonState() {
        this.descriptionEditSave.disabled = this.descriptionEditInput.value == null || this.descriptionEditInput.value.trim().equals(EMPTY_CONTENT) || this.descriptionEditInput.value.equals(this.description.textContent);
    }
}

