/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.library.client.screens.project.changerequest.submit;

import com.google.gwt.event.dom.client.ClickEvent;
import elemental2.dom.HTMLButtonElement;
import elemental2.dom.HTMLDivElement;
import elemental2.dom.HTMLInputElement;
import elemental2.dom.HTMLLabelElement;
import elemental2.dom.HTMLOptionElement;
import elemental2.dom.HTMLSelectElement;
import elemental2.dom.HTMLTextAreaElement;
import elemental2.dom.Node;
import java.util.List;
import javax.inject.Inject;
import org.gwtbootstrap3.client.ui.HelpBlock;
import org.jboss.errai.common.client.dom.elemental2.Elemental2DomUtil;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.jboss.errai.ui.client.local.api.elemental2.IsElement;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.EventHandler;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.kie.workbench.common.screens.library.client.screens.project.changerequest.diff.DiffItemPresenter;
import org.kie.workbench.common.screens.library.client.screens.project.changerequest.submit.SubmitChangeRequestScreenPresenter;
import org.uberfire.client.views.pfly.widgets.ValidationState;

@Templated
public class SubmitChangeRequestScreenView
implements SubmitChangeRequestScreenPresenter.View,
IsElement {
    private SubmitChangeRequestScreenPresenter presenter;
    @Inject
    @DataField(value="conflict-warning")
    private HTMLDivElement conflictWarning;
    @Inject
    @DataField(value="title")
    private HTMLDivElement title;
    @Inject
    @DataField(value="cancel")
    private HTMLButtonElement cancelButton;
    @Inject
    @DataField(value="submit")
    private HTMLButtonElement submitButton;
    @Inject
    @DataField(value="summary-group")
    private HTMLDivElement summaryGroup;
    @Inject
    @DataField(value="summary-help-inline")
    private HelpBlock summaryHelpInline;
    @Inject
    @DataField(value="summary")
    private HTMLInputElement summary;
    @Inject
    @DataField(value="description-group")
    private HTMLDivElement descriptionGroup;
    @Inject
    @DataField(value="description-help-inline")
    private HelpBlock descriptionHelpInline;
    @Inject
    @DataField(value="description")
    private HTMLTextAreaElement description;
    @Inject
    @DataField(value="branch-select")
    private HTMLSelectElement branchSelect;
    @Inject
    @DataField(value="files-summary")
    private HTMLLabelElement filesSummary;
    @Inject
    @DataField(value="diff-list")
    private HTMLDivElement diffList;
    @Inject
    private ManagedInstance<BranchOptionView> options;
    @Inject
    private Elemental2DomUtil domUtil;
    @Inject
    private TranslationService ts;

    public void init(SubmitChangeRequestScreenPresenter presenter) {
        this.presenter = presenter;
        this.branchSelect.onchange = this::onBranchSelectChange;
    }

    @Override
    public void setTitle(String title) {
        this.title.textContent = title;
    }

    @Override
    public void setDestinationBranches(List<String> branches, int selectedIdx) {
        this.branchSelect.innerHTML = "";
        branches.forEach(branch -> {
            BranchOptionView option = (BranchOptionView)this.options.get();
            option.setup((String)branch);
            this.branchSelect.appendChild((Node)option.getElement());
        });
        this.branchSelect.selectedIndex = selectedIdx;
    }

    @Override
    public void showWarning(boolean isVisible) {
        this.conflictWarning.hidden = !isVisible;
    }

    @Override
    public void addDiffItem(DiffItemPresenter.View item, Runnable draw) {
        this.diffList.appendChild((Node)item.getElement());
        draw.run();
    }

    @Override
    public String getSummary() {
        return this.summary.value;
    }

    @Override
    public String getDescription() {
        return this.description.value;
    }

    @Override
    public void setDescription(String description) {
        this.description.textContent = description;
    }

    @Override
    public void clearErrors() {
        this.summaryGroup.classList.remove(new String[]{ValidationState.ERROR.getCssName()});
        this.descriptionGroup.classList.remove(new String[]{ValidationState.ERROR.getCssName()});
        this.summaryHelpInline.clearError();
        this.descriptionHelpInline.clearError();
    }

    @Override
    public void clearDiffList() {
        this.domUtil.removeAllElementChildren((Node)this.diffList);
    }

    @Override
    public void setSummaryError() {
        this.summaryGroup.classList.add(new String[]{ValidationState.ERROR.getCssName()});
        this.summaryHelpInline.setText(this.ts.getTranslation("MissingSummaryForChangeRequestHelp"));
    }

    @Override
    public void setDescriptionError() {
        this.descriptionGroup.classList.add(new String[]{ValidationState.ERROR.getCssName()});
        this.descriptionHelpInline.setText(this.ts.getTranslation("MissingDescriptionForChangeRequestHelp"));
    }

    @Override
    public void showDiff(boolean isVisible) {
        this.diffList.hidden = !isVisible;
    }

    @Override
    public void clearInputFields() {
        this.summary.value = "";
        this.description.value = "";
        this.clearErrors();
    }

    @Override
    public void resetAll() {
        this.clearInputFields();
        this.showWarning(false);
        this.setFilesSummary("");
        this.showDiff(false);
    }

    @Override
    public void setFilesSummary(String text) {
        this.filesSummary.textContent = text;
    }

    @Override
    public void enableSubmitButton(boolean isEnabled) {
        this.submitButton.disabled = !isEnabled;
    }

    @EventHandler(value={"cancel"})
    public void onCancelClicked(ClickEvent event) {
        this.presenter.cancel();
    }

    @EventHandler(value={"submit"})
    public void onSubmitClicked(ClickEvent event) {
        this.presenter.submit();
    }

    private Object onBranchSelectChange(Object event) {
        this.presenter.selectBranch(this.branchSelect.value);
        return null;
    }

    @Templated(value="SubmitChangeRequestScreenView.html#branch-select-option")
    public static class BranchOptionView
    implements IsElement {
        @Inject
        @DataField(value="branch-select-option")
        HTMLOptionElement option;

        public void setup(String branchName) {
            this.option.value = branchName;
            this.option.innerHTML = branchName;
        }
    }
}

