/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.library.client.settings.sections.branchmanagement;

import elemental2.dom.Element;
import elemental2.promise.Promise;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.guvnor.common.services.project.client.security.ProjectController;
import org.guvnor.structure.organizationalunit.config.BranchPermissions;
import org.guvnor.structure.organizationalunit.config.RolePermissions;
import org.guvnor.structure.repositories.Branch;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.kie.workbench.common.screens.library.api.LibraryService;
import org.kie.workbench.common.screens.library.client.settings.SettingsSectionChange;
import org.kie.workbench.common.screens.library.client.settings.sections.branchmanagement.RoleItemPresenter;
import org.kie.workbench.common.screens.library.client.settings.util.sections.MenuItem;
import org.kie.workbench.common.screens.library.client.settings.util.sections.Section;
import org.kie.workbench.common.screens.library.client.settings.util.sections.SectionView;
import org.kie.workbench.common.screens.library.client.util.LibraryPlaces;
import org.kie.workbench.common.screens.projecteditor.model.ProjectScreenModel;
import org.kie.workbench.common.widgets.client.widget.KieSelectOption;
import org.kie.workbench.common.widgets.client.widget.ListPresenter;
import org.uberfire.client.promise.Promises;

public class BranchManagementPresenter
extends Section<ProjectScreenModel> {
    private final View view;
    private final Caller<LibraryService> libraryService;
    private final LibraryPlaces libraryPlaces;
    private final RoleAccessListPresenter roleAccessListPresenter;
    private final ProjectController projectController;
    String selectedBranch;
    Map<String, BranchPermissions> branchPermissionsByBranch = new HashMap<String, BranchPermissions>();

    @Inject
    public BranchManagementPresenter(View view, Promises promises, MenuItem<ProjectScreenModel> menuItem, Event<SettingsSectionChange<ProjectScreenModel>> settingsSectionChangeEvent, Caller<LibraryService> libraryService, LibraryPlaces libraryPlaces, RoleAccessListPresenter roleAccessListPresenter, ProjectController projectController) {
        super(settingsSectionChangeEvent, menuItem, promises);
        this.view = view;
        this.libraryService = libraryService;
        this.libraryPlaces = libraryPlaces;
        this.roleAccessListPresenter = roleAccessListPresenter;
        this.projectController = projectController;
    }

    @Override
    public Promise<Void> setup(ProjectScreenModel model) {
        return this.projectController.getUpdatableBranches(this.libraryPlaces.getActiveWorkspace()).then(branches -> {
            this.view.init(this);
            if (branches.isEmpty()) {
                this.view.showEmptyState();
                return this.promises.resolve();
            }
            this.selectedBranch = this.libraryPlaces.getActiveWorkspace().getBranch().getName();
            this.view.setupBranchSelect(branches.stream().map(Branch::getName).sorted(String::compareToIgnoreCase).map(p -> new KieSelectOption(p, p)).collect(Collectors.toList()), this.selectedBranch, this::setBranch);
            return this.setup(this.libraryPlaces.getActiveWorkspace().getBranch().getName());
        });
    }

    @Override
    Promise<Void> setup(String branch) {
        this.selectedBranch = branch;
        if (this.branchPermissionsByBranch.containsKey(this.selectedBranch)) {
            this.setupRolesTable(this.branchPermissionsByBranch.get(this.selectedBranch));
            return this.promises.resolve();
        }
        return this.promises.promisify(this.libraryService, service -> service.loadBranchPermissions(this.libraryPlaces.getActiveSpace().getName(), this.libraryPlaces.getActiveWorkspace().getRepository().getIdentifier(), this.selectedBranch)).then(result -> {
            this.branchPermissionsByBranch.put(this.selectedBranch, (BranchPermissions)result);
            this.setupRolesTable((BranchPermissions)result);
            return this.promises.resolve();
        });
    }

    private void setupRolesTable(BranchPermissions branchPermissions) {
        this.roleAccessListPresenter.setup(this.view.getRoleAccessTable(), branchPermissions.getPermissionsByRole().values().stream().sorted((o1, o2) -> o1.getRoleName().compareToIgnoreCase(o2.getRoleName())).collect(Collectors.toList()), (property, presenter) -> presenter.setup((RolePermissions)property, this));
    }

    @Override
    public Promise<Object> validate() {
        this.view.hideError();
        return this.promises.resolve();
    }

    void setBranch(String branchName) {
        this.selectedBranch = branchName;
        this.setup(branchName);
        this.fireChangeEvent();
    }

    @Override
    public Promise<Void> save(String comment, Supplier<Promise<Void>> chain) {
        return this.promises.all((Promise[])this.branchPermissionsByBranch.entrySet().stream().map(entry -> this.promises.promisify(this.libraryService, service -> service.saveBranchPermissions(this.libraryPlaces.getActiveSpace().getName(), this.libraryPlaces.getActiveWorkspace().getRepository().getIdentifier(), (String)entry.getKey(), (BranchPermissions)entry.getValue()))).toArray(Promise[]::new));
    }

    @Override
    public int currentHashCode() {
        return this.branchPermissionsByBranch.hashCode();
    }

    @Override
    public SectionView<?> getView() {
        return this.view;
    }

    @Dependent
    public static class RoleAccessListPresenter
    extends ListPresenter<RolePermissions, RoleItemPresenter> {
        @Inject
        public RoleAccessListPresenter(ManagedInstance<RoleItemPresenter> itemPresenters) {
            super(itemPresenters);
        }
    }

    public static interface View
    extends SectionView<BranchManagementPresenter> {
        public void showError(String var1);

        public void hideError();

        public Element getRoleAccessTable();

        public void setupBranchSelect(List<KieSelectOption> var1, String var2, Consumer<String> var3);

        public void showEmptyState();
    }
}

