/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.library.client.settings.sections.branchmanagement;

import elemental2.dom.Element;
import elemental2.dom.HTMLDivElement;
import elemental2.dom.HTMLElement;
import elemental2.dom.HTMLHeadingElement;
import elemental2.dom.HTMLTableSectionElement;
import elemental2.dom.Node;
import java.util.List;
import java.util.function.Consumer;
import javax.inject.Inject;
import javax.inject.Named;
import org.jboss.errai.common.client.dom.elemental2.Elemental2DomUtil;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.kie.workbench.common.screens.library.client.settings.sections.branchmanagement.BranchManagementPresenter;
import org.kie.workbench.common.widgets.client.widget.KieSelectElement;
import org.kie.workbench.common.widgets.client.widget.KieSelectOption;

@Templated
public class BranchManagementView
implements BranchManagementPresenter.View {
    private BranchManagementPresenter presenter;
    @Inject
    private TranslationService translationService;
    @Inject
    private Elemental2DomUtil elemental2DomUtil;
    @Inject
    @DataField(value="error")
    private HTMLDivElement error;
    @Inject
    @Named(value="span")
    @DataField(value="error-message")
    private HTMLElement errorMessage;
    @Inject
    @DataField(value="empty-state-container")
    private HTMLDivElement emptyStateContainer;
    @Inject
    @DataField(value="role-access-container")
    private HTMLDivElement roleAccessContainer;
    @Inject
    @Named(value="h3")
    @DataField(value="title")
    private HTMLHeadingElement title;
    @Inject
    @DataField(value="branches-select")
    private KieSelectElement branchesSelect;
    @Inject
    @Named(value="tbody")
    @DataField(value="role-access-table")
    private HTMLTableSectionElement roleAccessTable;
    @Inject
    @Named(value="span")
    @DataField(value="read-tooltip")
    private HTMLElement readTooltip;
    @Inject
    @Named(value="span")
    @DataField(value="write-tooltip")
    private HTMLElement writeTooltip;
    @Inject
    @Named(value="span")
    @DataField(value="delete-tooltip")
    private HTMLElement deleteTooltip;
    @Inject
    @Named(value="span")
    @DataField(value="deploy-tooltip")
    private HTMLElement deployTooltip;

    public void init(BranchManagementPresenter presenter) {
        this.presenter = presenter;
        this.hideError();
        this.emptyStateContainer.hidden = true;
        this.readTooltip.title = this.translationService.getTranslation("BranchManagementReadPermissionTooltip");
        this.writeTooltip.title = this.translationService.getTranslation("BranchManagementWritePermissionTooltip");
        this.deleteTooltip.title = this.translationService.getTranslation("BranchManagementDeletePermissionTooltip");
        this.deployTooltip.title = this.translationService.getTranslation("BranchManagementDeployPermissionTooltip");
    }

    @Override
    public void showError(String errorMessage) {
        this.errorMessage.innerHTML = this.errorMessage.innerHTML + errorMessage;
        this.errorMessage.innerHTML = this.errorMessage.innerHTML + "<br/>";
        this.error.hidden = false;
    }

    @Override
    public void hideError() {
        this.elemental2DomUtil.removeAllElementChildren((Node)this.errorMessage);
        this.error.hidden = true;
    }

    @Override
    public String getTitle() {
        return this.title.textContent;
    }

    @Override
    public Element getRoleAccessTable() {
        return this.roleAccessTable;
    }

    @Override
    public void setupBranchSelect(List<KieSelectOption> options, String initialValue, Consumer<String> onChange) {
        this.branchesSelect.setup(options, initialValue, onChange);
    }

    @Override
    public void showEmptyState() {
        this.emptyStateContainer.hidden = false;
        this.roleAccessContainer.hidden = true;
    }
}

