/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.library.client.settings.sections.branchmanagement;

import com.google.gwt.event.dom.client.ChangeEvent;
import elemental2.dom.HTMLElement;
import elemental2.dom.HTMLInputElement;
import javax.inject.Inject;
import javax.inject.Named;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.EventHandler;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.kie.workbench.common.screens.library.client.settings.sections.branchmanagement.RoleItemPresenter;
import org.uberfire.security.ContributorType;

@Templated(value="#root")
public class RoleItemView
implements RoleItemPresenter.View {
    @Inject
    private TranslationService ts;
    @Inject
    @Named(value="span")
    @DataField(value="role-name")
    private HTMLElement roleName;
    @Inject
    @DataField(value="read")
    private HTMLInputElement canRead;
    @Inject
    @DataField(value="write")
    private HTMLInputElement canWrite;
    @Inject
    @DataField(value="delete")
    private HTMLInputElement canDelete;
    @Inject
    @DataField(value="deploy")
    private HTMLInputElement canDeploy;
    private RoleItemPresenter presenter;

    public void init(RoleItemPresenter presenter) {
        this.presenter = presenter;
    }

    @Override
    public void setRoleName(String name) {
        this.roleName.innerHTML = ContributorType.OWNER.name().equals(name) ? this.ts.format("ContributorTypeOwner", new Object[0]) : (ContributorType.ADMIN.name().equals(name) ? this.ts.format("ContributorTypeAdmin", new Object[0]) : (ContributorType.CONTRIBUTOR.name().equals(name) ? this.ts.format("ContributorTypeContributor", new Object[0]) : name));
    }

    @Override
    public boolean canRead() {
        return this.canRead.checked;
    }

    @Override
    public void setCanRead(boolean canRead) {
        this.canRead.checked = canRead;
    }

    @Override
    public boolean canWrite() {
        return this.canWrite.checked;
    }

    @Override
    public void setCanWrite(boolean canWrite) {
        this.canWrite.checked = canWrite;
    }

    @Override
    public boolean canDelete() {
        return this.canDelete.checked;
    }

    @Override
    public void setCanDelete(boolean canDelete) {
        this.canDelete.checked = canDelete;
    }

    @Override
    public boolean canDeploy() {
        return this.canDeploy.checked;
    }

    @Override
    public void setCanDeploy(boolean canDeploy) {
        this.canDeploy.checked = canDeploy;
    }

    @Override
    public void disableCanRead() {
        this.canRead.disabled = true;
    }

    @EventHandler(value={"read"})
    public void onCanReadChanged(ChangeEvent ignore) {
        this.presenter.setCanRead(this.canRead.checked);
    }

    @EventHandler(value={"write"})
    public void onCanWriteChanged(ChangeEvent ignore) {
        this.presenter.setCanWrite(this.canWrite.checked);
    }

    @EventHandler(value={"delete"})
    public void onCanDeleteChanged(ChangeEvent ignore) {
        this.presenter.setCanDelete(this.canDelete.checked);
    }

    @EventHandler(value={"deploy"})
    public void onCanDeployChanged(ChangeEvent ignore) {
        this.presenter.setCanDeploy(this.canDeploy.checked);
    }
}

