/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.library.client.settings.sections.generalsettings.version;

import elemental2.dom.HTMLElement;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.jboss.errai.common.client.api.elemental2.IsElement;
import org.kie.soup.commons.validation.PortablePreconditions;
import org.kie.workbench.common.screens.library.client.settings.sections.generalsettings.version.VersionEditorView;
import org.uberfire.mvp.ParameterizedCommand;

@Dependent
public class VersionEditor
implements VersionEditorView.Presenter,
IsElement {
    public static final String SNAPSHOT = "-SNAPSHOT";
    private final VersionEditorView view;
    private String version;
    private ParameterizedCommand<String> changeVersionCommand;

    @Inject
    public VersionEditor(VersionEditorView view) {
        this.view = view;
        view.init(this);
    }

    public void setUpVersion(String version, ParameterizedCommand<String> changeVersionCommand) {
        PortablePreconditions.checkNotNull((String)"version", (Object)version);
        PortablePreconditions.checkNotNull((String)"changeVersionCommand", changeVersionCommand);
        this.changeVersionCommand = changeVersionCommand;
        this.setupDevMode(version);
    }

    private void setupDevMode(String version) {
        this.version = version;
        boolean isSnapshot = this.isSnapshot(version);
        if (isSnapshot) {
            version = this.removeSnapshot(version);
        }
        this.view.setVersion(version);
        this.view.setDevelopmentMode(isSnapshot);
    }

    private boolean isSnapshot(String version) {
        return version.toUpperCase().endsWith(SNAPSHOT);
    }

    private String removeSnapshot(String version) {
        if (this.isSnapshot(version)) {
            int index = version.toUpperCase().indexOf(SNAPSHOT);
            return version.substring(0, index);
        }
        return version;
    }

    @Override
    public void toggleDevelopmentMode(boolean selected) {
        if (selected != this.isSnapshot(this.version)) {
            if (selected) {
                this.doSetVersion(this.version + SNAPSHOT);
            } else {
                this.doSetVersion(this.removeSnapshot(this.version));
            }
        }
    }

    @Override
    public void notifyVersionChange(String version) {
        boolean snapshot = this.isSnapshot(version = this.normalizeVersion(version));
        if (!snapshot && this.view.isDevelopmentMode()) {
            version = version + SNAPSHOT;
        }
        this.doSetVersion(version);
    }

    private void doSetVersion(String version) {
        this.setupDevMode(version);
        if (this.changeVersionCommand != null) {
            this.changeVersionCommand.execute((Object)version);
        }
    }

    private String normalizeVersion(String version) {
        if (this.isSnapshot(version)) {
            return this.removeSnapshot(version) + SNAPSHOT;
        }
        return version;
    }

    public String getVersion() {
        return this.view.getVersion();
    }

    public HTMLElement getElement() {
        return this.view.getElement();
    }
}

