/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.library.client.util;

import com.google.gwt.user.client.Window;
import elemental2.promise.IThenable;
import elemental2.promise.Promise;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.guvnor.common.services.project.client.context.WorkspaceProjectContext;
import org.guvnor.common.services.project.context.WorkspaceProjectContextChangeEvent;
import org.guvnor.common.services.project.context.WorkspaceProjectContextChangeHandler;
import org.guvnor.common.services.project.model.Module;
import org.guvnor.common.services.project.model.WorkspaceProject;
import org.guvnor.common.services.project.service.WorkspaceProjectService;
import org.guvnor.structure.client.security.OrganizationalUnitController;
import org.guvnor.structure.organizationalunit.OrganizationalUnit;
import org.guvnor.structure.organizationalunit.OrganizationalUnitService;
import org.guvnor.structure.organizationalunit.RemoveOrganizationalUnitEvent;
import org.guvnor.structure.repositories.Branch;
import org.guvnor.structure.repositories.Repository;
import org.guvnor.structure.repositories.RepositoryRemovedEvent;
import org.guvnor.structure.repositories.RepositoryService;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.ErrorCallback;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.jboss.errai.security.shared.exception.UnauthorizedException;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.kie.soup.commons.validation.PortablePreconditions;
import org.kie.workbench.common.screens.examples.model.ImportProject;
import org.kie.workbench.common.screens.explorer.client.utils.Utils;
import org.kie.workbench.common.screens.library.api.LibraryService;
import org.kie.workbench.common.screens.library.api.ProjectAssetListUpdated;
import org.kie.workbench.common.screens.library.api.Remote;
import org.kie.workbench.common.screens.library.api.Routed;
import org.kie.workbench.common.screens.library.client.events.AssetDetailEvent;
import org.kie.workbench.common.screens.library.client.perspective.LibraryPerspective;
import org.kie.workbench.common.screens.library.client.screens.importrepository.ImportProjectsSetupEvent;
import org.kie.workbench.common.screens.library.client.screens.importrepository.ImportRepositoryPopUpPresenter;
import org.kie.workbench.common.screens.library.client.screens.importrepository.Source;
import org.kie.workbench.common.screens.library.client.screens.project.close.CloseUnsavedProjectAssetsPopUpPresenter;
import org.kie.workbench.common.screens.library.client.util.TranslationUtils;
import org.kie.workbench.common.screens.library.client.util.breadcrumb.LibraryBreadcrumbs;
import org.kie.workbench.common.services.shared.project.KieModuleService;
import org.kie.workbench.common.widgets.client.handlers.NewResourceSuccessEvent;
import org.slf4j.Logger;
import org.uberfire.backend.vfs.ObservablePath;
import org.uberfire.backend.vfs.Path;
import org.uberfire.backend.vfs.VFSService;
import org.uberfire.client.mvp.PerspectiveManager;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.client.promise.Promises;
import org.uberfire.client.util.Cookie;
import org.uberfire.client.workbench.events.PlaceGainFocusEvent;
import org.uberfire.ext.editor.commons.client.event.ConcurrentDeleteAcceptedEvent;
import org.uberfire.ext.editor.commons.client.event.ConcurrentRenameAcceptedEvent;
import org.uberfire.ext.preferences.client.event.PreferencesCentralSaveEvent;
import org.uberfire.ext.preferences.client.event.PreferencesCentralUndoChangesEvent;
import org.uberfire.ext.widgets.common.client.breadcrumbs.UberfireBreadcrumbs;
import org.uberfire.ext.widgets.common.client.callbacks.HasBusyIndicatorDefaultErrorCallback;
import org.uberfire.ext.widgets.common.client.common.HasBusyIndicator;
import org.uberfire.mvp.Command;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.mvp.impl.DefaultPlaceRequest;
import org.uberfire.mvp.impl.PathPlaceRequest;
import org.uberfire.rpc.SessionInfo;
import org.uberfire.spaces.Space;
import org.uberfire.workbench.events.NotificationEvent;
import org.uberfire.workbench.events.ResourceDeletedEvent;
import org.uberfire.workbench.model.PartDefinition;
import org.uberfire.workbench.model.impl.PartDefinitionImpl;

@ApplicationScoped
public class LibraryPlaces
implements WorkspaceProjectContextChangeHandler {
    public static final String LIBRARY_PERSPECTIVE = "LibraryPerspective";
    public static final String LIBRARY_SCREEN = "LibraryScreen";
    public static final String PROJECT_SCREEN = "ProjectScreen";
    public static final String IMPORT_PROJECTS_SCREEN = "ImportProjectsScreen";
    public static final String IMPORT_SAMPLE_PROJECTS_SCREEN = "TrySamplesScreen";
    public static final String PROJECT_DETAIL_SCREEN = "ProjectsDetailScreen";
    public static final String ORG_UNITS_METRICS_SCREEN = "OrgUnitsMetricsScreen";
    public static final String PROJECT_METRICS_SCREEN = "ProjectMetricsScreen";
    public static final String ORGANIZATIONAL_UNITS_SCREEN = "LibraryOrganizationalUnitsScreen";
    public static final String PROJECT_SETTINGS = "ProjectSettings";
    public static final String PROJECT_EXPLORER = "org.kie.guvnor.explorer";
    public static final String ALERTS = "org.kie.workbench.common.screens.messageconsole.MessageConsole";
    public static final String REPOSITORY_STRUCTURE_SCREEN = "repositoryStructureScreen";
    public static final String ADD_ASSET_SCREEN = "AddAssetsScreen";
    public static final String SUBMIT_CHANGE_REQUEST = "SubmitChangeRequestScreen";
    public static final String CHANGE_REQUEST_REVIEW = "ChangeRequestReviewScreen";
    public static final List<String> LIBRARY_PLACES = Arrays.asList("LibraryScreen", "OrgUnitsMetricsScreen", "ProjectScreen", "ProjectMetricsScreen", "ProjectsDetailScreen", "LibraryOrganizationalUnitsScreen", "ProjectSettings", "AddAssetsScreen", "SubmitChangeRequestScreen", "ChangeRequestReviewScreen", "ImportProjectsScreen", "TrySamplesScreen", "PreferencesRootScreen");
    private UberfireBreadcrumbs breadcrumbs;
    private TranslationService ts;
    private Event<AssetDetailEvent> assetDetailEvent;
    private Caller<LibraryService> libraryService;
    private Caller<WorkspaceProjectService> projectService;
    private Caller<KieModuleService> moduleService;
    private PlaceManager placeManager;
    private LibraryPerspective libraryPerspective;
    private WorkspaceProjectContext projectContext;
    private Event<WorkspaceProjectContextChangeEvent> projectContextChangeEvent;
    private Event<NotificationEvent> notificationEvent;
    private TranslationUtils translationUtils;
    private Caller<VFSService> vfsService;
    private ManagedInstance<ImportRepositoryPopUpPresenter> importRepositoryPopUpPresenters;
    private Event<ProjectAssetListUpdated> assetListUpdatedEvent;
    private CloseUnsavedProjectAssetsPopUpPresenter closeUnsavedProjectAssetsPopUpPresenter;
    private Event<ImportProjectsSetupEvent> importProjectsSetupEvent;
    private LibraryBreadcrumbs libraryBreadcrumbs;
    private SessionInfo sessionInfo;
    private Caller<RepositoryService> repositoryService;
    private OrganizationalUnitController organizationalUnitController;
    private Promises promises;
    private Caller<OrganizationalUnitService> organizationalUnitService;
    private Logger logger;
    private boolean closingLibraryPlaces = false;
    private PlaceRequest changeRequestReviewScreen = null;
    private Cookie cookie;
    private PerspectiveManager perspectiveManager;
    private static LibraryPlaces self;

    public LibraryPlaces() {
    }

    @Inject
    public LibraryPlaces(UberfireBreadcrumbs breadcrumbs, TranslationService ts, Event<AssetDetailEvent> assetDetailEvent, Caller<LibraryService> libraryService, Caller<WorkspaceProjectService> projectService, Caller<KieModuleService> moduleService, PlaceManager placeManager, WorkspaceProjectContext projectContext, Event<WorkspaceProjectContextChangeEvent> projectContextChangeEvent, Event<NotificationEvent> notificationEvent, TranslationUtils translationUtils, Caller<VFSService> vfsService, ManagedInstance<ImportRepositoryPopUpPresenter> importRepositoryPopUpPresenters, @Routed Event<ProjectAssetListUpdated> assetListUpdatedEvent, CloseUnsavedProjectAssetsPopUpPresenter closeUnsavedProjectAssetsPopUpPresenter, @Source(value=Source.Kind.EXTERNAL) Event<ImportProjectsSetupEvent> importProjectsSetupEvent, LibraryBreadcrumbs libraryBreadcrumbs, SessionInfo sessionInfo, Caller<RepositoryService> repositoryService, Promises promises, OrganizationalUnitController organizationalUnitController, Caller<OrganizationalUnitService> organizationalUnitService, Logger logger, Cookie cookie, PerspectiveManager perspectiveManager) {
        this.breadcrumbs = breadcrumbs;
        this.ts = ts;
        this.assetDetailEvent = assetDetailEvent;
        this.libraryService = libraryService;
        this.projectService = projectService;
        this.moduleService = moduleService;
        this.placeManager = placeManager;
        this.projectContext = projectContext;
        this.projectContextChangeEvent = projectContextChangeEvent;
        this.notificationEvent = notificationEvent;
        this.translationUtils = translationUtils;
        this.vfsService = vfsService;
        this.importRepositoryPopUpPresenters = importRepositoryPopUpPresenters;
        this.assetListUpdatedEvent = assetListUpdatedEvent;
        this.closeUnsavedProjectAssetsPopUpPresenter = closeUnsavedProjectAssetsPopUpPresenter;
        this.importProjectsSetupEvent = importProjectsSetupEvent;
        this.libraryBreadcrumbs = libraryBreadcrumbs;
        this.sessionInfo = sessionInfo;
        this.repositoryService = repositoryService;
        this.promises = promises;
        this.organizationalUnitController = organizationalUnitController;
        this.organizationalUnitService = organizationalUnitService;
        this.logger = logger;
        this.cookie = cookie;
        this.perspectiveManager = perspectiveManager;
    }

    @PostConstruct
    public void setup() {
        this.libraryBreadcrumbs.init(this);
        self = this;
        this.expose();
        this.projectContext.addChangeHandler((WorkspaceProjectContextChangeHandler)this);
        this.placeManager.registerPerspectiveCloseChain(LIBRARY_PERSPECTIVE, (chain, place) -> {
            if (LIBRARY_PERSPECTIVE.equals(place.getIdentifier())) {
                this.closeAllPlacesOrNothing(() -> ((Command)chain).execute());
            } else {
                this.closePlace(() -> ((Command)chain).execute(), (PlaceRequest)place);
            }
        });
    }

    public static Object nativeGoToSpace(String spaceName) {
        return LibraryPlaces.self.promises.promisify(LibraryPlaces.self.organizationalUnitService, s -> s.getOrganizationalUnit(spaceName)).then(space -> {
            if (space == null) {
                LibraryPlaces.self.cookie.clear(self.getLastSpaceCookie());
            } else {
                LibraryPlaces.self.cookie.set(self.getLastSpaceCookie(), spaceName);
            }
            LibraryPlaces.self.projectContextChangeEvent.fire((Object)new WorkspaceProjectContextChangeEvent(space));
            return self.goToLibrary();
        });
    }

    public native void expose();

    public static boolean nativeUserCanCreateOrganizationalUnit() {
        return self.userCanCreateOrganizationalUnit();
    }

    public boolean userCanCreateOrganizationalUnit() {
        return this.organizationalUnitController.canCreateOrgUnits();
    }

    public void onSelectPlaceEvent(@Observes PlaceGainFocusEvent placeGainFocusEvent) {
        if (this.isLibraryPerspectiveOpen() && !this.closingLibraryPlaces) {
            PlaceRequest place = placeGainFocusEvent.getPlace();
            if (place instanceof PathPlaceRequest) {
                this.libraryBreadcrumbs.setupForAsset(this.getActiveWorkspace(), (Path)((PathPlaceRequest)place).getPath());
            } else if (!place.getIdentifier().equals(ALERTS) && this.isLibraryPlace(place)) {
                if (this.projectContext.getActiveWorkspaceProject().isPresent() && place.getIdentifier().equals(PROJECT_SCREEN)) {
                    this.libraryBreadcrumbs.setupForProject(this.getActiveWorkspace());
                } else if (this.projectContext.getActiveOrganizationalUnit().isPresent() && place.getIdentifier().equals(LIBRARY_SCREEN)) {
                    this.libraryBreadcrumbs.setupForSpace(this.getActiveSpace());
                }
            }
        }
    }

    public void onAssetListUpdateEvent(@Observes @Remote ProjectAssetListUpdated event) {
        this.assetListUpdatedEvent.fire((Object)event);
    }

    private boolean isLibraryPlace(PlaceRequest place) {
        return LIBRARY_PLACES.contains(place.getIdentifier());
    }

    public void onNewResourceCreated(@Observes NewResourceSuccessEvent newResourceSuccessEvent) {
        if (this.isLibraryPerspectiveOpen()) {
            this.assetDetailEvent.fire((Object)new AssetDetailEvent((WorkspaceProject)this.projectContext.getActiveWorkspaceProject().orElseThrow(() -> new IllegalStateException("Cannot fire asset detail event without an active project.")), newResourceSuccessEvent.getPath()));
            this.placeManager.closePlace(ADD_ASSET_SCREEN);
        }
    }

    public void onAssetRenamedAccepted(@Observes ConcurrentRenameAcceptedEvent concurrentRenameAcceptedEvent) {
        if (this.isLibraryPerspectiveOpen()) {
            ObservablePath path = concurrentRenameAcceptedEvent.getPath();
            this.goToAsset((Path)path);
            this.libraryBreadcrumbs.setupForAsset(this.getActiveWorkspace(), (Path)path);
        }
    }

    public void onProjectDeleted(@Observes RepositoryRemovedEvent repositoryRemovedEvent) {
        if (this.isLibraryPerspectiveOpen() && this.isRepoForActiveProject(repositoryRemovedEvent)) {
            WorkspaceProjectContextChangeEvent contextChangeEvent = this.projectContext.getActiveOrganizationalUnit().map(ou -> new WorkspaceProjectContextChangeEvent(ou)).orElseGet(() -> new WorkspaceProjectContextChangeEvent());
            this.projectContextChangeEvent.fire((Object)contextChangeEvent);
            this.closeAllPlaces();
            this.goToLibrary();
            this.notificationEvent.fire((Object)new NotificationEvent(this.ts.getTranslation("ProjectDeleted"), NotificationEvent.NotificationType.DEFAULT));
        }
    }

    private String getLastSpaceCookie() {
        return this.sessionInfo.getIdentity().getIdentifier() + "_lastSpace";
    }

    private String getLastProjectCookie() {
        return this.sessionInfo.getIdentity().getIdentifier() + "_lastProject";
    }

    private String getProjectLastBranchCookie(String projectName) {
        return this.sessionInfo.getIdentity().getIdentifier() + "_" + projectName + "_lastBranch";
    }

    public void deleteProject(WorkspaceProject project, HasBusyIndicator view) {
        ((RepositoryService)this.repositoryService.call(v -> view.hideBusyIndicator(), (ErrorCallback)new HasBusyIndicatorDefaultErrorCallback(view))).removeRepository(project.getSpace(), project.getRepository().getAlias());
    }

    private boolean isRepoForActiveProject(RepositoryRemovedEvent repositoryRemovedEvent) {
        return this.projectContext.getActiveWorkspaceProject().filter(project -> {
            Repository activeRepo = project.getRepository();
            Repository eventRepo = repositoryRemovedEvent.getRepository();
            return activeRepo.getIdentifier().equals(eventRepo.getIdentifier());
        }).isPresent();
    }

    public void onOrganizationalUnitRemoved(@Observes RemoveOrganizationalUnitEvent removedOrganizationalUnitEvent) {
        String loggedUser = this.sessionInfo.getIdentity().getIdentifier();
        if (this.isLibraryPerspectiveOpen() && !loggedUser.equals(removedOrganizationalUnitEvent.getUserName())) {
            this.projectContext.getActiveOrganizationalUnit().filter(active -> active.equals(removedOrganizationalUnitEvent.getOrganizationalUnit())).ifPresent(active -> this.goToOrganizationalUnits());
        }
    }

    public void onAssetSelected(@Observes AssetDetailEvent assetDetails) {
        this.goToAsset(assetDetails.getPath());
    }

    private boolean isLibraryPerspectiveOpen() {
        return this.perspectiveManager.getCurrentPerspective().getPlace().getIdentifier().equals(LIBRARY_PERSPECTIVE);
    }

    public void onPreferencesSave(@Observes PreferencesCentralSaveEvent event) {
        if (this.isLibraryPerspectiveOpen()) {
            this.goToProject();
        }
    }

    public void onPreferencesCancel(@Observes PreferencesCentralUndoChangesEvent event) {
        if (this.isLibraryPerspectiveOpen()) {
            this.goToProject();
        }
    }

    public void refresh(Command callback) {
        this.breadcrumbs.clearBreadcrumbs(LIBRARY_PERSPECTIVE);
        this.translationUtils.refresh(() -> ((Command)callback).execute());
    }

    public void goToOrganizationalUnits() {
        this.closeAllPlacesOrNothing(this::goToSpaces);
    }

    private void goToSpaces() {
        PortablePreconditions.checkNotNull((String)"libraryPerspective.closeAllPlacesOrNothing", (Object)this.libraryPerspective);
        this.projectContextChangeEvent.fire((Object)new WorkspaceProjectContextChangeEvent());
        DefaultPlaceRequest placeRequest = new DefaultPlaceRequest(ORGANIZATIONAL_UNITS_SCREEN);
        PartDefinitionImpl part = new PartDefinitionImpl((PlaceRequest)placeRequest);
        part.setSelectable(false);
        this.placeManager.goTo((PartDefinition)part, this.libraryPerspective.getRootPanel());
        this.libraryBreadcrumbs.setupForSpacesScreen();
    }

    public Promise<Void> goToLibrary() {
        if (!this.projectContext.getActiveOrganizationalUnit().isPresent()) {
            return this.promises.create((res, rej) -> {
                String lastSpace = this.cookie.get(self.getLastSpaceCookie());
                String lastProject = this.cookie.get(self.getLastProjectCookie());
                String lastBranch = this.cookie.get(self.getProjectLastBranchCookie(lastProject));
                if (!lastProject.equals("") && !lastBranch.equals("")) {
                    this.goToProject(lastSpace, lastProject, lastBranch);
                    return;
                }
                if (!lastSpace.equals("")) {
                    LibraryPlaces.nativeGoToSpace(lastSpace);
                    return;
                }
                ((LibraryService)this.libraryService.call(organizationalUnit -> {
                    this.goToOrganizationalUnits();
                    res.onInvoke((IThenable)null);
                }, (message, throwable) -> {
                    try {
                        throw throwable;
                    }
                    catch (UnauthorizedException ue) {
                        this.goToOrganizationalUnits();
                        res.onInvoke((IThenable)null);
                        return false;
                    }
                    catch (Throwable t) {
                        rej.onInvoke(null);
                        return true;
                    }
                })).getDefaultOrganizationalUnit();
            });
        }
        this.setupLibraryPerspective();
        return this.promises.resolve();
    }

    private void setupLibraryPerspective() {
        OrganizationalUnit activeOu = (OrganizationalUnit)this.projectContext.getActiveOrganizationalUnit().orElseThrow(() -> new IllegalStateException("Cannot setup library perspective without active space."));
        PortablePreconditions.checkNotNull((String)"libraryPerspective", (Object)this.libraryPerspective);
        DefaultPlaceRequest placeRequest = new DefaultPlaceRequest(LIBRARY_SCREEN);
        PartDefinitionImpl part = new PartDefinitionImpl((PlaceRequest)placeRequest);
        part.setSelectable(false);
        if (!this.projectContext.getActiveWorkspaceProject().isPresent()) {
            this.projectContextChangeEvent.fire((Object)new WorkspaceProjectContextChangeEvent(activeOu));
        }
        this.closeLibraryPlaces();
        this.placeManager.goTo((PartDefinition)part, this.libraryPerspective.getRootPanel());
        this.libraryBreadcrumbs.setupForSpace(activeOu);
    }

    public void goToProject(WorkspaceProject project) {
        if (this.projectContext.getActiveWorkspaceProject().map(activeProject -> !activeProject.equals((Object)project)).orElse(true).booleanValue()) {
            String lastBranch = this.cookie.get(this.getProjectLastBranchCookie(project.getName()));
            this.cookie.set(this.getLastProjectCookie(), project.getName());
            this.closeAllPlacesOrNothing(() -> {
                this.projectContextChangeEvent.fire((Object)new WorkspaceProjectContextChangeEvent(project, project.getMainModule()));
                if (!lastBranch.equals("")) {
                    this.goToProject(project.getSpace().getName(), project.getName(), lastBranch);
                } else {
                    this.goToProject(project, project.getBranch());
                }
            });
        } else {
            this.goToProject();
        }
    }

    public void goToProject(WorkspaceProject project, Branch branch) {
        ((WorkspaceProjectService)this.projectService.call(pro -> {
            this.cookie.set(this.getProjectLastBranchCookie(project.getName()), branch.getName(), 604800);
            this.goToProject((WorkspaceProject)pro);
        }, (o, throwable) -> {
            this.logger.info("Project " + project.getName() + " branch " + branch.getName() + " not found.");
            return false;
        })).resolveProject(project.getSpace(), branch);
    }

    void goToProject() {
        this.goToProject(() -> {});
    }

    public void goToProject(Path projectPath) {
        ((WorkspaceProjectService)this.projectService.call(project -> this.goToProject((WorkspaceProject)project, project.getBranch()), (o, throwable) -> {
            this.notificationEvent.fire((Object)new NotificationEvent(this.ts.format("InvalidProjectPath", new Object[0]), NotificationEvent.NotificationType.ERROR));
            return false;
        })).resolveProject(projectPath);
    }

    public void goToProject(String spaceName, String projectName, String branchName) {
        ((WorkspaceProjectService)this.projectService.call(project -> this.goToProject((WorkspaceProject)project), (o, throwable) -> {
            this.logger.info("Project " + projectName + " branch " + branchName + " not found.");
            LibraryPlaces.self.cookie.clear(self.getLastProjectCookie());
            LibraryPlaces.self.cookie.clear(self.getProjectLastBranchCookie(projectName));
            this.goToOrganizationalUnits();
            return false;
        })).resolveProject(new Space(spaceName), projectName, branchName);
    }

    private void goToProject(Command callback) {
        this.libraryBreadcrumbs.setupForProject((WorkspaceProject)this.projectContext.getActiveWorkspaceProject().orElseThrow(() -> new IllegalStateException("Cannot go to project when no project is active.")));
        PartDefinitionImpl part = new PartDefinitionImpl((PlaceRequest)new DefaultPlaceRequest(PROJECT_SCREEN));
        part.setSelectable(false);
        this.placeManager.goTo((PartDefinition)part, this.libraryPerspective.getRootPanel());
        if (callback != null) {
            callback.execute();
        }
    }

    public void goToAsset(Path path) {
        ((KieModuleService)this.moduleService.call(response -> {
            this.projectContextChangeEvent.fire((Object)new WorkspaceProjectContextChangeEvent((WorkspaceProject)this.projectContext.getActiveWorkspaceProject().orElse(null), (Module)this.projectContext.getActiveModule().orElse(null), response));
            PlaceRequest placeRequest = this.generatePlaceRequest(path);
            this.placeManager.goTo(placeRequest);
            if (path != null) {
                ObservablePath observablePath = ((PathPlaceRequest)placeRequest).getPath();
                observablePath.onRename(() -> this.libraryBreadcrumbs.setupForAsset(this.getActiveWorkspace(), (Path)observablePath));
            }
        })).resolvePackage(path);
    }

    public void goToAddAsset() {
        DefaultPlaceRequest addAssetScreen = new DefaultPlaceRequest(ADD_ASSET_SCREEN);
        PartDefinitionImpl part = new PartDefinitionImpl((PlaceRequest)addAssetScreen);
        part.setSelectable(false);
        this.placeManager.goTo((PartDefinition)part, this.libraryPerspective.getRootPanel());
    }

    public void goToSubmitChangeRequestScreen() {
        DefaultPlaceRequest submitChangeRequestScreen = new DefaultPlaceRequest(SUBMIT_CHANGE_REQUEST);
        PartDefinitionImpl part = new PartDefinitionImpl((PlaceRequest)submitChangeRequestScreen);
        part.setSelectable(false);
        this.placeManager.goTo((PartDefinition)part, this.libraryPerspective.getRootPanel());
        this.libraryBreadcrumbs.setupForSubmitChangeRequest(this.getActiveWorkspace());
    }

    public void goToChangeRequestReviewScreen(long changeRequestId) {
        this.closeChangeRequestReviewScreen();
        this.changeRequestReviewScreen = new DefaultPlaceRequest(CHANGE_REQUEST_REVIEW, Collections.singletonMap("CHANGE_REQUEST_ID", String.valueOf(changeRequestId)));
        PartDefinitionImpl part = new PartDefinitionImpl(this.changeRequestReviewScreen);
        part.setSelectable(false);
        this.placeManager.goTo((PartDefinition)part, this.libraryPerspective.getRootPanel());
        this.libraryBreadcrumbs.setupForChangeRequestReview(this.getActiveWorkspace(), changeRequestId);
    }

    public void goToTrySamples() {
        this.closeAllPlacesOrNothing(() -> {
            DefaultPlaceRequest placeRequest = new DefaultPlaceRequest(IMPORT_SAMPLE_PROJECTS_SCREEN);
            PartDefinitionImpl part = new PartDefinitionImpl((PlaceRequest)placeRequest);
            part.setSelectable(false);
            this.placeManager.goTo((PartDefinition)part, this.libraryPerspective.getRootPanel());
            this.libraryBreadcrumbs.setupForTrySamples(this.getActiveSpace());
        });
    }

    public void goToImportRepositoryPopUp() {
        ImportRepositoryPopUpPresenter importRepositoryPopUpPresenter = (ImportRepositoryPopUpPresenter)this.importRepositoryPopUpPresenters.get();
        importRepositoryPopUpPresenter.show();
    }

    public void goToExternalImportPresenter(Set<ImportProject> projects) {
        this.closeAllPlacesOrNothing(() -> {
            DefaultPlaceRequest placeRequest = new DefaultPlaceRequest(IMPORT_PROJECTS_SCREEN);
            PartDefinitionImpl part = new PartDefinitionImpl((PlaceRequest)placeRequest);
            part.setSelectable(false);
            this.placeManager.goTo((PartDefinition)part, this.libraryPerspective.getRootPanel());
            this.setupExternalImportBreadCrumbs();
            this.importProjectsSetupEvent.fire((Object)new ImportProjectsSetupEvent(projects));
        });
    }

    public void setupExternalImportBreadCrumbs() {
        this.breadcrumbs.clearBreadcrumbs(LIBRARY_PERSPECTIVE);
        this.breadcrumbs.addBreadCrumb(LIBRARY_PERSPECTIVE, this.translationUtils.getOrganizationalUnitAliasInPlural(), () -> this.goToOrganizationalUnits());
        this.breadcrumbs.addBreadCrumb(LIBRARY_PERSPECTIVE, ((OrganizationalUnit)this.projectContext.getActiveOrganizationalUnit().orElseThrow(() -> new IllegalStateException("Cannot create library breadcrumb without active space."))).getName(), () -> this.goToLibrary());
        this.breadcrumbs.addBreadCrumb(LIBRARY_PERSPECTIVE, this.ts.getTranslation("ImportProjects"), () -> this.goToImportRepositoryPopUp());
    }

    PlaceRequest generatePlaceRequest(Path path) {
        if (path == null) {
            return new DefaultPlaceRequest(PROJECT_SETTINGS);
        }
        return this.createPathPlaceRequest(path);
    }

    PathPlaceRequest createPathPlaceRequest(Path path) {
        return new PathPlaceRequest(path);
    }

    void closeLibraryPlaces() {
        this.closingLibraryPlaces = true;
        LIBRARY_PLACES.forEach(place -> this.placeManager.closePlace(place));
        this.closingLibraryPlaces = false;
    }

    public void closeAllPlacesOrNothing(Command successCallback) {
        this.closingLibraryPlaces = true;
        List uncloseablePlaces = this.placeManager.getUncloseablePlaces();
        if (uncloseablePlaces != null && uncloseablePlaces.isEmpty()) {
            this.placeManager.closeAllPlaces();
            this.closingLibraryPlaces = false;
            if (successCallback != null) {
                successCallback.execute();
            }
        } else {
            Command newSuccessCallback = () -> {
                this.placeManager.forceCloseAllPlaces();
                this.closingLibraryPlaces = false;
                if (successCallback != null) {
                    successCallback.execute();
                }
            };
            this.closeUnsavedProjectAssetsPopUpPresenter.show(this.getActiveWorkspace(), uncloseablePlaces, newSuccessCallback, () -> this.placeManager.goTo((PlaceRequest)uncloseablePlaces.get(0)));
        }
    }

    public void closeChangeRequestReviewScreen() {
        if (this.changeRequestReviewScreen != null) {
            this.placeManager.closePlace(this.changeRequestReviewScreen);
        }
    }

    public void closePlace(Command successCallback, PlaceRequest place) {
        boolean canClosePlace = this.placeManager.canClosePlace(place);
        if (canClosePlace) {
            if (successCallback != null) {
                successCallback.execute();
            }
        } else {
            Command newSuccessCallback = () -> {
                this.placeManager.forceClosePlace(place);
                if (successCallback != null) {
                    successCallback.execute();
                }
            };
            ArrayList<PlaceRequest> uncloseablePlaces = new ArrayList<PlaceRequest>();
            uncloseablePlaces.add(place);
            this.closeUnsavedProjectAssetsPopUpPresenter.show(this.getActiveWorkspace(), uncloseablePlaces, newSuccessCallback, () -> {});
        }
    }

    void closeAllPlaces() {
        this.closingLibraryPlaces = true;
        this.placeManager.closeAllPlaces();
        this.closingLibraryPlaces = false;
    }

    public WorkspaceProjectContext getWorkbenchContext() {
        return this.projectContext;
    }

    public WorkspaceProject getActiveWorkspace() {
        return (WorkspaceProject)this.projectContext.getActiveWorkspaceProject().orElseThrow(() -> new IllegalStateException("No active workspace project found"));
    }

    public OrganizationalUnit getActiveSpace() {
        return (OrganizationalUnit)this.projectContext.getActiveOrganizationalUnit().orElseThrow(() -> new IllegalStateException("No active space found"));
    }

    public boolean isThisUserAccessingThisRepository(String userIdentifier, Repository repository) {
        return this.isThisRepositoryBeingAccessed(repository) && this.sessionInfo.getIdentity().getIdentifier().equals(userIdentifier);
    }

    public boolean isThisRepositoryBeingAccessed(Repository repository) {
        Space space = repository.getSpace();
        String repositoryAlias = repository.getAlias();
        if (this.projectContext.getActiveOrganizationalUnit().isPresent() && this.projectContext.getActiveWorkspaceProject().isPresent()) {
            Space activeSpace = ((OrganizationalUnit)this.projectContext.getActiveOrganizationalUnit().get()).getSpace();
            Repository activeRepository = ((WorkspaceProject)this.projectContext.getActiveWorkspaceProject().get()).getRepository();
            String activeRepositoryAlias = activeRepository.getAlias();
            return space.equals((Object)activeSpace) && repositoryAlias.equals(activeRepositoryAlias);
        }
        return false;
    }

    public void init(LibraryPerspective libraryPerspective) {
        this.libraryPerspective = libraryPerspective;
    }

    public void onChange(WorkspaceProjectContextChangeEvent previous, WorkspaceProjectContextChangeEvent current) {
        if (current.getWorkspaceProject() != null && !this.isStandalone()) {
            if (Utils.hasRepositoryChanged((WorkspaceProject)previous.getWorkspaceProject(), (WorkspaceProject)current.getWorkspaceProject())) {
                this.closeAllPlacesOrNothing(this::goToProject);
            }
            if (Utils.hasModuleChanged((Module)previous.getModule(), (Module)current.getModule())) {
                this.libraryBreadcrumbs.setupForProject((WorkspaceProject)this.projectContext.getActiveWorkspaceProject().get());
            }
        }
    }

    public void onDeletedResource(@Observes ResourceDeletedEvent deleteFileEvent) {
        this.closePathPlace(deleteFileEvent.getPath());
    }

    public void onConcurrentDelete(@Observes ConcurrentDeleteAcceptedEvent concurrentDeleteAcceptedEvent) {
        this.closePathPlace((Path)concurrentDeleteAcceptedEvent.getPath());
    }

    private void closePathPlace(Path path) {
        this.placeManager.closePlace((PlaceRequest)new PathPlaceRequest(path));
    }

    private boolean isStandalone() {
        Map<String, List<String>> parameterMap = this.getParameterMap();
        if (parameterMap == null) {
            return false;
        }
        return parameterMap.containsKey("standalone");
    }

    protected Map<String, List<String>> getParameterMap() {
        return Window.Location.getParameterMap();
    }
}

