/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.library.client.util;

import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.dashbuilder.dataset.date.DayOfWeek;
import org.dashbuilder.dataset.filter.ColumnFilter;
import org.dashbuilder.dataset.filter.FilterFactory;
import org.dashbuilder.dataset.group.AggregateFunctionType;
import org.dashbuilder.dataset.group.DateIntervalType;
import org.dashbuilder.dataset.sort.SortOrder;
import org.dashbuilder.displayer.DisplayerSettings;
import org.dashbuilder.displayer.DisplayerSettingsFactory;
import org.dashbuilder.displayer.DisplayerSubType;
import org.dashbuilder.displayer.Position;
import org.dashbuilder.displayer.client.Displayer;
import org.dashbuilder.displayer.client.DisplayerLocator;
import org.dashbuilder.displayer.impl.AreaChartSettingsBuilderImpl;
import org.dashbuilder.displayer.impl.BarChartSettingsBuilderImpl;
import org.dashbuilder.displayer.impl.BubbleChartSettingsBuilderImpl;
import org.dashbuilder.displayer.impl.PieChartSettingsBuilderImpl;
import org.dashbuilder.displayer.impl.SelectorDisplayerSettingsBuilderImpl;
import org.dashbuilder.displayer.impl.TableDisplayerSettingsBuilderImpl;
import org.guvnor.structure.organizationalunit.OrganizationalUnit;
import org.jboss.errai.ui.client.local.spi.TranslationService;

@ApplicationScoped
public class OrgUnitsMetricsFactory {
    private TranslationService translationService;
    private DisplayerLocator displayerLocator;

    @Inject
    public OrgUnitsMetricsFactory(TranslationService translationService, DisplayerLocator displayerLocator) {
        this.translationService = translationService;
        this.displayerLocator = displayerLocator;
    }

    public Displayer lookupCommitsOverTimeDisplayer(OrganizationalUnit organizationalUnit) {
        DisplayerSettings settings = this.buildCommitsOverTimeSettings(organizationalUnit);
        return this.displayerLocator.lookupDisplayer(settings);
    }

    public Displayer lookupCommitsPerAuthorDisplayer(OrganizationalUnit organizationalUnit) {
        DisplayerSettings settings = this.buildCommitsPerAuthorSettings(organizationalUnit);
        return this.displayerLocator.lookupDisplayer(settings);
    }

    public Displayer lookupCommitsPerProjectDisplayer(OrganizationalUnit organizationalUnit) {
        DisplayerSettings settings = this.buildCommitsPerProjectSettings(organizationalUnit);
        return this.displayerLocator.lookupDisplayer(settings);
    }

    public Displayer lookupCommitsByYearDisplayer(OrganizationalUnit organizationalUnit) {
        DisplayerSettings settings = this.buildCommitsByYearSettings(organizationalUnit);
        return this.displayerLocator.lookupDisplayer(settings);
    }

    public Displayer lookupCommitsByQuarterDisplayer(OrganizationalUnit organizationalUnit) {
        DisplayerSettings settings = this.buildCommitsByQuarterSettings(organizationalUnit);
        return this.displayerLocator.lookupDisplayer(settings);
    }

    public Displayer lookupCommitsByDayOfWeekDisplayer(OrganizationalUnit organizationalUnit) {
        DisplayerSettings settings = this.buildCommitsByDayOfWeekSettings(organizationalUnit);
        return this.displayerLocator.lookupDisplayer(settings);
    }

    public Displayer lookupProjectSelectorDisplayer(OrganizationalUnit organizationalUnit) {
        DisplayerSettings settings = this.buildProjectSelectorSettings(organizationalUnit);
        return this.displayerLocator.lookupDisplayer(settings);
    }

    public Displayer lookupTopContributorSelectorDisplayer(OrganizationalUnit organizationalUnit) {
        DisplayerSettings settings = this.buildTopContributorSelectorSettings(organizationalUnit);
        return this.displayerLocator.lookupDisplayer(settings);
    }

    public Displayer lookupDateSelectorDisplayer(OrganizationalUnit organizationalUnit) {
        DisplayerSettings settings = this.buildDateSelectorSettings(organizationalUnit);
        return this.displayerLocator.lookupDisplayer(settings);
    }

    public Displayer lookupAllCommitsDisplayer(OrganizationalUnit organizationalUnit) {
        DisplayerSettings settings = this.buildAllCommitsSettings(organizationalUnit);
        return this.displayerLocator.lookupDisplayer(settings);
    }

    protected ColumnFilter createOrgUnitFilter(OrganizationalUnit organizationalUnit) {
        return FilterFactory.equalsTo((String)"organization", (Comparable)((Object)organizationalUnit.getName()));
    }

    public DisplayerSettings buildCommitsPerAuthorSettings(OrganizationalUnit organizationalUnit) {
        return ((BubbleChartSettingsBuilderImpl)((BubbleChartSettingsBuilderImpl)((BubbleChartSettingsBuilderImpl)((BubbleChartSettingsBuilderImpl)((BubbleChartSettingsBuilderImpl)((BubbleChartSettingsBuilderImpl)((BubbleChartSettingsBuilderImpl)((BubbleChartSettingsBuilderImpl)((BubbleChartSettingsBuilderImpl)((BubbleChartSettingsBuilderImpl)((BubbleChartSettingsBuilderImpl)((BubbleChartSettingsBuilderImpl)((BubbleChartSettingsBuilderImpl)((BubbleChartSettingsBuilderImpl)((BubbleChartSettingsBuilderImpl)((BubbleChartSettingsBuilderImpl)((BubbleChartSettingsBuilderImpl)((BubbleChartSettingsBuilderImpl)DisplayerSettingsFactory.newBubbleChartSettings().dataset("gitContributors")).filter(new ColumnFilter[]{this.createOrgUnitFilter(organizationalUnit)})).group("author")).column("author", this.translationService.getTranslation("Author"))).column("project", AggregateFunctionType.DISTINCT)).format(this.translationService.getTranslation("Projects"), "#,##0")).column(AggregateFunctionType.COUNT, "#commits")).format(this.translationService.getTranslation("NumberOfCommits"), "#,##0")).column("author", this.translationService.getTranslation("Author"))).column("author", AggregateFunctionType.DISTINCT)).format(this.translationService.getTranslation("Author"), "#,##0")).titleVisible(false)).width(450)).height(200)).margins(10, 40, 40, 0)).xAxisTitle(this.translationService.getTranslation("NumberOfProjects"))).yAxisTitle(this.translationService.getTranslation("NumberOfCommits"))).filterOff(true)).buildSettings();
    }

    public DisplayerSettings buildCommitsOverTimeSettings(OrganizationalUnit organizationalUnit) {
        return ((AreaChartSettingsBuilderImpl)((AreaChartSettingsBuilderImpl)((AreaChartSettingsBuilderImpl)((AreaChartSettingsBuilderImpl)((AreaChartSettingsBuilderImpl)((AreaChartSettingsBuilderImpl)((AreaChartSettingsBuilderImpl)((AreaChartSettingsBuilderImpl)((AreaChartSettingsBuilderImpl)((AreaChartSettingsBuilderImpl)((AreaChartSettingsBuilderImpl)((AreaChartSettingsBuilderImpl)((AreaChartSettingsBuilderImpl)DisplayerSettingsFactory.newAreaChartSettings().dataset("gitContributors")).filter(new ColumnFilter[]{this.createOrgUnitFilter(organizationalUnit)})).group("date")).dynamic(80, DateIntervalType.MONTH, true)).column("date", this.translationService.getTranslation("Date"))).column(AggregateFunctionType.COUNT, "#commits")).format(this.translationService.getTranslation("NumberOfCommits"), "#,##0")).titleVisible(false)).width(450)).height(145)).margins(10, 5, 40, 0)).yAxisTitle(this.translationService.getTranslation("NumberOfCommits"))).filterOff(true)).buildSettings();
    }

    public DisplayerSettings buildCommitsPerProjectSettings(OrganizationalUnit organizationalUnit) {
        return ((PieChartSettingsBuilderImpl)((PieChartSettingsBuilderImpl)((PieChartSettingsBuilderImpl)((PieChartSettingsBuilderImpl)((PieChartSettingsBuilderImpl)((PieChartSettingsBuilderImpl)((PieChartSettingsBuilderImpl)((PieChartSettingsBuilderImpl)((PieChartSettingsBuilderImpl)((PieChartSettingsBuilderImpl)((PieChartSettingsBuilderImpl)((PieChartSettingsBuilderImpl)((PieChartSettingsBuilderImpl)DisplayerSettingsFactory.newPieChartSettings().dataset("gitContributors")).filter(new ColumnFilter[]{this.createOrgUnitFilter(organizationalUnit)})).filter("project", new ColumnFilter[]{FilterFactory.notNull()})).group("project")).column("project")).column(AggregateFunctionType.COUNT, "#commits")).format(this.translationService.getTranslation("NumberOfCommits"), "#,##0")).titleVisible(false)).width(250)).height(170)).margins(10, 0, 10, 5)).legendOn(Position.RIGHT)).filterOn(false, true, true)).buildSettings();
    }

    public DisplayerSettings buildCommitsByYearSettings(OrganizationalUnit organizationalUnit) {
        return ((PieChartSettingsBuilderImpl)((PieChartSettingsBuilderImpl)((PieChartSettingsBuilderImpl)((PieChartSettingsBuilderImpl)((PieChartSettingsBuilderImpl)((PieChartSettingsBuilderImpl)((PieChartSettingsBuilderImpl)((PieChartSettingsBuilderImpl)((PieChartSettingsBuilderImpl)((PieChartSettingsBuilderImpl)((PieChartSettingsBuilderImpl)((PieChartSettingsBuilderImpl)((PieChartSettingsBuilderImpl)((PieChartSettingsBuilderImpl)((PieChartSettingsBuilderImpl)((PieChartSettingsBuilderImpl)DisplayerSettingsFactory.newPieChartSettings().dataset("gitContributors")).filter(new ColumnFilter[]{this.createOrgUnitFilter(organizationalUnit)})).filter("date", new ColumnFilter[]{FilterFactory.notNull()})).group("date")).dynamic(DateIntervalType.YEAR, false)).column("date")).column(AggregateFunctionType.COUNT, "#commits")).format(this.translationService.getTranslation("NumberOfCommits"), "#,##0")).sort("date", SortOrder.ASCENDING)).title(this.translationService.getTranslation("Years"))).titleVisible(false)).width(250)).height(170)).margins(10, 0, 10, 5)).legendOn(Position.RIGHT)).filterOn(false, true, true)).buildSettings();
    }

    public DisplayerSettings buildCommitsByQuarterSettings(OrganizationalUnit organizationalUnit) {
        return ((PieChartSettingsBuilderImpl)((PieChartSettingsBuilderImpl)((PieChartSettingsBuilderImpl)((PieChartSettingsBuilderImpl)((PieChartSettingsBuilderImpl)((PieChartSettingsBuilderImpl)((PieChartSettingsBuilderImpl)((PieChartSettingsBuilderImpl)((PieChartSettingsBuilderImpl)((PieChartSettingsBuilderImpl)((PieChartSettingsBuilderImpl)((PieChartSettingsBuilderImpl)((PieChartSettingsBuilderImpl)((PieChartSettingsBuilderImpl)((PieChartSettingsBuilderImpl)DisplayerSettingsFactory.newPieChartSettings().dataset("gitContributors")).filter(new ColumnFilter[]{this.createOrgUnitFilter(organizationalUnit)})).filter("date", new ColumnFilter[]{FilterFactory.notNull()})).group("date")).fixed(DateIntervalType.QUARTER, false)).column("date")).column(AggregateFunctionType.COUNT, "#commits")).format(this.translationService.getTranslation("NumberOfCommits"), "#,##0")).title(this.translationService.getTranslation("Quarters"))).titleVisible(false)).width(250)).height(170)).margins(10, 0, 5, 5)).legendOn(Position.RIGHT)).filterOn(false, true, true)).buildSettings();
    }

    public DisplayerSettings buildCommitsByDayOfWeekSettings(OrganizationalUnit organizationalUnit) {
        return ((BarChartSettingsBuilderImpl)((BarChartSettingsBuilderImpl)((BarChartSettingsBuilderImpl)((BarChartSettingsBuilderImpl)((BarChartSettingsBuilderImpl)((BarChartSettingsBuilderImpl)((BarChartSettingsBuilderImpl)((BarChartSettingsBuilderImpl)((BarChartSettingsBuilderImpl)((BarChartSettingsBuilderImpl)((BarChartSettingsBuilderImpl)((BarChartSettingsBuilderImpl)((BarChartSettingsBuilderImpl)((BarChartSettingsBuilderImpl)((BarChartSettingsBuilderImpl)((BarChartSettingsBuilderImpl)DisplayerSettingsFactory.newBarChartSettings().dataset("gitContributors")).filter(new ColumnFilter[]{this.createOrgUnitFilter(organizationalUnit)})).filter("date", new ColumnFilter[]{FilterFactory.notNull()})).group("date")).fixed(DateIntervalType.DAY_OF_WEEK, true)).firstDay(DayOfWeek.SUNDAY)).column("date")).column(AggregateFunctionType.COUNT, "#commits")).format(this.translationService.getTranslation("NumberOfCommits"), "#,##0")).title(this.translationService.getTranslation("DayOfWeek"))).titleVisible(false)).width(250)).height(170)).margins(10, 40, 70, 0)).subType_Bar().xAxisTitle(this.translationService.getTranslation("NumberOfCommits"))).filterOn(false, true, true)).buildSettings();
    }

    public DisplayerSettings buildProjectSelectorSettings(OrganizationalUnit organizationalUnit) {
        return ((SelectorDisplayerSettingsBuilderImpl)((SelectorDisplayerSettingsBuilderImpl)((SelectorDisplayerSettingsBuilderImpl)((SelectorDisplayerSettingsBuilderImpl)((SelectorDisplayerSettingsBuilderImpl)((SelectorDisplayerSettingsBuilderImpl)((SelectorDisplayerSettingsBuilderImpl)((SelectorDisplayerSettingsBuilderImpl)((SelectorDisplayerSettingsBuilderImpl)((SelectorDisplayerSettingsBuilderImpl)((SelectorDisplayerSettingsBuilderImpl)((SelectorDisplayerSettingsBuilderImpl)((SelectorDisplayerSettingsBuilderImpl)DisplayerSettingsFactory.newSelectorSettings().dataset("gitContributors")).filter(new ColumnFilter[]{this.createOrgUnitFilter(organizationalUnit)})).group("project")).column("project", this.translationService.getTranslation("Project"))).column(AggregateFunctionType.COUNT, "#commits")).format(this.translationService.getTranslation("NumberOfCommits"), "#,##0")).sort("#commits", SortOrder.DESCENDING)).subtype(DisplayerSubType.SELECTOR_DROPDOWN)).multiple(true)).titleVisible(false)).margins(0, 0, 10, 0)).width(200)).filterOn(false, true, true)).buildSettings();
    }

    public DisplayerSettings buildTopContributorSelectorSettings(OrganizationalUnit organizationalUnit) {
        return ((SelectorDisplayerSettingsBuilderImpl)((SelectorDisplayerSettingsBuilderImpl)((SelectorDisplayerSettingsBuilderImpl)((SelectorDisplayerSettingsBuilderImpl)((SelectorDisplayerSettingsBuilderImpl)((SelectorDisplayerSettingsBuilderImpl)((SelectorDisplayerSettingsBuilderImpl)((SelectorDisplayerSettingsBuilderImpl)((SelectorDisplayerSettingsBuilderImpl)((SelectorDisplayerSettingsBuilderImpl)((SelectorDisplayerSettingsBuilderImpl)((SelectorDisplayerSettingsBuilderImpl)((SelectorDisplayerSettingsBuilderImpl)DisplayerSettingsFactory.newSelectorSettings().dataset("gitContributors")).filter(new ColumnFilter[]{this.createOrgUnitFilter(organizationalUnit)})).group("author")).column("author", this.translationService.getTranslation("TopContributor"))).column(AggregateFunctionType.COUNT, "#commits")).format(this.translationService.getTranslation("NumberOfCommits"), "#,##0")).sort("#commits", SortOrder.DESCENDING)).subtype(DisplayerSubType.SELECTOR_DROPDOWN)).multiple(true)).titleVisible(false)).margins(0, 0, 10, 0)).width(200)).filterOn(false, true, true)).buildSettings();
    }

    public DisplayerSettings buildDateSelectorSettings(OrganizationalUnit organizationalUnit) {
        return ((SelectorDisplayerSettingsBuilderImpl)((SelectorDisplayerSettingsBuilderImpl)((SelectorDisplayerSettingsBuilderImpl)((SelectorDisplayerSettingsBuilderImpl)((SelectorDisplayerSettingsBuilderImpl)((SelectorDisplayerSettingsBuilderImpl)((SelectorDisplayerSettingsBuilderImpl)((SelectorDisplayerSettingsBuilderImpl)((SelectorDisplayerSettingsBuilderImpl)DisplayerSettingsFactory.newSelectorSettings().dataset("gitContributors")).filter(new ColumnFilter[]{this.createOrgUnitFilter(organizationalUnit)})).column("date")).format(this.translationService.getTranslation("Date"), "dd MMM, yyyy HH:mm")).subtype(DisplayerSubType.SELECTOR_SLIDER)).titleVisible(false)).width(420)).margins(0, 0, 20, 10)).filterOn(false, true, true)).buildSettings();
    }

    public DisplayerSettings buildAllCommitsSettings(OrganizationalUnit organizationalUnit) {
        return ((TableDisplayerSettingsBuilderImpl)((TableDisplayerSettingsBuilderImpl)((TableDisplayerSettingsBuilderImpl)((TableDisplayerSettingsBuilderImpl)((TableDisplayerSettingsBuilderImpl)((TableDisplayerSettingsBuilderImpl)((TableDisplayerSettingsBuilderImpl)((TableDisplayerSettingsBuilderImpl)((TableDisplayerSettingsBuilderImpl)((TableDisplayerSettingsBuilderImpl)DisplayerSettingsFactory.newTableSettings().dataset("gitContributors")).filter(new ColumnFilter[]{this.createOrgUnitFilter(organizationalUnit)})).column("project", this.translationService.getTranslation("Project"))).column("author", this.translationService.getTranslation("Author"))).column("date", this.translationService.getTranslation("Date"))).column("message", this.translationService.getTranslation("Message"))).sort("date", SortOrder.DESCENDING)).tablePageSize(10).tableWidth(950).tableOrderEnabled(true).tableColumnPickerEnabled(true).allowExcelExport(true)).allowCsvExport(true)).filterOff(true)).buildSettings();
    }
}

