/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.library.client.widgets.example.branchselector;

import elemental2.dom.Element;
import elemental2.dom.HTMLElement;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.kie.workbench.common.screens.examples.model.ImportProject;
import org.kie.workbench.common.widgets.client.widget.KieMultipleSelectElement;
import org.kie.workbench.common.widgets.client.widget.KieSelectOption;
import org.uberfire.client.mvp.UberElemental;
import org.uberfire.ext.widgets.common.client.common.HasBusyIndicator;

public class BranchSelectorPopUpPresenter {
    private View view;
    private KieMultipleSelectElement branchSelector;
    ImportProject importProject;
    List<String> branches;
    Consumer<List<String>> branchesSelectedCallback;

    @Inject
    public BranchSelectorPopUpPresenter(View view, KieMultipleSelectElement branchSelector) {
        this.view = view;
        this.branchSelector = branchSelector;
    }

    public void setup(ImportProject importProject, Consumer<List<String>> branchesSelectedCallback) {
        this.importProject = importProject;
        this.branchesSelectedCallback = branchesSelectedCallback;
        List allBranches = importProject.getAllBranches();
        allBranches.sort(String.CASE_INSENSITIVE_ORDER);
        this.view.init(this);
        this.branches = importProject.getSelectedBranches();
        this.branches.sort(String.CASE_INSENSITIVE_ORDER);
        if (!this.branches.contains("master")) {
            this.branches.add("master");
        }
        this.branchSelector.setup((Element)this.view.getBranchSelectorContainer(), allBranches.stream().map(branch -> new KieSelectOption(branch, branch)).collect(Collectors.toList()), this.branches, this::setSelectedBranches);
        this.view.show();
    }

    public void defineBranches() {
        if (this.branches.isEmpty()) {
            this.view.showError(this.view.getAtLeastMainIsRequiredMessage());
            return;
        }
        if (!this.branches.contains("master")) {
            this.view.showError(this.view.getMainIsRequiredMessage());
            return;
        }
        this.importProject.setSelectedBranches(this.branches);
        this.view.hide();
        this.branchesSelectedCallback.accept(this.branches);
    }

    public void cancel() {
        this.view.hide();
    }

    public void setSelectedBranches(List<String> branches) {
        this.branches = branches;
    }

    public static interface View
    extends UberElemental<BranchSelectorPopUpPresenter>,
    HasBusyIndicator {
        public HTMLElement getBranchSelectorContainer();

        public void show();

        public void hide();

        public void showError(String var1);

        public String getMainIsRequiredMessage();

        public String getAtLeastMainIsRequiredMessage();
    }
}

