/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.library.client.perspective;

import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.kie.workbench.common.screens.library.client.util.LibraryPlaces;
import org.uberfire.client.annotations.Perspective;
import org.uberfire.client.annotations.WorkbenchPerspective;
import org.uberfire.client.workbench.events.PerspectiveChange;
import org.uberfire.client.workbench.panels.impl.MultiListWorkbenchPanelPresenter;
import org.uberfire.lifecycle.OnClose;
import org.uberfire.lifecycle.OnStartup;
import org.uberfire.mvp.Command;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.workbench.model.PanelDefinition;
import org.uberfire.workbench.model.PerspectiveDefinition;
import org.uberfire.workbench.model.impl.PerspectiveDefinitionImpl;

@ApplicationScoped
@WorkbenchPerspective(identifier="LibraryPerspective")
public class LibraryPerspective {
    private LibraryPlaces libraryPlaces;
    private PerspectiveDefinition perspectiveDefinition;
    private boolean refresh = true;

    public LibraryPerspective() {
    }

    @Inject
    public LibraryPerspective(LibraryPlaces libraryPlaces) {
        this.libraryPlaces = libraryPlaces;
        this.libraryPlaces.init(this);
    }

    @Perspective
    public PerspectiveDefinition buildPerspective() {
        if (this.perspectiveDefinition == null) {
            this.perspectiveDefinition = new PerspectiveDefinitionImpl(MultiListWorkbenchPanelPresenter.class.getName());
            this.perspectiveDefinition.setName("Library Perspective");
        }
        return this.perspectiveDefinition;
    }

    @OnStartup
    public void onStartup(PlaceRequest placeRequest) {
        boolean refresh;
        this.refresh = refresh = Boolean.parseBoolean(placeRequest.getParameter("refresh", "true"));
    }

    public void perspectiveChangeEvent(@Observes PerspectiveChange event) {
        if (event.getIdentifier().equals("LibraryPerspective")) {
            this.libraryPlaces.refresh(this.getRefreshCallBack());
        }
    }

    private Command getRefreshCallBack() {
        if (this.refresh) {
            return () -> {
                if (this.getRootPanel() != null) {
                    this.libraryPlaces.goToLibrary();
                }
            };
        }
        return null;
    }

    @OnClose
    public void onClose() {
        this.libraryPlaces.hideDocks();
    }

    public PanelDefinition getRootPanel() {
        return this.buildPerspective().getRoot();
    }
}

