/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.library.client.screens;

import com.google.gwt.event.dom.client.ClickEvent;
import javax.inject.Inject;
import org.jboss.errai.common.client.dom.Anchor;
import org.jboss.errai.common.client.dom.Div;
import org.jboss.errai.common.client.dom.HTMLElement;
import org.jboss.errai.common.client.dom.ListItem;
import org.jboss.errai.common.client.dom.Node;
import org.jboss.errai.common.client.dom.Span;
import org.jboss.errai.ui.client.local.api.IsElement;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.EventHandler;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.kie.workbench.common.screens.library.client.screens.LibraryScreen;
import org.kie.workbench.common.screens.library.client.screens.ProjectsDetailScreen;

@Templated
public class LibraryView
implements LibraryScreen.View,
IsElement {
    private LibraryScreen presenter;
    @Inject
    private ProjectsDetailScreen projectsDetailScreen;
    @Inject
    private TranslationService ts;
    @Inject
    @DataField(value="title")
    Div title;
    @Inject
    @DataField(value="actions")
    Div actions;
    @Inject
    @DataField(value="try-samples")
    Anchor trySamples;
    @Inject
    @DataField(value="import-project")
    Anchor importProject;
    @Inject
    @DataField(value="edit-contributors")
    Anchor editContributors;
    @Inject
    @DataField(value="delete-project")
    Anchor deleteProject;
    @Inject
    @DataField(value="projects-tab-container")
    ListItem projectsTabContainer;
    @Inject
    @DataField(value="projects-tab")
    Anchor projectsTab;
    @Inject
    @DataField(value="projects-count")
    Span projectsCount;
    @Inject
    @DataField(value="contributors-tab-container")
    ListItem contributorsTabContainer;
    @Inject
    @DataField(value="contributors-tab")
    Anchor contributorsTab;
    @Inject
    @DataField(value="contributors-count")
    Span contributorsCount;
    @Inject
    @DataField(value="metrics-tab-container")
    ListItem metricsTabContainer;
    @Inject
    @DataField(value="metrics-tab")
    Anchor metricsTab;
    @Inject
    @DataField(value="main-container")
    Div mainContainer;

    public void init(LibraryScreen presenter) {
        this.presenter = presenter;
        boolean userCanCreateProjects = presenter.userCanCreateProjects();
        boolean userCanUpdateOrganizationalUnit = presenter.userCanUpdateOrganizationalUnit();
        boolean userCanDeleteOrganizationalUnit = presenter.userCanDeleteOrganizationalUnit();
        this.trySamples.setHidden(!userCanCreateProjects);
        this.importProject.setHidden(!userCanCreateProjects);
        this.editContributors.setHidden(!userCanUpdateOrganizationalUnit);
        this.deleteProject.setHidden(!userCanDeleteOrganizationalUnit);
        this.actions.setHidden(!userCanCreateProjects && !userCanUpdateOrganizationalUnit && !userCanDeleteOrganizationalUnit);
    }

    @EventHandler(value={"try-samples"})
    public void trySamples(ClickEvent event) {
        this.presenter.trySamples();
    }

    @EventHandler(value={"import-project"})
    public void importProject(ClickEvent event) {
        this.presenter.importProject();
    }

    @EventHandler(value={"edit-contributors"})
    public void editContributors(ClickEvent event) {
        this.presenter.editContributors();
    }

    @EventHandler(value={"delete-project"})
    public void delete(ClickEvent event) {
        this.presenter.delete();
    }

    @EventHandler(value={"projects-tab"})
    public void showProjects(ClickEvent event) {
        this.projectsTabContainer.getClassList().add("active");
        this.contributorsTabContainer.getClassList().remove("active");
        this.metricsTabContainer.getClassList().remove("active");
        this.presenter.showProjects();
    }

    @EventHandler(value={"contributors-tab"})
    public void showContributors(ClickEvent event) {
        this.projectsTabContainer.getClassList().remove("active");
        this.contributorsTabContainer.getClassList().add("active");
        this.metricsTabContainer.getClassList().remove("active");
        this.presenter.showContributors();
    }

    @EventHandler(value={"metrics-tab"})
    public void showMetrics(ClickEvent event) {
        this.projectsTabContainer.getClassList().remove("active");
        this.contributorsTabContainer.getClassList().remove("active");
        this.metricsTabContainer.getClassList().add("active");
        this.presenter.showMetrics();
    }

    @Override
    public void setTitle(String title) {
        this.title.setTextContent(title);
    }

    @Override
    public void setProjectsCount(int count) {
        this.projectsCount.setTextContent(String.valueOf(count));
    }

    @Override
    public void setContributorsCount(int count) {
        this.contributorsCount.setTextContent(String.valueOf(count));
    }

    @Override
    public void updateContent(HTMLElement content) {
        this.mainContainer.setTextContent("");
        this.mainContainer.appendChild((Node)content);
    }
}

