/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.library.client.screens;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.guvnor.common.services.project.client.context.WorkspaceProjectContext;
import org.guvnor.common.services.project.client.security.ProjectController;
import org.guvnor.common.services.project.model.POM;
import org.guvnor.common.services.project.model.WorkspaceProject;
import org.guvnor.structure.organizationalunit.OrganizationalUnit;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.dom.HTMLElement;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.kie.workbench.common.screens.library.api.LibraryInfo;
import org.kie.workbench.common.screens.library.api.LibraryService;
import org.kie.workbench.common.screens.library.client.events.ProjectDetailEvent;
import org.kie.workbench.common.screens.library.client.util.LibraryPlaces;
import org.kie.workbench.common.screens.library.client.widgets.common.TileWidget;
import org.kie.workbench.common.screens.library.client.widgets.library.AddProjectButtonPresenter;
import org.uberfire.client.mvp.UberElement;
import org.uberfire.ext.widgets.common.client.common.HasBusyIndicator;
import org.uberfire.mvp.Command;

public class PopulatedLibraryScreen {
    private View view;
    private LibraryPlaces libraryPlaces;
    private Event<ProjectDetailEvent> projectDetailEvent;
    private Caller<LibraryService> libraryService;
    private ProjectController projectController;
    private WorkspaceProjectContext projectContext;
    private ManagedInstance<TileWidget> tileWidgets;
    private AddProjectButtonPresenter addProjectButtonPresenter;
    List<WorkspaceProject> projects;

    @Inject
    public PopulatedLibraryScreen(View view, LibraryPlaces libraryPlaces, Event<ProjectDetailEvent> projectDetailEvent, Caller<LibraryService> libraryService, ProjectController projectController, WorkspaceProjectContext projectContext, ManagedInstance<TileWidget> tileWidgets, AddProjectButtonPresenter addProjectButtonPresenter) {
        this.view = view;
        this.libraryPlaces = libraryPlaces;
        this.projectDetailEvent = projectDetailEvent;
        this.libraryService = libraryService;
        this.projectController = projectController;
        this.projectContext = projectContext;
        this.projects = Collections.emptyList();
        this.tileWidgets = tileWidgets;
        this.addProjectButtonPresenter = addProjectButtonPresenter;
    }

    @PostConstruct
    public void setup() {
        this.view.init(this);
        if (this.userCanCreateProjects()) {
            this.view.addAction(this.addProjectButtonPresenter.getView().getElement());
        }
        ((LibraryService)this.libraryService.call(this::updateLibrary)).getLibraryInfo((OrganizationalUnit)this.projectContext.getActiveOrganizationalUnit().orElseThrow(() -> new IllegalStateException("Cannot get library info without an active organizational unit.")));
    }

    private void updateLibrary(LibraryInfo libraryInfo) {
        this.projects = new ArrayList<WorkspaceProject>(libraryInfo.getProjects());
        this.view.clearFilterText();
        this.setupProjects();
    }

    private void setupProjects() {
        this.projects.sort((p1, p2) -> p1.getName().toUpperCase().compareTo(p2.getName().toUpperCase()));
        this.updateView(this.projects);
    }

    public List<WorkspaceProject> filterProjects(String filter) {
        List<WorkspaceProject> filteredProjects = this.projects.stream().filter(p -> p.getName().toUpperCase().contains(filter.toUpperCase())).collect(Collectors.toList());
        this.updateView(filteredProjects);
        return filteredProjects;
    }

    private void updateView(List<WorkspaceProject> projects) {
        this.view.clearProjects();
        projects.stream().forEach(project -> {
            TileWidget tileWidget = this.createProjectWidget((WorkspaceProject)project);
            this.view.addProject(tileWidget.getView().getElement());
        });
    }

    private TileWidget createProjectWidget(WorkspaceProject project) {
        TileWidget tileWidget = (TileWidget)this.tileWidgets.get();
        if (project.getMainModule() != null) {
            POM pom = project.getMainModule().getPom();
            tileWidget.init(project.getName(), pom != null ? pom.getDescription() : "", String.valueOf(project.getMainModule().getNumberOfAssets()), this.view.getNumberOfAssetsMessage(project.getMainModule().getNumberOfAssets()), this.selectCommand(project));
        } else {
            tileWidget.init(project.getName(), "", "0", "0", this.selectCommand(project));
        }
        return tileWidget;
    }

    public boolean userCanCreateProjects() {
        return this.projectController.canCreateProjects();
    }

    public int getProjectsCount() {
        return this.projects.size();
    }

    Command selectCommand(WorkspaceProject project) {
        return () -> {
            this.view.showBusyIndicator(this.view.getLoadingAssetsMessage());
            this.libraryPlaces.goToProject(project);
        };
    }

    public View getView() {
        return this.view;
    }

    public static interface View
    extends UberElement<PopulatedLibraryScreen>,
    HasBusyIndicator {
        public void clearProjects();

        public void addProject(HTMLElement var1);

        public void addAction(HTMLElement var1);

        public void clearFilterText();

        public String getNumberOfAssetsMessage(int var1);

        public String getLoadingAssetsMessage();
    }
}

