/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.library.client.screens;

import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.dashbuilder.dataset.events.DataSetModifiedEvent;
import org.dashbuilder.displayer.client.Displayer;
import org.guvnor.common.services.project.client.context.WorkspaceProjectContext;
import org.guvnor.common.services.project.model.POM;
import org.kie.workbench.common.screens.library.client.events.ProjectDetailEvent;
import org.kie.workbench.common.screens.library.client.util.LibraryPlaces;
import org.kie.workbench.common.screens.library.client.util.ProjectMetricsFactory;
import org.uberfire.client.annotations.WorkbenchPartTitle;
import org.uberfire.client.annotations.WorkbenchPartView;
import org.uberfire.client.annotations.WorkbenchScreen;
import org.uberfire.client.mvp.UberElement;
import org.uberfire.lifecycle.OnClose;

@WorkbenchScreen(identifier="ProjectsDetailScreen")
public class ProjectsDetailScreen {
    private View view;
    private ProjectMetricsFactory projectMetricsFactory;
    private LibraryPlaces libraryPlaces;
    private WorkspaceProjectContext projectContext;
    private Displayer commitsDisplayer;

    @Inject
    public ProjectsDetailScreen(View view, ProjectMetricsFactory projectMetricsFactory, LibraryPlaces libraryPlaces, WorkspaceProjectContext projectContext) {
        this.view = view;
        this.projectMetricsFactory = projectMetricsFactory;
        this.libraryPlaces = libraryPlaces;
        this.projectContext = projectContext;
        this.view.init(this);
    }

    public void update(@Observes ProjectDetailEvent event) {
        POM pom = event.getProject().getMainModule().getPom();
        if (pom != null && pom.getDescription() != null) {
            this.view.updateDescription(pom.getDescription());
        } else {
            this.view.updateDescription("");
        }
        this.commitsDisplayer = this.projectMetricsFactory.lookupCommitsOverTimeDisplayer_small(event.getProject());
        this.commitsDisplayer.draw();
        this.view.updateContributionsMetric(this.commitsDisplayer);
    }

    @WorkbenchPartTitle
    public String getTitle() {
        return "Project Detail Screen";
    }

    @WorkbenchPartView
    public UberElement<ProjectsDetailScreen> getView() {
        return this.view;
    }

    @OnClose
    public void dispose() {
        if (this.commitsDisplayer != null) {
            this.commitsDisplayer.close();
        }
    }

    public void onContributionsUpdated(@Observes DataSetModifiedEvent event) {
        String dsetId = event.getDataSetDef().getUUID();
        if ("gitContributors".equals(dsetId) && this.commitsDisplayer != null) {
            this.commitsDisplayer.redraw();
        }
    }

    public void setMetricsEnabled(boolean enabled) {
        this.view.setMetricsEnabled(enabled);
    }

    public void gotoProjectMetrics() {
        if (this.projectContext.getActiveWorkspaceProject().isPresent()) {
            this.libraryPlaces.goToProjectMetrics();
        }
    }

    public static interface View
    extends UberElement<ProjectsDetailScreen> {
        public void updateDescription(String var1);

        public void updateContributionsMetric(Displayer var1);

        public void setMetricsEnabled(boolean var1);
    }
}

