/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.library.client.screens.assets;

import elemental2.dom.HTMLElement;
import javax.annotation.PostConstruct;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.guvnor.common.services.project.model.WorkspaceProject;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.ErrorCallback;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.kie.workbench.common.screens.library.api.LibraryService;
import org.kie.workbench.common.screens.library.api.ProjectAssetListUpdated;
import org.kie.workbench.common.screens.library.api.Routed;
import org.kie.workbench.common.screens.library.client.screens.assets.EmptyAssetsScreen;
import org.kie.workbench.common.screens.library.client.screens.assets.PopulatedAssetsScreen;
import org.kie.workbench.common.screens.library.client.util.LibraryPlaces;
import org.kie.workbench.common.widgets.client.handlers.NewResourceSuccessEvent;
import org.uberfire.client.mvp.UberElemental;
import org.uberfire.ext.widgets.common.client.callbacks.HasBusyIndicatorDefaultErrorCallback;
import org.uberfire.ext.widgets.common.client.common.BusyIndicatorView;
import org.uberfire.ext.widgets.common.client.common.HasBusyIndicator;

public class AssetsScreen {
    private final View view;
    private final LibraryPlaces libraryPlaces;
    private final EmptyAssetsScreen emptyAssetsScreen;
    private final PopulatedAssetsScreen populatedAssetsScreen;
    private final BusyIndicatorView busyIndicatorView;
    private final TranslationService ts;
    private final Caller<LibraryService> libraryService;
    private WorkspaceProject projectInfo;

    @Inject
    public AssetsScreen(View view, LibraryPlaces libraryPlaces, EmptyAssetsScreen emptyAssetsScreen, PopulatedAssetsScreen populatedAssetsScreen, TranslationService ts, BusyIndicatorView busyIndicatorView, Caller<LibraryService> libraryService) {
        this.view = view;
        this.libraryPlaces = libraryPlaces;
        this.emptyAssetsScreen = emptyAssetsScreen;
        this.populatedAssetsScreen = populatedAssetsScreen;
        this.ts = ts;
        this.busyIndicatorView = busyIndicatorView;
        this.libraryService = libraryService;
    }

    @PostConstruct
    public void init() {
        this.view.init(this);
        this.projectInfo = this.libraryPlaces.getActiveWorkspaceContext();
        this.showAssets();
    }

    public void observeAddAsset(@Observes NewResourceSuccessEvent event) {
        this.showAssets();
    }

    public void onAssetListUpdated(@Observes @Routed ProjectAssetListUpdated event) {
        if (event.getProject().getRepository().getIdentifier().equals(this.projectInfo.getRepository().getIdentifier())) {
            this.showAssets();
        }
    }

    protected void showAssets() {
        this.busyIndicatorView.showBusyIndicator(this.ts.getTranslation("LoadingAssets"));
        ((LibraryService)this.libraryService.call(hasAssets -> {
            HTMLElement element = hasAssets != false ? this.populatedAssetsScreen.getView().getElement() : this.emptyAssetsScreen.getView().getElement();
            this.ensureContentSet(element);
            this.busyIndicatorView.hideBusyIndicator();
        }, (ErrorCallback)new HasBusyIndicatorDefaultErrorCallback((HasBusyIndicator)this.busyIndicatorView))).hasAssets(this.projectInfo);
    }

    private void ensureContentSet(HTMLElement element) {
        if (element.parentNode == null) {
            this.view.setContent(element);
        }
    }

    public View getView() {
        return this.view;
    }

    public static interface View
    extends UberElemental<AssetsScreen> {
        public void setContent(HTMLElement var1);
    }
}

