/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.library.client.screens.assets.add;

import com.google.gwt.core.client.Callback;
import elemental2.dom.HTMLElement;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.kie.workbench.common.screens.library.client.perspective.LibraryPerspective;
import org.kie.workbench.common.screens.library.client.resources.i18n.LibraryConstants;
import org.kie.workbench.common.screens.library.client.util.CategoryUtils;
import org.kie.workbench.common.screens.library.client.util.LibraryPlaces;
import org.kie.workbench.common.screens.library.client.util.ResourceHandlerManager;
import org.kie.workbench.common.screens.library.client.widgets.project.NewAssetHandlerCardWidget;
import org.kie.workbench.common.widgets.client.handlers.NewResourceHandler;
import org.uberfire.client.annotations.WorkbenchPartTitle;
import org.uberfire.client.annotations.WorkbenchPartView;
import org.uberfire.client.annotations.WorkbenchScreen;
import org.uberfire.client.mvp.CategoriesManagerCache;
import org.uberfire.client.mvp.UberElemental;
import org.uberfire.ext.widgets.common.client.select.SelectOption;
import org.uberfire.workbench.category.Category;
import org.uberfire.workbench.category.Undefined;

@WorkbenchScreen(identifier="AddAssetsScreen", owningPerspective=LibraryPerspective.class)
public class AddAssetScreen {
    private View view;
    private TranslationService ts;
    private ResourceHandlerManager resourceHandlerManager;
    private CategoriesManagerCache categoriesManagerCache;
    private ManagedInstance<NewAssetHandlerCardWidget> newAssetHandlerCardWidgets;
    private LibraryConstants libraryConstants;
    private CategoryUtils categoryUtils;
    private LibraryPlaces libraryPlaces;
    private List<NewResourceHandler> newResourceHandlers;
    private String filter;
    private String filterType;

    public AddAssetScreen() {
    }

    @Inject
    public AddAssetScreen(View view, TranslationService ts, ResourceHandlerManager resourceHandlerManager, CategoriesManagerCache categoriesManagerCache, ManagedInstance<NewAssetHandlerCardWidget> newAssetHandlerCardWidgets, LibraryConstants libraryConstants, CategoryUtils categoryUtils, LibraryPlaces libraryPlaces) {
        this.view = view;
        this.ts = ts;
        this.resourceHandlerManager = resourceHandlerManager;
        this.categoriesManagerCache = categoriesManagerCache;
        this.newAssetHandlerCardWidgets = newAssetHandlerCardWidgets;
        this.libraryConstants = libraryConstants;
        this.categoryUtils = categoryUtils;
        this.libraryPlaces = libraryPlaces;
    }

    @PostConstruct
    public void intialize() {
        this.filter = "";
        this.view.init(this);
        this.view.setTitle(this.getTitle());
        this.newResourceHandlers = this.resourceHandlerManager.getResourceHandlers(resourceHandler -> this.isBlacklisted((NewResourceHandler)resourceHandler));
        this.view.setCategories(this.categoryUtils.createCategories());
        this.update();
    }

    private Callback<Boolean, Void> acceptContextCallback(final NewResourceHandler resourceHandler) {
        return new Callback<Boolean, Void>(){

            public void onFailure(Void reason) {
            }

            public void onSuccess(Boolean result) {
                NewAssetHandlerCardWidget widget = (NewAssetHandlerCardWidget)AddAssetScreen.this.newAssetHandlerCardWidgets.get();
                widget.initialize(resourceHandler);
                AddAssetScreen.this.view.addNewAssetWidget(widget.getView());
            }
        };
    }

    private void update() {
        this.view.clear();
        List<NewResourceHandler> filteredHandlers = this.filterAndSortHandlers(this.newResourceHandlers, this.filter, this.categoriesManagerCache.getCategory(this.filterType));
        filteredHandlers.forEach(handler -> this.addAssetItem((NewResourceHandler)handler));
    }

    protected List<NewResourceHandler> filterAndSortHandlers(List<NewResourceHandler> handlers, String textFilter, Category category) {
        Stream<NewResourceHandler> filtered = handlers.stream().filter(handler -> handler.getDescription().toLowerCase().contains(textFilter.toLowerCase()));
        if (!category.equals((Object)new Undefined())) {
            filtered = filtered.filter(resourceHandler -> category.equals((Object)resourceHandler.getResourceType().getCategory()));
        }
        return filtered.sorted(Comparator.comparing(r -> r.getDescription().toLowerCase())).collect(Collectors.toList());
    }

    private void addAssetItem(NewResourceHandler resourceHandler) {
        if (resourceHandler.canCreate()) {
            resourceHandler.acceptContext(this.acceptContextCallback(resourceHandler));
        }
    }

    private boolean isBlacklisted(NewResourceHandler resourceHandler) {
        return resourceHandler.getClass().getName().contains("NewProjectHandler");
    }

    public void setFilter(String filter) {
        this.filter = filter;
        this.update();
    }

    @WorkbenchPartTitle
    public String getTitle() {
        return this.ts.getTranslation("AddAsset");
    }

    @WorkbenchPartView
    public View getView() {
        return this.view;
    }

    public void setFilterType(String filterType) {
        this.filterType = filterType;
        this.update();
    }

    public void cancel() {
        this.libraryPlaces.goToProject(this.libraryPlaces.getActiveWorkspaceContext());
    }

    public static interface View
    extends UberElemental<AddAssetScreen> {
        public void addNewAssetWidget(HTMLElement var1);

        public void setCategories(List<SelectOption> var1);

        public void clear();

        public void setTitle(String var1);
    }
}

