/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.library.client.screens.importrepository;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.enterprise.event.Event;
import javax.enterprise.inject.Produces;
import org.guvnor.common.services.project.client.context.WorkspaceProjectContext;
import org.guvnor.common.services.project.context.WorkspaceProjectContextChangeEvent;
import org.guvnor.structure.organizationalunit.OrganizationalUnit;
import org.jboss.errai.bus.client.api.messaging.Message;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.ErrorCallback;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.jboss.errai.common.client.dom.HTMLElement;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.kie.workbench.common.screens.examples.model.ExampleOrganizationalUnit;
import org.kie.workbench.common.screens.examples.model.ExampleProject;
import org.kie.workbench.common.screens.examples.service.ExamplesService;
import org.kie.workbench.common.screens.library.api.LibraryService;
import org.kie.workbench.common.screens.library.client.screens.importrepository.ImportProjectsSetupEvent;
import org.kie.workbench.common.screens.library.client.screens.importrepository.Source;
import org.kie.workbench.common.screens.library.client.util.LibraryPlaces;
import org.kie.workbench.common.screens.library.client.widgets.common.TileWidget;
import org.uberfire.client.mvp.UberElement;
import org.uberfire.ext.widgets.common.client.callbacks.DefaultErrorCallback;
import org.uberfire.ext.widgets.common.client.callbacks.HasBusyIndicatorDefaultErrorCallback;
import org.uberfire.ext.widgets.common.client.common.HasBusyIndicator;
import org.uberfire.mvp.Command;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.workbench.events.NotificationEvent;

public abstract class ImportPresenter {
    protected final View view;
    protected final LibraryPlaces libraryPlaces;
    protected final Caller<LibraryService> libraryService;
    protected final ManagedInstance<TileWidget> tileWidgets;
    protected final WorkspaceProjectContext projectContext;
    protected final Event<NotificationEvent> notificationEvent;
    protected final Event<WorkspaceProjectContextChangeEvent> projectContextChangeEvent;
    protected Map<ExampleProject, TileWidget> projectWidgetsByName;

    @Produces
    @Source(value=Source.Kind.EXAMPLE)
    public static ImportPresenter examplesImportPresenter(View view, LibraryPlaces libraryPlaces, Caller<LibraryService> libraryService, ManagedInstance<TileWidget> tileWidgets, Caller<ExamplesService> examplesService, WorkspaceProjectContext projectContext, Event<NotificationEvent> notificationEvent, Event<WorkspaceProjectContextChangeEvent> projectContextChangeEvent) {
        return new ExamplesImportPresenter(view, libraryPlaces, libraryService, tileWidgets, examplesService, projectContext, notificationEvent, projectContextChangeEvent);
    }

    public ImportPresenter(View view, LibraryPlaces libraryPlaces, Caller<LibraryService> libraryService, ManagedInstance<TileWidget> tileWidgets, WorkspaceProjectContext projectContext, Event<NotificationEvent> notificationEvent, Event<WorkspaceProjectContextChangeEvent> projectContextChangeEvent) {
        this.view = view;
        this.libraryPlaces = libraryPlaces;
        this.libraryService = libraryService;
        this.tileWidgets = tileWidgets;
        this.projectContext = projectContext;
        this.notificationEvent = notificationEvent;
        this.projectContextChangeEvent = projectContextChangeEvent;
    }

    public void onStartup(PlaceRequest placeRequest) {
        this.view.init(this);
        String title = placeRequest.getParameter("title", this.view.getTrySamplesLabel());
        this.view.setTitle(title);
        this.loadProjects(placeRequest, (RemoteCallback<Set<ExampleProject>>)((RemoteCallback)projects -> {
            this.view.hideBusyIndicator();
            this.setupProjects((Set<ExampleProject>)projects);
        }));
    }

    protected abstract void loadProjects(PlaceRequest var1, RemoteCallback<Set<ExampleProject>> var2);

    protected abstract void importProjects(List<ExampleProject> var1, RemoteCallback<WorkspaceProjectContextChangeEvent> var2, ErrorCallback<Message> var3);

    protected DefaultErrorCallback loadingErrorCallback() {
        return new DefaultErrorCallback(){

            public boolean error(Message message, Throwable throwable) {
                ImportPresenter.this.view.hideBusyIndicator();
                ImportPresenter.this.showNoProjects();
                return super.error(message, throwable);
            }
        };
    }

    public void setupEvent(ImportProjectsSetupEvent event) {
        this.setupProjects(event.getProjects());
    }

    private void setupProjects(Set<ExampleProject> projects) {
        if (projects == null || projects.isEmpty()) {
            this.showNoProjects();
            return;
        }
        this.projectWidgetsByName = new HashMap<ExampleProject, TileWidget>();
        projects.forEach(project -> {
            TileWidget projectWidget = this.createProjectWidget((ExampleProject)project);
            this.projectWidgetsByName.put((ExampleProject)project, projectWidget);
        });
        this.updateView(this.projectWidgetsByName.values());
    }

    private TileWidget createProjectWidget(ExampleProject project) {
        TileWidget tileWidget = (TileWidget)this.tileWidgets.get();
        tileWidget.init(project.getName(), project.getDescription(), null, null, this.selectCommand(tileWidget));
        return tileWidget;
    }

    private void showNoProjects() {
        this.notificationEvent.fire((Object)new NotificationEvent(this.view.getNoProjectsToImportMessage(), NotificationEvent.NotificationType.ERROR));
        this.libraryPlaces.goToLibrary();
    }

    private void updateView(Collection<TileWidget> projectWidgets) {
        this.view.clearProjects();
        List<TileWidget> sortedProjectWidgets = this.sortProjectWidgets(projectWidgets);
        sortedProjectWidgets.stream().forEach(projectWidget -> this.view.addProject(projectWidget.getView().getElement()));
    }

    private List<TileWidget> sortProjectWidgets(Collection<TileWidget> projectWidgets) {
        ArrayList<TileWidget> sortedProjectWidgets = new ArrayList<TileWidget>(projectWidgets);
        Collections.sort(sortedProjectWidgets, Comparator.comparing(o -> o.getLabel().toUpperCase()));
        return sortedProjectWidgets;
    }

    private Command selectCommand(TileWidget tileWidget) {
        return () -> tileWidget.setSelected(!tileWidget.isSelected());
    }

    public List<TileWidget> filterProjects(String filter) {
        List<TileWidget> filteredProjectWidgets = this.projectWidgetsByName.entrySet().stream().filter(p -> ((ExampleProject)p.getKey()).getName().toUpperCase().contains(filter.toUpperCase())).map(Map.Entry::getValue).collect(Collectors.toList());
        this.updateView(filteredProjectWidgets);
        return filteredProjectWidgets;
    }

    public void ok() {
        List<ExampleProject> projects = this.projectWidgetsByName.entrySet().stream().filter(p -> ((TileWidget)p.getValue()).isSelected()).map(Map.Entry::getKey).collect(Collectors.toList());
        if (projects.isEmpty()) {
            this.notificationEvent.fire((Object)new NotificationEvent(this.view.getNoProjectsSelectedMessage(), NotificationEvent.NotificationType.ERROR));
            return;
        }
        this.view.showBusyIndicator(this.view.getImportingMessage());
        this.importProjects(projects, (RemoteCallback<WorkspaceProjectContextChangeEvent>)((RemoteCallback)event -> {
            this.view.hideBusyIndicator();
            this.notificationEvent.fire((Object)new NotificationEvent(this.view.getImportProjectsSuccessMessage(), NotificationEvent.NotificationType.SUCCESS));
            this.projectContextChangeEvent.fire(event);
        }), (ErrorCallback<Message>)new HasBusyIndicatorDefaultErrorCallback((HasBusyIndicator)this.view));
    }

    public void cancel() {
        this.libraryPlaces.goToLibrary();
    }

    public View getView() {
        return this.view;
    }

    public static interface View
    extends UberElement<ImportPresenter>,
    HasBusyIndicator {
        public void setTitle(String var1);

        public void clearProjects();

        public void addProject(HTMLElement var1);

        public String getNumberOfAssetsMessage(int var1);

        public String getTrySamplesLabel();

        public String getNoProjectsToImportMessage();

        public String getImportingMessage();

        public String getLoadingMessage();

        public String getNoProjectsSelectedMessage();

        public String getImportProjectsSuccessMessage();
    }

    private static final class ExamplesImportPresenter
    extends ImportPresenter {
        private Caller<ExamplesService> examplesService;

        private ExamplesImportPresenter(View view, LibraryPlaces libraryPlaces, Caller<LibraryService> libraryService, ManagedInstance<TileWidget> tileWidgets, Caller<ExamplesService> examplesService, WorkspaceProjectContext projectContext, Event<NotificationEvent> notificationEvent, Event<WorkspaceProjectContextChangeEvent> projectContextChangeEvent) {
            super(view, libraryPlaces, libraryService, tileWidgets, projectContext, notificationEvent, projectContextChangeEvent);
            this.examplesService = examplesService;
        }

        @Override
        protected void loadProjects(PlaceRequest placeRequest, RemoteCallback<Set<ExampleProject>> callback) {
            this.view.showBusyIndicator(this.view.getLoadingMessage());
            ((LibraryService)this.libraryService.call(callback, (ErrorCallback)this.loadingErrorCallback())).getExampleProjects();
        }

        @Override
        protected void importProjects(List<ExampleProject> projects, RemoteCallback<WorkspaceProjectContextChangeEvent> callback, ErrorCallback<Message> errorCallback) {
            ((ExamplesService)this.examplesService.call(callback, errorCallback)).setupExamples(new ExampleOrganizationalUnit(this.activeOrganizationalUnit().getName()), projects);
        }

        private OrganizationalUnit activeOrganizationalUnit() {
            return (OrganizationalUnit)this.projectContext.getActiveOrganizationalUnit().orElseThrow(() -> new IllegalStateException("Cannot setup examples without an active organizational unit."));
        }
    }
}

