/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.library.client.screens.importrepository;

import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.guvnor.common.services.project.client.context.WorkspaceProjectContext;
import org.guvnor.common.services.project.model.WorkspaceProject;
import org.guvnor.structure.organizationalunit.OrganizationalUnit;
import org.jboss.errai.bus.client.api.messaging.Message;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.ErrorCallback;
import org.kie.workbench.common.screens.library.api.LibraryService;
import org.kie.workbench.common.screens.library.client.util.LibraryPlaces;
import org.uberfire.client.mvp.UberElement;
import org.uberfire.ext.widgets.common.client.callbacks.DefaultErrorCallback;
import org.uberfire.ext.widgets.common.client.common.HasBusyIndicator;

public class ImportRepositoryPopUpPresenter {
    private View view;
    private Caller<LibraryService> libraryService;
    private LibraryPlaces libraryPlaces;
    private WorkspaceProjectContext context;

    @Inject
    public ImportRepositoryPopUpPresenter(View view, LibraryPlaces libraryPlaces, WorkspaceProjectContext context, Caller<LibraryService> libraryService) {
        this.view = view;
        this.libraryPlaces = libraryPlaces;
        this.context = context;
        this.libraryService = libraryService;
    }

    @PostConstruct
    public void setup() {
        this.view.init(this);
    }

    public void show() {
        this.view.show();
    }

    public void importRepository() {
        String repositoryUrl = this.view.getRepositoryURL();
        if (this.isEmpty(repositoryUrl)) {
            this.view.showError(this.view.getEmptyRepositoryURLValidationMessage());
            return;
        }
        OrganizationalUnit ou = (OrganizationalUnit)this.context.getActiveOrganizationalUnit().orElseThrow(() -> new IllegalStateException("Cannot import project without an active organizational unit."));
        this.view.showBusyIndicator(this.view.getLoadingMessage());
        ((LibraryService)this.libraryService.call(project -> {
            this.view.hideBusyIndicator();
            this.view.hide();
            this.libraryPlaces.goToProject((WorkspaceProject)project);
        }, (ErrorCallback)new DefaultErrorCallback(){

            public boolean error(Message message, Throwable throwable) {
                ImportRepositoryPopUpPresenter.this.view.hideBusyIndicator();
                ImportRepositoryPopUpPresenter.this.view.showError(ImportRepositoryPopUpPresenter.this.view.getNoProjectsToImportMessage());
                return false;
            }
        })).importProject(ou, repositoryUrl, this.view.getUserName(), this.view.getPassword());
    }

    public void cancel() {
        this.view.hide();
    }

    public View getView() {
        return this.view;
    }

    private boolean isEmpty(String text) {
        return text == null || text.trim().isEmpty();
    }

    public static interface View
    extends UberElement<ImportRepositoryPopUpPresenter>,
    HasBusyIndicator {
        public String getRepositoryURL();

        public String getUserName();

        public String getPassword();

        public void show();

        public void hide();

        public void showError(String var1);

        public String getLoadingMessage();

        public String getNoProjectsToImportMessage();

        public String getEmptyRepositoryURLValidationMessage();
    }
}

