/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.library.client.screens.organizationalunit;

import java.util.List;
import javax.annotation.PostConstruct;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.guvnor.common.services.project.client.context.WorkspaceProjectContext;
import org.guvnor.common.services.project.context.WorkspaceProjectContextChangeEvent;
import org.guvnor.structure.client.security.OrganizationalUnitController;
import org.guvnor.structure.organizationalunit.NewOrganizationalUnitEvent;
import org.guvnor.structure.organizationalunit.OrganizationalUnit;
import org.guvnor.structure.organizationalunit.RemoveOrganizationalUnitEvent;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.dom.HTMLElement;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.kie.workbench.common.screens.library.api.LibraryService;
import org.kie.workbench.common.screens.library.api.OrganizationalUnitRepositoryInfo;
import org.kie.workbench.common.screens.library.api.cluster.ClusterLibraryEvent;
import org.kie.workbench.common.screens.library.api.preferences.LibraryInternalPreferences;
import org.kie.workbench.common.screens.library.client.perspective.LibraryPerspective;
import org.kie.workbench.common.screens.library.client.screens.organizationalunit.EmptyOrganizationalUnitsScreen;
import org.kie.workbench.common.screens.library.client.screens.organizationalunit.popup.OrganizationalUnitPopUpPresenter;
import org.kie.workbench.common.screens.library.client.util.LibraryPlaces;
import org.kie.workbench.common.screens.library.client.widgets.common.TileWidget;
import org.uberfire.client.annotations.WorkbenchPartTitle;
import org.uberfire.client.annotations.WorkbenchPartView;
import org.uberfire.client.annotations.WorkbenchScreen;
import org.uberfire.client.mvp.UberElement;
import org.uberfire.ext.widgets.common.client.common.HasBusyIndicator;
import org.uberfire.lifecycle.OnStartup;

@WorkbenchScreen(identifier="LibraryOrganizationalUnitsScreen", owningPerspective=LibraryPerspective.class)
public class OrganizationalUnitsScreen {
    private View view;
    private LibraryPlaces libraryPlaces;
    private Caller<LibraryService> libraryService;
    private OrganizationalUnitPopUpPresenter organizationalUnitPopUpPresenter;
    private OrganizationalUnitController organizationalUnitController;
    private ManagedInstance<TileWidget> organizationalUnitTileWidgets;
    private Event<WorkspaceProjectContextChangeEvent> projectContextChangeEvent;
    private WorkspaceProjectContext projectContext;
    private LibraryInternalPreferences libraryInternalPreferences;
    private EmptyOrganizationalUnitsScreen emptyOrganizationalUnitsScreen;
    List<OrganizationalUnit> organizationalUnits;

    @Inject
    public OrganizationalUnitsScreen(View view, LibraryPlaces libraryPlaces, Caller<LibraryService> libraryService, OrganizationalUnitPopUpPresenter organizationalUnitPopUpPresenter, OrganizationalUnitController organizationalUnitController, ManagedInstance<TileWidget> organizationalUnitTileWidgets, Event<WorkspaceProjectContextChangeEvent> projectContextChangeEvent, WorkspaceProjectContext projectContext, LibraryInternalPreferences libraryInternalPreferences, EmptyOrganizationalUnitsScreen emptyOrganizationalUnitsScreen) {
        this.view = view;
        this.libraryPlaces = libraryPlaces;
        this.libraryService = libraryService;
        this.organizationalUnitPopUpPresenter = organizationalUnitPopUpPresenter;
        this.organizationalUnitController = organizationalUnitController;
        this.organizationalUnitTileWidgets = organizationalUnitTileWidgets;
        this.projectContextChangeEvent = projectContextChangeEvent;
        this.projectContext = projectContext;
        this.libraryInternalPreferences = libraryInternalPreferences;
        this.emptyOrganizationalUnitsScreen = emptyOrganizationalUnitsScreen;
    }

    @PostConstruct
    public void init() {
        this.setupOrganizationalUnits();
    }

    @OnStartup
    public void onStartup() {
        this.projectContextChangeEvent.fire((Object)new WorkspaceProjectContextChangeEvent());
    }

    private void setupView() {
        if (this.canCreateOrganizationalUnit()) {
            this.view.showCreateOrganizationalUnitAction();
        }
    }

    void setupOrganizationalUnits() {
        if (this.organizationalUnitController.canReadOrgUnits()) {
            this.view.showBusyIndicator();
            ((LibraryService)this.libraryService.call(allOrganizationalUnits -> {
                this.organizationalUnits = allOrganizationalUnits;
                if (allOrganizationalUnits.isEmpty()) {
                    this.view.showNoOrganizationalUnits(this.emptyOrganizationalUnitsScreen.getView().getElement());
                } else {
                    this.refresh();
                }
                this.setupView();
                this.view.hideBusyIndicator();
            })).getOrganizationalUnits();
        }
    }

    public void refresh() {
        this.view.clearOrganizationalUnits();
        this.organizationalUnits.forEach(organizationalUnit -> {
            TileWidget tileWidget = (TileWidget)this.organizationalUnitTileWidgets.get();
            tileWidget.init(organizationalUnit.getName(), this.view.getNumberOfContributorsLabel(organizationalUnit.getContributors().size()), String.valueOf(organizationalUnit.getRepositories().size()), this.view.getNumberOfRepositoriesLabel(organizationalUnit.getRepositories().size()), () -> this.open((OrganizationalUnit)organizationalUnit));
            this.view.addOrganizationalUnit(tileWidget);
        });
    }

    public OrganizationalUnitRepositoryInfo open(OrganizationalUnit organizationalUnit) {
        return ((LibraryService)this.libraryService.call(info -> {
            this.libraryInternalPreferences.load(loadedLibraryInternalPreferences -> {
                loadedLibraryInternalPreferences.setLastOpenedOrganizationalUnit(info.getSelectedOrganizationalUnit().getIdentifier());
                loadedLibraryInternalPreferences.save();
            }, error -> {});
            WorkspaceProjectContextChangeEvent event = new WorkspaceProjectContextChangeEvent(info.getSelectedOrganizationalUnit());
            this.projectContextChangeEvent.fire((Object)event);
            this.libraryPlaces.goToLibrary();
        })).getOrganizationalUnitRepositoryInfo(organizationalUnit);
    }

    public void createOrganizationalUnit() {
        this.organizationalUnitPopUpPresenter.show();
    }

    public void onNewOrganizationalUnitEvent(@Observes NewOrganizationalUnitEvent newOrganizationalUnitEvent) {
        this.setupOrganizationalUnits();
    }

    public void onRemoveOrganizationalUnitEvent(@Observes RemoveOrganizationalUnitEvent removeOrganizationalUnitEvent) {
        this.setupOrganizationalUnits();
    }

    public void onClusterLibraryEvent(@Observes ClusterLibraryEvent clusterLibraryEvent) {
        this.setupOrganizationalUnits();
    }

    public boolean canCreateOrganizationalUnit() {
        return this.organizationalUnitController.canCreateOrgUnits();
    }

    @WorkbenchPartTitle
    public String getTitle() {
        return "Organizational Units Screen";
    }

    @WorkbenchPartView
    public UberElement<OrganizationalUnitsScreen> getView() {
        return this.view;
    }

    public static interface View
    extends UberElement<OrganizationalUnitsScreen>,
    HasBusyIndicator {
        public void clearOrganizationalUnits();

        public void showCreateOrganizationalUnitAction();

        public void addOrganizationalUnit(TileWidget var1);

        public String getNumberOfContributorsLabel(int var1);

        public String getNumberOfRepositoriesLabel(int var1);

        public void showNoOrganizationalUnits(HTMLElement var1);

        public void showBusyIndicator();
    }
}

