/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.library.client.screens.organizationalunit;

import com.google.gwt.event.dom.client.ClickEvent;
import javax.inject.Inject;
import org.jboss.errai.common.client.dom.Button;
import org.jboss.errai.common.client.dom.Div;
import org.jboss.errai.common.client.dom.HTMLElement;
import org.jboss.errai.common.client.dom.Node;
import org.jboss.errai.ui.client.local.api.IsElement;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.EventHandler;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.kie.workbench.common.screens.library.client.screens.organizationalunit.OrganizationalUnitsScreen;
import org.kie.workbench.common.screens.library.client.util.TranslationUtils;
import org.kie.workbench.common.screens.library.client.widgets.common.TileWidget;
import org.uberfire.ext.widgets.common.client.common.BusyPopup;

@Templated
public class OrganizationalUnitsView
implements OrganizationalUnitsScreen.View,
IsElement {
    private OrganizationalUnitsScreen presenter;
    @Inject
    private TranslationService ts;
    @Inject
    private TranslationUtils translationUtils;
    @Inject
    @DataField(value="title")
    Div title;
    @Inject
    @DataField(value="create-organizational-unit")
    Button createOrganizationalUnit;
    @Inject
    @DataField(value="cards-container")
    Div cardsContainer;

    public void init(OrganizationalUnitsScreen presenter) {
        this.presenter = presenter;
        this.createOrganizationalUnit.setTextContent(this.ts.format("CreateOrganizationalUnit", new Object[]{this.translationUtils.getOrganizationalUnitAliasInSingular()}));
        this.title.setTextContent(this.translationUtils.getOrganizationalUnitAliasInPlural());
    }

    @Override
    public void clearOrganizationalUnits() {
        this.cardsContainer.setTextContent("");
    }

    @Override
    public void showCreateOrganizationalUnitAction() {
        this.createOrganizationalUnit.setHidden(false);
    }

    @Override
    public void addOrganizationalUnit(TileWidget tileWidget) {
        this.cardsContainer.appendChild((Node)tileWidget.getView().getElement());
    }

    @Override
    public String getNumberOfContributorsLabel(int numberOfContributors) {
        return this.ts.format("NumberOfContributors", new Object[]{numberOfContributors});
    }

    @Override
    public String getNumberOfRepositoriesLabel(int numberOfRepositories) {
        return this.ts.format("NumberOfRepositories", new Object[]{numberOfRepositories});
    }

    @Override
    public void showNoOrganizationalUnits(HTMLElement view) {
        this.cardsContainer.appendChild((Node)view);
    }

    @EventHandler(value={"create-organizational-unit"})
    public void createOrganizationalUnit(ClickEvent event) {
        this.presenter.createOrganizationalUnit();
    }

    @Override
    public void showBusyIndicator() {
        this.showBusyIndicator(this.ts.format("Loading", new Object[0]));
    }

    public void showBusyIndicator(String message) {
        BusyPopup.showMessage((String)message);
    }

    public void hideBusyIndicator() {
        BusyPopup.close();
    }
}

