/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.library.client.screens.organizationalunit.contributors.edit;

import java.util.List;
import javax.annotation.PostConstruct;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.guvnor.structure.client.security.OrganizationalUnitController;
import org.guvnor.structure.events.AfterEditOrganizationalUnitEvent;
import org.guvnor.structure.organizationalunit.OrganizationalUnit;
import org.guvnor.structure.organizationalunit.OrganizationalUnitService;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.ErrorCallback;
import org.jboss.errai.common.client.dom.HTMLElement;
import org.kie.workbench.common.screens.library.client.screens.organizationalunit.contributors.widget.ContributorsManagementPresenter;
import org.uberfire.client.mvp.UberElement;
import org.uberfire.ext.widgets.common.client.callbacks.HasBusyIndicatorDefaultErrorCallback;
import org.uberfire.ext.widgets.common.client.common.HasBusyIndicator;
import org.uberfire.workbench.events.NotificationEvent;

public class EditContributorsPopUpPresenter {
    private View view;
    private ContributorsManagementPresenter contributorsManagementPresenter;
    private Event<AfterEditOrganizationalUnitEvent> afterEditOrganizationalUnitEvent;
    private Event<NotificationEvent> notificationEvent;
    private OrganizationalUnitController organizationalUnitController;
    private Caller<OrganizationalUnitService> organizationalUnitService;
    OrganizationalUnit organizationalUnit;

    @Inject
    public EditContributorsPopUpPresenter(View view, ContributorsManagementPresenter contributorsManagementPresenter, Event<AfterEditOrganizationalUnitEvent> afterEditOrganizationalUnitEvent, Event<NotificationEvent> notificationEvent, OrganizationalUnitController organizationalUnitController, Caller<OrganizationalUnitService> organizationalUnitService) {
        this.view = view;
        this.contributorsManagementPresenter = contributorsManagementPresenter;
        this.afterEditOrganizationalUnitEvent = afterEditOrganizationalUnitEvent;
        this.notificationEvent = notificationEvent;
        this.organizationalUnitController = organizationalUnitController;
        this.organizationalUnitService = organizationalUnitService;
    }

    @PostConstruct
    public void setup() {
        this.view.init(this);
    }

    public void show(OrganizationalUnit organizationalUnit) {
        if (this.organizationalUnitController.canUpdateOrgUnit(organizationalUnit)) {
            this.contributorsManagementPresenter.setup(organizationalUnit);
            this.view.append(this.contributorsManagementPresenter.getView().getElement());
            this.view.show(organizationalUnit);
            this.organizationalUnit = organizationalUnit;
        }
    }

    public void save() {
        List<String> contributors = this.contributorsManagementPresenter.getSelectedContributorsUserNames();
        this.view.showBusyIndicator(this.view.getSavingMessage());
        ((OrganizationalUnitService)this.organizationalUnitService.call(newOrganizationalUnit -> {
            this.afterEditOrganizationalUnitEvent.fire((Object)new AfterEditOrganizationalUnitEvent(this.organizationalUnit, newOrganizationalUnit));
            this.view.hideBusyIndicator();
            this.notificationEvent.fire((Object)new NotificationEvent(this.view.getSaveSuccessMessage(), NotificationEvent.NotificationType.SUCCESS));
            this.view.hide();
        }, (ErrorCallback)new HasBusyIndicatorDefaultErrorCallback((HasBusyIndicator)this.view))).updateOrganizationalUnit(this.organizationalUnit.getName(), this.organizationalUnit.getOwner(), this.organizationalUnit.getDefaultGroupId(), contributors);
    }

    public void cancel() {
        this.view.hide();
    }

    public static interface View
    extends UberElement<EditContributorsPopUpPresenter>,
    HasBusyIndicator {
        public void show(OrganizationalUnit var1);

        public void hide();

        public String getSavingMessage();

        public String getSaveSuccessMessage();

        public void append(HTMLElement var1);
    }
}

