/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.library.client.screens.organizationalunit.contributors.widget;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.ext.uberfire.social.activities.model.SocialUser;
import org.guvnor.structure.organizationalunit.OrganizationalUnit;
import org.guvnor.structure.organizationalunit.OrganizationalUnitService;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.kie.workbench.common.screens.library.api.LibraryService;
import org.kie.workbench.common.screens.library.client.screens.organizationalunit.contributors.widget.ContributorsManagementListItemPresenter;
import org.uberfire.client.mvp.UberElement;
import org.uberfire.rpc.SessionInfo;

public class ContributorsManagementPresenter {
    private View view;
    private Caller<OrganizationalUnitService> organizationalUnitService;
    private Caller<LibraryService> libraryService;
    private ManagedInstance<ContributorsManagementListItemPresenter> contributorsManagementListItemPresenters;
    private SessionInfo sessionInfo;
    private List<SocialUser> allUsers;
    private Map<String, ContributorsManagementListItemPresenter> contributorsByUserName;

    @Inject
    public ContributorsManagementPresenter(View view, Caller<OrganizationalUnitService> organizationalUnitService, Caller<LibraryService> libraryService, ManagedInstance<ContributorsManagementListItemPresenter> contributorsManagementListItemPresenters, SessionInfo sessionInfo) {
        this.view = view;
        this.organizationalUnitService = organizationalUnitService;
        this.libraryService = libraryService;
        this.contributorsManagementListItemPresenters = contributorsManagementListItemPresenters;
        this.sessionInfo = sessionInfo;
    }

    public void setup() {
        this.setup(null);
    }

    public void setup(OrganizationalUnit organizationalUnit) {
        this.view.init(this);
        this.view.clearFilter();
        this.contributorsByUserName = new HashMap<String, ContributorsManagementListItemPresenter>();
        ((LibraryService)this.libraryService.call(allUsers -> {
            this.allUsers = allUsers;
            for (SocialUser user : allUsers) {
                ContributorsManagementListItemPresenter contributor = (ContributorsManagementListItemPresenter)this.contributorsManagementListItemPresenters.get();
                contributor.setup(user);
                this.contributorsByUserName.put(user.getUserName(), contributor);
            }
            if (organizationalUnit != null) {
                organizationalUnit.getContributors().forEach(this::selectContributor);
                this.selectOwner(organizationalUnit.getOwner());
            } else {
                this.selectOwner(this.sessionInfo.getIdentity().getIdentifier());
            }
            this.listUsers((List<SocialUser>)allUsers);
        })).getAllUsers();
    }

    public void filter() {
        String filterText = this.view.getFilterText();
        List<SocialUser> filteredUsers = this.allUsers.stream().filter(user -> {
            String name = user.getName();
            String userName = user.getUserName();
            boolean nameMatch = name != null && name.contains(filterText);
            boolean userNameMatch = userName.contains(filterText);
            return nameMatch || userNameMatch;
        }).collect(Collectors.toList());
        this.listUsers(filteredUsers);
    }

    public List<String> getSelectedContributorsUserNames() {
        return this.contributorsByUserName.entrySet().stream().filter(entry -> ((ContributorsManagementListItemPresenter)entry.getValue()).isSelected()).map(Map.Entry::getKey).collect(Collectors.toList());
    }

    private void listUsers(List<SocialUser> users) {
        this.view.clearUsers();
        users.forEach(user -> {
            ContributorsManagementListItemPresenter contributor = this.contributorsByUserName.get(user.getUserName());
            this.view.addUser(contributor);
        });
    }

    private void selectOwner(String userName) {
        this.selectUser(userName, true);
    }

    private void selectContributor(String userName) {
        this.selectUser(userName, false);
    }

    private void selectUser(String userName, boolean owner) {
        ContributorsManagementListItemPresenter contributor = this.contributorsByUserName.get(userName);
        if (contributor != null) {
            contributor.setSelected(true);
            contributor.setEnabled(!owner);
        }
    }

    public View getView() {
        return this.view;
    }

    public static interface View
    extends UberElement<ContributorsManagementPresenter> {
        public String getFilterText();

        public void clearFilter();

        public void clearUsers();

        public void addUser(ContributorsManagementListItemPresenter var1);
    }
}

