/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.library.client.screens.organizationalunit.popup;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.guvnor.structure.client.security.OrganizationalUnitController;
import org.guvnor.structure.events.AfterCreateOrganizationalUnitEvent;
import org.guvnor.structure.events.AfterEditOrganizationalUnitEvent;
import org.guvnor.structure.organizationalunit.OrganizationalUnit;
import org.guvnor.structure.organizationalunit.OrganizationalUnitService;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.ErrorCallback;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.jboss.errai.common.client.dom.HTMLElement;
import org.kie.workbench.common.screens.library.client.screens.organizationalunit.contributors.widget.ContributorsManagementPresenter;
import org.uberfire.client.mvp.UberElement;
import org.uberfire.ext.widgets.common.client.callbacks.HasBusyIndicatorDefaultErrorCallback;
import org.uberfire.ext.widgets.common.client.common.HasBusyIndicator;
import org.uberfire.mvp.Command;
import org.uberfire.rpc.SessionInfo;
import org.uberfire.workbench.events.NotificationEvent;

public class OrganizationalUnitPopUpPresenter {
    private View view;
    private Caller<OrganizationalUnitService> organizationalUnitService;
    private Event<AfterCreateOrganizationalUnitEvent> afterCreateOrganizationalUnitEvent;
    private Event<AfterEditOrganizationalUnitEvent> afterEditOrganizationalUnitEvent;
    private Event<NotificationEvent> notificationEvent;
    private OrganizationalUnitController organizationalUnitController;
    private ContributorsManagementPresenter contributorsManagementPresenter;
    private SessionInfo sessionInfo;
    private OrganizationalUnit organizationalUnit;

    @Inject
    public OrganizationalUnitPopUpPresenter(View view, Caller<OrganizationalUnitService> organizationalUnitService, Event<AfterCreateOrganizationalUnitEvent> afterCreateOrganizationalUnitEvent, Event<AfterEditOrganizationalUnitEvent> afterEditOrganizationalUnitEvent, Event<NotificationEvent> notificationEvent, OrganizationalUnitController organizationalUnitController, ContributorsManagementPresenter contributorsManagementPresenter, SessionInfo sessionInfo) {
        this.view = view;
        this.organizationalUnitService = organizationalUnitService;
        this.afterCreateOrganizationalUnitEvent = afterCreateOrganizationalUnitEvent;
        this.afterEditOrganizationalUnitEvent = afterEditOrganizationalUnitEvent;
        this.notificationEvent = notificationEvent;
        this.organizationalUnitController = organizationalUnitController;
        this.contributorsManagementPresenter = contributorsManagementPresenter;
        this.sessionInfo = sessionInfo;
    }

    @PostConstruct
    public void setup() {
        this.view.init(this);
    }

    public void show() {
        if (this.organizationalUnitController.canCreateOrgUnits()) {
            this.contributorsManagementPresenter.setup();
            this.view.append(this.contributorsManagementPresenter.getView().getElement());
            this.view.clear();
            this.view.show();
        }
    }

    public void save() {
        String name = this.view.getName();
        String defaultGroupId = "com." + this.view.getName().toLowerCase();
        String owner = this.sessionInfo.getIdentity().getIdentifier();
        this.view.showBusyIndicator(this.view.getSavingMessage());
        this.validateFields(() -> this.saveCreation(name, defaultGroupId, owner));
    }

    void saveCreation(String name, String defaultGroupId, String owner) {
        Command saveCommand = () -> {
            ArrayList repositories = new ArrayList();
            List<String> contributors = this.contributorsManagementPresenter.getSelectedContributorsUserNames();
            RemoteCallback successCallback = newOrganizationalUnit -> {
                this.afterCreateOrganizationalUnitEvent.fire((Object)new AfterCreateOrganizationalUnitEvent(newOrganizationalUnit));
                this.view.hideBusyIndicator();
                this.notificationEvent.fire((Object)new NotificationEvent(this.view.getSaveSuccessMessage(), NotificationEvent.NotificationType.SUCCESS));
                this.view.hide();
            };
            HasBusyIndicatorDefaultErrorCallback errorCallback = new HasBusyIndicatorDefaultErrorCallback((HasBusyIndicator)this.view);
            ((OrganizationalUnitService)this.organizationalUnitService.call(successCallback, (ErrorCallback)errorCallback)).createOrganizationalUnit(name, owner, defaultGroupId, repositories, contributors);
        };
        this.validateDuplicatedOrganizationalUnit(name, saveCommand);
    }

    private void validateFields(Command successCallback) {
        String name = this.view.getName();
        if (this.isEmpty(name)) {
            this.view.hideBusyIndicator();
            this.view.showError(this.view.getEmptyNameValidationMessage());
            return;
        }
        String defaultGroupId = "com." + this.view.getName().toLowerCase();
        ((OrganizationalUnitService)this.organizationalUnitService.call(valid -> {
            if (!valid.booleanValue()) {
                this.view.hideBusyIndicator();
                this.view.showError(this.view.getInvalidNameValidationMessage());
                return;
            }
            if (successCallback != null) {
                successCallback.execute();
            }
        }, (ErrorCallback)new HasBusyIndicatorDefaultErrorCallback((HasBusyIndicator)this.view))).isValidGroupId(defaultGroupId);
    }

    private void validateDuplicatedOrganizationalUnit(String name, Command successCallback) {
        ((OrganizationalUnitService)this.organizationalUnitService.call(existingOrganizationalUnit -> {
            if (existingOrganizationalUnit != null) {
                this.view.hideBusyIndicator();
                this.view.showError(this.view.getDuplicatedOrganizationalUnitValidationMessage());
                return;
            }
            if (successCallback != null) {
                successCallback.execute();
            }
        })).getOrganizationalUnit(name);
    }

    public void cancel() {
        this.view.hide();
    }

    private boolean isEmpty(String text) {
        return text == null || text.trim().isEmpty();
    }

    public static interface View
    extends UberElement<OrganizationalUnitPopUpPresenter>,
    HasBusyIndicator {
        public void show();

        public void hide();

        public void clear();

        public void showError(String var1);

        public String getName();

        public String getEmptyNameValidationMessage();

        public String getDuplicatedOrganizationalUnitValidationMessage();

        public String getSavingMessage();

        public String getSaveSuccessMessage();

        public String getInvalidNameValidationMessage();

        public void append(HTMLElement var1);
    }
}

