/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.library.client.screens.project.delete;

import javax.annotation.PostConstruct;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.guvnor.common.services.project.client.security.ProjectController;
import org.guvnor.common.services.project.events.DeleteModuleEvent;
import org.guvnor.common.services.project.model.WorkspaceProject;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.ErrorCallback;
import org.kie.workbench.common.screens.library.client.util.LibraryPlaces;
import org.kie.workbench.common.services.shared.project.KieModuleService;
import org.uberfire.client.mvp.UberElemental;
import org.uberfire.ext.widgets.common.client.callbacks.HasBusyIndicatorDefaultErrorCallback;
import org.uberfire.ext.widgets.common.client.common.HasBusyIndicator;
import org.uberfire.workbench.events.NotificationEvent;

public class DeleteProjectPopUpScreen {
    public static final String PROJECT_DELETED = "Project deleted";
    private WorkspaceProject project;
    private View view;
    private Caller<KieModuleService> projectService;
    private ProjectController projectController;
    private Event<DeleteModuleEvent> deleteProjectEvent;
    private Event<NotificationEvent> notificationEvent;
    private LibraryPlaces libraryPlaces;

    @Inject
    public DeleteProjectPopUpScreen(View view, Caller<KieModuleService> projectService, ProjectController projectController, Event<NotificationEvent> notificationEvent, LibraryPlaces libraryPlaces) {
        this.view = view;
        this.projectService = projectService;
        this.projectController = projectController;
        this.notificationEvent = notificationEvent;
        this.libraryPlaces = libraryPlaces;
    }

    @PostConstruct
    public void setup() {
        this.view.init(this);
    }

    public void show(WorkspaceProject project) {
        this.project = project;
        this.view.show(project.getMainModule().getModuleName());
    }

    public void delete() {
        String confirmedName = this.view.getConfirmedName();
        if (!this.project.getMainModule().getModuleName().equals(confirmedName)) {
            this.view.showError(this.view.getWrongConfirmedNameValidationMessage());
            return;
        }
        this.view.showBusyIndicator(this.view.getDeletingMessage());
        ((KieModuleService)this.projectService.call(v -> {
            this.view.hideBusyIndicator();
            this.view.hide();
        }, (ErrorCallback)new HasBusyIndicatorDefaultErrorCallback((HasBusyIndicator)this.view))).delete(this.project.getMainModule().getPomXMLPath(), PROJECT_DELETED);
    }

    public void cancel() {
        this.view.hide();
    }

    public static interface View
    extends UberElemental<DeleteProjectPopUpScreen>,
    HasBusyIndicator {
        public String getConfirmedName();

        public void show(String var1);

        public void showError(String var1);

        public void hide();

        public String getWrongConfirmedNameValidationMessage();

        public String getDeletingMessage();

        public String getDeleteSuccessMessage();
    }
}

