/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.library.client.settings;

import elemental2.dom.DomGlobal;
import elemental2.dom.Element;
import elemental2.dom.HTMLElement;
import elemental2.promise.Promise;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.guvnor.common.services.project.client.context.WorkspaceProjectContext;
import org.guvnor.common.services.project.client.repositories.ConflictingRepositoriesPopup;
import org.guvnor.common.services.project.model.Module;
import org.guvnor.common.services.project.service.DeploymentMode;
import org.guvnor.common.services.project.service.GAVAlreadyExistsException;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.jboss.errai.security.shared.api.identity.User;
import org.jboss.errai.ui.client.local.api.elemental2.IsElement;
import org.kie.workbench.common.screens.library.client.settings.SettingsSectionChange;
import org.kie.workbench.common.screens.library.client.settings.SettingsSections;
import org.kie.workbench.common.screens.library.client.settings.util.ListItemPresenter;
import org.kie.workbench.common.screens.library.client.settings.util.ListPresenter;
import org.kie.workbench.common.screens.library.client.settings.util.UberElementalListItem;
import org.kie.workbench.common.screens.projecteditor.model.ProjectScreenModel;
import org.kie.workbench.common.screens.projecteditor.service.ProjectScreenService;
import org.uberfire.annotations.Customizable;
import org.uberfire.backend.vfs.ObservablePath;
import org.uberfire.backend.vfs.Path;
import org.uberfire.client.mvp.UberElemental;
import org.uberfire.client.promise.Promises;
import org.uberfire.ext.editor.commons.client.file.popups.SavePopUpPresenter;
import org.uberfire.ext.widgets.common.client.callbacks.DefaultErrorCallback;
import org.uberfire.ext.widgets.common.client.common.ConcurrentChangePopup;
import org.uberfire.ext.widgets.common.client.common.HasBusyIndicator;
import org.uberfire.lifecycle.OnOpen;
import org.uberfire.workbench.events.NotificationEvent;

@ApplicationScoped
public class SettingsPresenter {
    private final View view;
    private final Promises promises;
    private final Event<NotificationEvent> notificationEvent;
    private final SettingsSections settingsSections;
    private final SavePopUpPresenter savePopUpPresenter;
    private final Caller<ProjectScreenService> projectScreenService;
    private final WorkspaceProjectContext projectContext;
    private final MenuItemsListPresenter menuItemsListPresenter;
    private final ManagedInstance<ObservablePath> observablePaths;
    private final ConflictingRepositoriesPopup conflictingRepositoriesPopup;
    private ObservablePath pathToPom;
    ObservablePath.OnConcurrentUpdateEvent concurrentPomUpdateInfo = null;
    ProjectScreenModel model;
    Section currentSection;
    Map<Section, Integer> originalHashCodes;
    List<Section> sections;

    @Inject
    public SettingsPresenter(View view, Promises promises, Event<NotificationEvent> notificationEvent, @Customizable SettingsSections settingsSections, SavePopUpPresenter savePopUpPresenter, Caller<ProjectScreenService> projectScreenService, WorkspaceProjectContext projectContext, MenuItemsListPresenter menuItemsListPresenter, ManagedInstance<ObservablePath> observablePaths, ConflictingRepositoriesPopup conflictingRepositoriesPopup) {
        this.view = view;
        this.promises = promises;
        this.notificationEvent = notificationEvent;
        this.settingsSections = settingsSections;
        this.savePopUpPresenter = savePopUpPresenter;
        this.projectScreenService = projectScreenService;
        this.projectContext = projectContext;
        this.menuItemsListPresenter = menuItemsListPresenter;
        this.observablePaths = observablePaths;
        this.conflictingRepositoriesPopup = conflictingRepositoriesPopup;
    }

    @PostConstruct
    public void setup() {
        this.sections = new ArrayList<Section>(this.settingsSections.getList());
        this.currentSection = this.sections.get(0);
        this.setActiveMenuItem();
    }

    protected void setActiveMenuItem() {
        ((MenuItem.View)this.currentSection.getMenuItem().getView()).getElement().classList.add(new String[]{"active"});
    }

    public Promise<Void> setup(Section activeSection) {
        this.currentSection = activeSection;
        this.view.init(this);
        this.view.showBusyIndicator();
        if (this.pathToPom != null) {
            this.pathToPom.dispose();
        }
        this.originalHashCodes = new HashMap<Section, Integer>();
        this.concurrentPomUpdateInfo = null;
        this.pathToPom = ((ObservablePath)this.observablePaths.get()).wrap(((Module)this.projectContext.getActiveModule().orElseThrow(() -> new RuntimeException("Can't get active module"))).getPomXMLPath());
        this.pathToPom.onConcurrentUpdate(info -> {
            this.concurrentPomUpdateInfo = info;
        });
        return this.promises.promisify(this.projectScreenService, s -> s.load((Path)this.pathToPom)).then(model -> {
            this.model = model;
            return this.setupSections((ProjectScreenModel)model);
        }).then(i -> {
            this.setupMenuItems();
            this.view.hideBusyIndicator();
            if (this.sections.contains(this.currentSection)) {
                return this.goTo(this.currentSection);
            }
            return this.goTo(this.sections.get(0));
        }).catch_(e -> this.promises.catchOrExecute(e, this::defaultErrorResolution, i -> {
            this.notificationEvent.fire((Object)new NotificationEvent(this.view.getLoadErrorMessage(), NotificationEvent.NotificationType.ERROR));
            this.view.hideBusyIndicator();
            return this.promises.resolve();
        }));
    }

    void setupMenuItems() {
        this.menuItemsListPresenter.setupWithPresenters((Element)this.view.getMenuItemsContainer(), this.sections.stream().map(Section::getMenuItem).collect(Collectors.toList()), (section, presenter) -> presenter.setup((Section)section, this));
    }

    Promise<Object> setupSections(ProjectScreenModel model) {
        ArrayList<Section> sections = new ArrayList<Section>(this.sections);
        Promise setupResult = this.promises.all(sections, section -> this.setupSection(model, (Section)section));
        if (this.sections.isEmpty()) {
            return this.promises.reject((Object)"No sections available");
        }
        return setupResult;
    }

    Promise<Object> setupSection(ProjectScreenModel model, Section section) {
        return this.promises.resolve().then(ignore -> section.setup(model)).catch_(e -> {
            this.sections.remove(section);
            this.notificationEvent.fire((Object)new NotificationEvent(this.getSectionSetupErrorMessage(section), NotificationEvent.NotificationType.WARNING));
            return this.promises.reject(e);
        }).then(i -> {
            section.getMenuItem().setup(section, this);
            this.resetDirtyIndicator(section);
            return this.promises.resolve();
        }).catch_(e -> {
            DomGlobal.console.info(new Object[]{e});
            return this.promises.resolve();
        });
    }

    String getSectionSetupErrorMessage(Section section) {
        return this.view.getSectionSetupErrorMessage(section.getView().getTitle());
    }

    public void showSaveModal() {
        this.promises.reduceLazily(this.sections, Section::validate).then(i -> {
            this.savePopUpPresenter.show(this::save);
            return this.promises.resolve();
        }).catch_(e -> this.promises.catchOrExecute(e, this::defaultErrorResolution, section -> {
            this.view.hideBusyIndicator();
            return this.goTo((Section)section);
        }));
    }

    void save(String comment) {
        this.promises.reduceLazilyChaining(this.getSavingSteps(comment), this::executeSavingStep).catch_(e -> this.promises.catchOrExecute(e, this::defaultErrorResolution, this::goTo));
    }

    private Promise<Void> executeSavingStep(Supplier<Promise<Void>> chain, SavingStep savingStep) {
        return savingStep.execute(chain);
    }

    private List<SavingStep> getSavingSteps(String comment) {
        Stream<SavingStep> saveSectionsSteps = this.sections.stream().map(section -> chain -> section.save(comment, chain));
        Stream<SavingStep> commonSavingSteps = Stream.of(chain -> this.saveProjectScreenModel(comment, DeploymentMode.VALIDATED, chain), chain -> this.promises.all(this.sections, this::resetDirtyIndicator), chain -> this.displaySuccessMessage());
        return Stream.concat(saveSectionsSteps, commonSavingSteps).collect(Collectors.toList());
    }

    Promise<Void> displaySuccessMessage() {
        this.view.hideBusyIndicator();
        this.notificationEvent.fire((Object)new NotificationEvent(this.view.getSaveSuccessMessage(), NotificationEvent.NotificationType.SUCCESS));
        return this.promises.resolve();
    }

    Promise<Void> resetDirtyIndicator(Section section) {
        this.originalHashCodes.put(section, section.currentHashCode());
        this.updateDirtyIndicator(section);
        return this.promises.resolve();
    }

    Promise<Void> saveProjectScreenModel(String comment, DeploymentMode mode, Supplier<Promise<Void>> chain) {
        if (this.concurrentPomUpdateInfo != null) {
            this.handlePomConcurrentUpdate(comment, chain);
            return this.promises.reject((Object)this.currentSection);
        }
        return this.promises.promisify(this.projectScreenService, s -> s.save((Path)this.pathToPom, this.model, comment, mode)).then(ret -> {
            this.projectContext.updateProjectModule(ret.getMainModule());
            return this.promises.resolve();
        }).catch_(e -> this.promises.catchOrExecute(e, this::defaultErrorResolution, arg_0 -> this.lambda$null$24(comment, (Supplier)chain, arg_0)));
    }

    Promise<Void> handleSaveProjectScreenModelError(String comment, Supplier<Promise<Void>> chain, Throwable throwable) {
        if (throwable instanceof GAVAlreadyExistsException) {
            return this.handlePomConcurrentUpdate(comment, chain, (GAVAlreadyExistsException)throwable);
        }
        return this.defaultErrorResolution(throwable);
    }

    void handlePomConcurrentUpdate(String comment, Supplier<Promise<Void>> chain) {
        ConcurrentChangePopup.newConcurrentUpdate((Path)this.concurrentPomUpdateInfo.getPath(), (User)this.concurrentPomUpdateInfo.getIdentity(), () -> this.forceSave(comment, chain), () -> {}, this::reset).show();
    }

    Promise<Void> handlePomConcurrentUpdate(String comment, Supplier<Promise<Void>> saveChain, GAVAlreadyExistsException exception) {
        this.view.hideBusyIndicator();
        this.conflictingRepositoriesPopup.setContent(this.model.getPOM().getGav(), exception.getRepositories(), () -> this.forceSave(comment, saveChain));
        this.conflictingRepositoriesPopup.show();
        return this.promises.reject((Object)this.currentSection);
    }

    void forceSave(String comment, Supplier<Promise<Void>> chain) {
        this.concurrentPomUpdateInfo = null;
        this.conflictingRepositoriesPopup.hide();
        this.saveProjectScreenModel(comment, DeploymentMode.FORCED, chain).then(i -> (Promise)chain.get());
    }

    Promise<Void> defaultErrorResolution(Throwable e) {
        new DefaultErrorCallback().error(null, e);
        this.view.hideBusyIndicator();
        return this.promises.resolve();
    }

    public void onSettingsSectionChanged(@Observes SettingsSectionChange settingsSectionChange) {
        this.updateDirtyIndicator(settingsSectionChange.getSection());
    }

    void updateDirtyIndicator(Section changedSection) {
        boolean isDirty = Optional.ofNullable(this.originalHashCodes.get(changedSection)).map(originalHashCode -> !originalHashCode.equals(changedSection.currentHashCode())).orElse(false);
        changedSection.setDirty(isDirty);
    }

    @OnOpen
    public void onOpen() {
        this.view.hide();
        this.setup(this.currentSection).then(i -> {
            this.view.show();
            return this.promises.resolve();
        });
    }

    public void reset() {
        this.setup(this.currentSection);
    }

    Promise<Void> goTo(Section section) {
        this.currentSection = section;
        this.view.setSection(section.getView());
        return this.promises.resolve();
    }

    public View getView() {
        return this.view;
    }

    private /* synthetic */ Promise lambda$null$24(String comment, Supplier chain, Promises.Error error) {
        return this.handleSaveProjectScreenModelError(comment, chain, error.getThrowable());
    }

    @FunctionalInterface
    private static interface SavingStep {
        public Promise<Void> execute(Supplier<Promise<Void>> var1);
    }

    @Dependent
    public static class MenuItem
    extends ListItemPresenter<Section, SettingsPresenter, View> {
        private final View view;
        private Section section;
        private SettingsPresenter settingsPresenter;

        @Inject
        public MenuItem(View view) {
            super(view);
            this.view = view;
        }

        public void showSection() {
            this.settingsPresenter.goTo(this.section);
        }

        public void markAsDirty(boolean dirty) {
            this.view.markAsDirty(dirty);
        }

        public MenuItem setup(Section section, SettingsPresenter settingsPresenter) {
            this.section = section;
            this.settingsPresenter = settingsPresenter;
            this.view.init(this);
            this.view.setLabel(section.getView().getTitle());
            return this;
        }

        @Override
        public Section getObject() {
            return this.section;
        }

        public static interface View
        extends UberElementalListItem<MenuItem>,
        IsElement {
            public void setLabel(String var1);

            public void markAsDirty(boolean var1);
        }
    }

    public static abstract class Section {
        protected final Promises promises;
        private final Event<SettingsSectionChange> settingsSectionChangeEvent;
        private final MenuItem menuItem;

        protected Section(Event<SettingsSectionChange> settingsSectionChangeEvent, MenuItem menuItem, Promises promises) {
            this.promises = promises;
            this.settingsSectionChangeEvent = settingsSectionChangeEvent;
            this.menuItem = menuItem;
        }

        public abstract View.Section getView();

        public abstract int currentHashCode();

        public Promise<Void> save(String comment, Supplier<Promise<Void>> chain) {
            return this.promises.resolve();
        }

        public Promise<Object> validate() {
            return this.promises.resolve();
        }

        public Promise<Void> setup(ProjectScreenModel model) {
            return this.promises.resolve();
        }

        public void fireChangeEvent() {
            this.settingsSectionChangeEvent.fire((Object)new SettingsSectionChange(this));
        }

        public MenuItem getMenuItem() {
            return this.menuItem;
        }

        public void setDirty(boolean dirty) {
            this.menuItem.markAsDirty(dirty);
        }
    }

    @Dependent
    public static class MenuItemsListPresenter
    extends ListPresenter<Section, MenuItem> {
        @Inject
        public MenuItemsListPresenter(ManagedInstance<MenuItem> itemPresenters) {
            super(itemPresenters);
        }
    }

    public static interface View
    extends UberElemental<SettingsPresenter>,
    HasBusyIndicator {
        public void showBusyIndicator();

        public void setSection(Section var1);

        public HTMLElement getMenuItemsContainer();

        public String getSaveSuccessMessage();

        public String getLoadErrorMessage();

        public String getSectionSetupErrorMessage(String var1);

        public void show();

        public void hide();

        public static interface Section<T>
        extends UberElemental<T>,
        IsElement {
            public String getTitle();
        }
    }
}

