/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.library.client.settings;

import com.google.gwt.event.dom.client.ClickEvent;
import elemental2.dom.HTMLAnchorElement;
import elemental2.dom.HTMLButtonElement;
import elemental2.dom.HTMLDivElement;
import elemental2.dom.HTMLElement;
import elemental2.dom.HTMLUListElement;
import elemental2.dom.Node;
import javax.inject.Inject;
import javax.inject.Named;
import org.jboss.errai.common.client.dom.elemental2.Elemental2DomUtil;
import org.jboss.errai.ui.client.local.api.elemental2.IsElement;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.EventHandler;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.kie.workbench.common.screens.library.client.settings.SettingsPresenter;
import org.uberfire.ext.widgets.common.client.common.BusyPopup;

@Templated
public class SettingsView
implements SettingsPresenter.View,
IsElement {
    private SettingsPresenter presenter;
    @Inject
    private TranslationService translationService;
    @Inject
    private Elemental2DomUtil elemental2DomUtil;
    @Inject
    @DataField(value="save")
    private HTMLButtonElement save;
    @Inject
    @DataField(value="reset")
    private HTMLButtonElement reset;
    @Inject
    @DataField(value="content")
    private HTMLDivElement content;
    @Inject
    @DataField(value="menu-items-container")
    private HTMLUListElement menuItemsContainer;

    public void init(SettingsPresenter presenter) {
        this.presenter = presenter;
    }

    @EventHandler(value={"save"})
    public void save(ClickEvent event) {
        this.presenter.showSaveModal();
    }

    @EventHandler(value={"reset"})
    public void reset(ClickEvent event) {
        this.presenter.reset();
    }

    @Override
    public void setSection(SettingsPresenter.View.Section section) {
        this.elemental2DomUtil.removeAllElementChildren((Node)this.content);
        this.content.appendChild((Node)section.getElement());
    }

    @Override
    public HTMLElement getMenuItemsContainer() {
        return this.menuItemsContainer;
    }

    @Override
    public String getSaveSuccessMessage() {
        return this.translationService.format("SettingsSaveSuccess", new Object[0]);
    }

    @Override
    public String getLoadErrorMessage() {
        return this.translationService.format("SettingsLoadError", new Object[0]);
    }

    @Override
    public String getSectionSetupErrorMessage(String title) {
        return this.translationService.format("SettingsSectionSetupError", new Object[]{title});
    }

    @Override
    public void hide() {
        this.getElement().classList.add(new String[]{"settings-hidden"});
    }

    @Override
    public void show() {
        this.getElement().classList.remove(new String[]{"settings-hidden"});
    }

    @Override
    public void showBusyIndicator() {
        this.showBusyIndicator(this.translationService.format("Loading", new Object[0]));
    }

    public void showBusyIndicator(String message) {
        BusyPopup.showMessage((String)message);
    }

    public void hideBusyIndicator() {
        BusyPopup.close();
    }

    @Templated(value="SettingsView.html#section-menu-item")
    public static class MenuItem
    implements SettingsPresenter.MenuItem.View {
        @Inject
        @Named(value="sup")
        private HTMLElement dirtyIndicator;
        @Inject
        @DataField(value="section-menu-item-link")
        private HTMLAnchorElement sectionMenuItemLink;
        private SettingsPresenter.MenuItem presenter;

        public void init(SettingsPresenter.MenuItem presenter) {
            this.presenter = presenter;
        }

        @EventHandler(value={"section-menu-item-link"})
        public void onSectionMenuItemLinkClicked(ClickEvent ignore) {
            this.presenter.showSection();
        }

        @Override
        public void setLabel(String label) {
            this.sectionMenuItemLink.textContent = label;
        }

        @Override
        public void markAsDirty(boolean dirty) {
            if (dirty && this.sectionMenuItemLink.childElementCount == 0.0) {
                this.sectionMenuItemLink.appendChild((Node)this.newDirtyIndicator());
            } else if (!dirty && this.sectionMenuItemLink.childElementCount > 0.0) {
                this.sectionMenuItemLink.removeChild((Node)this.sectionMenuItemLink.lastElementChild);
            }
        }

        private HTMLElement newDirtyIndicator() {
            HTMLElement dirtyIndicator = (HTMLElement)this.dirtyIndicator.cloneNode(false);
            dirtyIndicator.textContent = " *";
            return dirtyIndicator;
        }
    }
}

