/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.library.client.settings.dependencies;

import com.google.gwt.event.dom.client.ClickEvent;
import elemental2.dom.HTMLAnchorElement;
import elemental2.dom.HTMLDivElement;
import elemental2.dom.HTMLElement;
import elemental2.dom.HTMLInputElement;
import elemental2.dom.Node;
import javax.inject.Inject;
import javax.inject.Named;
import org.jboss.errai.common.client.dom.elemental2.Elemental2DomUtil;
import org.jboss.errai.ui.client.local.api.elemental2.IsElement;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.EventHandler;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.kie.workbench.common.screens.library.client.settings.dependencies.DependenciesItemPresenter;
import org.uberfire.commons.uuid.UUID;

@Templated(value="#root")
public class DependenciesItemView
implements DependenciesItemPresenter.View,
IsElement {
    private DependenciesItemPresenter presenter;
    @Inject
    private Elemental2DomUtil elemental2DomUtil;
    @Inject
    private TranslationService translationService;
    @Inject
    @DataField(value="white-listed-packages-indicator")
    private HTMLDivElement whiteListedPackagesIndicator;
    @Inject
    @DataField(value="package-white-list-all")
    private HTMLInputElement packageWhiteListAll;
    @Inject
    @DataField(value="package-white-list-none")
    private HTMLInputElement packageWhiteListNone;
    @Inject
    @Named(value="span")
    @DataField(value="group-id")
    private HTMLElement groupId;
    @Inject
    @Named(value="span")
    @DataField(value="artifact-id")
    private HTMLElement artifactId;
    @Inject
    @Named(value="span")
    @DataField(value="version")
    private HTMLElement version;
    @Inject
    @DataField(value="remove-button")
    private HTMLAnchorElement removeButton;
    private final String packageWhiteListRadioGroupName = UUID.uuid();
    private DependenciesItemPresenter.WhiteListedPackagesState whiteListedPackagesState;

    public void init(DependenciesItemPresenter presenter) {
        this.presenter = presenter;
        this.packageWhiteListAll.name = this.packageWhiteListRadioGroupName;
        this.packageWhiteListNone.name = this.packageWhiteListRadioGroupName;
    }

    @Override
    public void setGroupId(String groupId) {
        this.groupId.textContent = groupId;
    }

    @Override
    public void setArtifactId(String artifactId) {
        this.artifactId.textContent = artifactId;
    }

    @Override
    public void setVersion(String version) {
        this.version.textContent = version;
    }

    @Override
    public void setPackagesWhiteListedState(DependenciesItemPresenter.WhiteListedPackagesState state) {
        this.whiteListedPackagesState = state;
        this.packageWhiteListAll.checked = false;
        this.packageWhiteListNone.checked = false;
        switch (state) {
            case ALL: {
                this.packageWhiteListAll.checked = true;
                break;
            }
            case NONE: {
                this.packageWhiteListNone.checked = true;
            }
        }
    }

    @Override
    public void setTransitiveDependency(boolean disabled) {
        if (disabled) {
            this.removeButton.remove();
            this.elemental2DomUtil.removeAllElementChildren((Node)this.whiteListedPackagesIndicator);
            this.whiteListedPackagesIndicator.textContent = this.translationService.format(this.whiteListedPackagesState.name(), new Object[0]);
            this.getElement().classList.add(new String[]{"transitive"});
        }
    }

    @EventHandler(value={"package-white-list-all"})
    public void addAllPackagesToWhiteList(ClickEvent event) {
        this.presenter.addAllPackagesToWhiteList();
    }

    @EventHandler(value={"package-white-list-none"})
    public void removeAllPackagesFromWhiteList(ClickEvent event) {
        this.presenter.removeAllPackagesFromWhiteList();
    }

    @EventHandler(value={"remove-button"})
    public void delete(ClickEvent event) {
        this.presenter.remove();
    }
}

