/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.library.client.settings.generalsettings;

import elemental2.promise.IThenable;
import elemental2.promise.Promise;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.guvnor.common.services.project.client.preferences.ProjectScopedResolutionStrategySupplier;
import org.guvnor.common.services.project.model.POM;
import org.guvnor.common.services.project.preferences.GAVPreferences;
import org.jboss.errai.common.client.api.Caller;
import org.kie.workbench.common.screens.library.client.settings.SettingsPresenter;
import org.kie.workbench.common.screens.library.client.settings.SettingsSectionChange;
import org.kie.workbench.common.screens.projecteditor.model.ProjectScreenModel;
import org.kie.workbench.common.services.shared.validation.ValidationService;
import org.uberfire.client.promise.Promises;

public class GeneralSettingsPresenter
extends SettingsPresenter.Section {
    private final View view;
    private final Caller<ValidationService> validationService;
    private final GAVPreferences gavPreferences;
    private final ProjectScopedResolutionStrategySupplier projectScopedResolutionStrategySupplier;
    POM pom;

    @Inject
    public GeneralSettingsPresenter(View view, Promises promises, SettingsPresenter.MenuItem menuItem, Caller<ValidationService> validationService, Event<SettingsSectionChange> settingsSectionChangeEvent, GAVPreferences gavPreferences, ProjectScopedResolutionStrategySupplier projectScopedResolutionStrategySupplier) {
        super(settingsSectionChangeEvent, menuItem, promises);
        this.view = view;
        this.validationService = validationService;
        this.gavPreferences = gavPreferences;
        this.projectScopedResolutionStrategySupplier = projectScopedResolutionStrategySupplier;
    }

    @Override
    public Promise<Void> setup(ProjectScreenModel model) {
        this.pom = model.getPOM();
        this.view.init(this);
        this.view.setName(this.pom.getName());
        this.view.setDescription(this.pom.getDescription());
        this.view.setGroupId(this.pom.getGav().getGroupId());
        this.view.setArtifactId(this.pom.getGav().getArtifactId());
        this.view.setVersion(this.pom.getGav().getVersion());
        this.view.setURL(model.getGitUrl());
        return this.promises.create((resolve, reject) -> this.gavPreferences.load(this.projectScopedResolutionStrategySupplier.get(), gavPreferences -> {
            this.view.setConflictingGAVCheckDisabled(gavPreferences.isConflictingGAVCheckDisabled());
            this.view.setChildGavEditEnabled(gavPreferences.isChildGAVEditEnabled());
            resolve.onInvoke((IThenable)this.promises.resolve());
        }, arg_0 -> ((Promise.PromiseExecutorCallbackFn.RejectCallbackFn)reject).onInvoke(arg_0)));
    }

    @Override
    public Promise<Object> validate() {
        this.view.hideError();
        return this.promises.all(new Promise[]{this.validateStringIsNotEmpty(this.pom.getName(), this.view.getEmptyNameMessage()).then(o -> this.executeValidation(s -> s.isProjectNameValid(this.pom.getName()), this.view.getInvalidNameMessage())).catch_(this::showErrorAndReject), this.validateStringIsNotEmpty(this.pom.getGav().getGroupId(), this.view.getEmptyGroupIdMessage()).then(o -> this.executeValidation(s -> s.validateGroupId(this.pom.getGav().getGroupId()), this.view.getInvalidGroupIdMessage())).catch_(this::showErrorAndReject), this.validateStringIsNotEmpty(this.pom.getGav().getArtifactId(), this.view.getEmptyArtifactIdMessage()).then(o -> this.executeValidation(s -> s.validateArtifactId(this.pom.getGav().getArtifactId()), this.view.getInvalidArtifactIdMessage())).catch_(this::showErrorAndReject), this.validateStringIsNotEmpty(this.pom.getGav().getVersion(), this.view.getEmptyVersionMessage()).then(o -> this.executeValidation(s -> s.validateGAVVersion(this.pom.getGav().getVersion()), this.view.getInvalidVersionMessage())).catch_(this::showErrorAndReject)});
    }

    Promise<Object> showErrorAndReject(Object o) {
        return this.promises.catchOrExecute(o, e -> {
            this.view.showError(e.getMessage());
            return this.promises.reject((Object)this);
        }, errorMessage -> {
            this.view.showError((String)errorMessage);
            return this.promises.reject((Object)this);
        });
    }

    Promise<Boolean> validateStringIsNotEmpty(String string, String errorMessage) {
        return this.promises.create((resolve, reject) -> {
            if (string == null || string.isEmpty()) {
                reject.onInvoke((Object)errorMessage);
            } else {
                resolve.onInvoke((Object)true);
            }
        });
    }

    Promise<Boolean> executeValidation(Function<ValidationService, Boolean> call, String errorMessage) {
        return this.promises.promisify(this.validationService, call).then(valid -> valid != false ? this.promises.resolve((Object)true) : this.promises.reject((Object)errorMessage));
    }

    void setVersion(String version) {
        this.pom.getGav().setVersion(version);
        this.fireChangeEvent();
    }

    void setArtifactId(String artifactId) {
        this.pom.getGav().setArtifactId(artifactId);
        this.fireChangeEvent();
    }

    void setGroupId(String groupId) {
        this.pom.getGav().setGroupId(groupId);
        this.fireChangeEvent();
    }

    void setDescription(String description) {
        this.pom.setDescription(description);
        this.fireChangeEvent();
    }

    void setName(String name) {
        this.pom.setName(name);
        this.fireChangeEvent();
    }

    void disableGavConflictCheck(boolean value) {
        this.gavPreferences.setConflictingGAVCheckDisabled(value);
        this.fireChangeEvent();
    }

    void allowChildGavEdition(boolean value) {
        this.gavPreferences.setChildGAVEditEnabled(value);
        this.fireChangeEvent();
    }

    @Override
    public Promise<Void> save(String comment, Supplier<Promise<Void>> chain) {
        return this.promises.create((resolve, reject) -> this.gavPreferences.save(this.projectScopedResolutionStrategySupplier.get(), () -> resolve.onInvoke((IThenable)this.promises.resolve()), throwable -> reject.onInvoke((Object)this)));
    }

    @Override
    public int currentHashCode() {
        return this.pom.hashCode() + (this.gavPreferences.isChildGAVEditEnabled() ? 1 : 2) + (this.gavPreferences.isConflictingGAVCheckDisabled() ? 4 : 8);
    }

    @Override
    public SettingsPresenter.View.Section getView() {
        return this.view;
    }

    public static interface View
    extends SettingsPresenter.View.Section<GeneralSettingsPresenter> {
        public String getName();

        public String getDescription();

        public String getGroupId();

        public String getArtifactId();

        public String getVersion();

        public Boolean getConflictingGAVCheckDisabled();

        public Boolean getChildGavEditEnabled();

        public void setName(String var1);

        public void setDescription(String var1);

        public void setURL(String var1);

        public void setGroupId(String var1);

        public void setArtifactId(String var1);

        public void setVersion(String var1);

        public void showError(String var1);

        public void setConflictingGAVCheckDisabled(boolean var1);

        public void setChildGavEditEnabled(boolean var1);

        public void hideError();

        public String getEmptyNameMessage();

        public String getInvalidNameMessage();

        public String getEmptyGroupIdMessage();

        public String getInvalidGroupIdMessage();

        public String getEmptyArtifactIdMessage();

        public String getInvalidArtifactIdMessage();

        public String getEmptyVersionMessage();

        public String getInvalidVersionMessage();
    }
}

