/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.library.client.settings.generalsettings;

import com.google.gwt.event.dom.client.ChangeEvent;
import elemental2.dom.HTMLDivElement;
import elemental2.dom.HTMLElement;
import elemental2.dom.HTMLHeadingElement;
import elemental2.dom.HTMLInputElement;
import elemental2.dom.HTMLTextAreaElement;
import elemental2.dom.Node;
import javax.inject.Inject;
import javax.inject.Named;
import org.jboss.errai.common.client.dom.elemental2.Elemental2DomUtil;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.EventHandler;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.kie.workbench.common.screens.library.client.settings.generalsettings.GeneralSettingsPresenter;

@Templated
public class GeneralSettingsView
implements GeneralSettingsPresenter.View {
    private GeneralSettingsPresenter presenter;
    @Inject
    private TranslationService translationService;
    @Inject
    private Elemental2DomUtil elemental2DomUtil;
    @Inject
    @DataField(value="error")
    private HTMLDivElement error;
    @Inject
    @DataField(value="name")
    private HTMLInputElement name;
    @Inject
    @Named(value="span")
    @DataField(value="error-message")
    private HTMLElement errorMessage;
    @Inject
    @DataField(value="description")
    private HTMLTextAreaElement description;
    @Inject
    @DataField(value="url")
    private HTMLInputElement url;
    @Inject
    @DataField(value="disable-gav-conflict-check")
    private HTMLInputElement disableGAVConflictCheck;
    @Inject
    @Named(value="span")
    @DataField(value="tooltip-disable-gav-conflict-check")
    private HTMLElement tooltipDisableGAVConflictCheck;
    @Inject
    @DataField(value="allow-child-gav-edition")
    private HTMLInputElement allowChildGAVEdition;
    @Inject
    @DataField(value="group-id")
    private HTMLInputElement groupId;
    @Inject
    @DataField(value="artifact-id")
    private HTMLInputElement artifactId;
    @Inject
    @DataField(value="version")
    private HTMLInputElement version;
    @Inject
    @Named(value="h3")
    @DataField(value="title")
    private HTMLHeadingElement title;

    public void init(GeneralSettingsPresenter presenter) {
        this.presenter = presenter;
        this.tooltipDisableGAVConflictCheck.title = this.translationService.getTranslation("PreferenceDisableGAVConflictCheck.Tooltip");
        this.hideError();
    }

    @EventHandler(value={"disable-gav-conflict-check"})
    public void onDisableGavConflictCheckChanged(ChangeEvent ignore) {
        this.presenter.disableGavConflictCheck(this.disableGAVConflictCheck.checked);
    }

    @EventHandler(value={"allow-child-gav-edition"})
    public void onAllowChildGavEditionChanged(ChangeEvent ignore) {
        this.presenter.allowChildGavEdition(this.allowChildGAVEdition.checked);
    }

    @EventHandler(value={"name"})
    public void onNameChanged(ChangeEvent ignore) {
        this.presenter.setName(this.name.value);
    }

    @EventHandler(value={"description"})
    public void onDescriptionChanged(ChangeEvent ignore) {
        this.presenter.setDescription(this.description.value);
    }

    @EventHandler(value={"group-id"})
    public void onGroupIdChanged(ChangeEvent ignore) {
        this.presenter.setGroupId(this.groupId.value);
    }

    @EventHandler(value={"artifact-id"})
    public void onArtifactIdChanged(ChangeEvent ignore) {
        this.presenter.setArtifactId(this.artifactId.value);
    }

    @EventHandler(value={"version"})
    public void onVersionChanged(ChangeEvent ignore) {
        this.presenter.setVersion(this.version.value);
    }

    @Override
    public String getName() {
        return this.name.value;
    }

    @Override
    public String getDescription() {
        return this.description.value;
    }

    @Override
    public String getGroupId() {
        return this.groupId.value;
    }

    @Override
    public String getArtifactId() {
        return this.artifactId.value;
    }

    @Override
    public String getVersion() {
        return this.version.value;
    }

    @Override
    public Boolean getConflictingGAVCheckDisabled() {
        return this.disableGAVConflictCheck.checked;
    }

    @Override
    public Boolean getChildGavEditEnabled() {
        return this.allowChildGAVEdition.checked;
    }

    @Override
    public void setName(String name) {
        this.name.value = name;
    }

    @Override
    public void setDescription(String description) {
        this.description.value = description;
    }

    @Override
    public void setURL(String url) {
        this.url.value = url;
    }

    @Override
    public void setGroupId(String groupId) {
        this.groupId.value = groupId;
    }

    @Override
    public void setArtifactId(String artifactId) {
        this.artifactId.value = artifactId;
    }

    @Override
    public void setVersion(String version) {
        this.version.value = version;
    }

    @Override
    public void setConflictingGAVCheckDisabled(boolean value) {
        this.disableGAVConflictCheck.checked = value;
    }

    @Override
    public void setChildGavEditEnabled(boolean value) {
        this.allowChildGAVEdition.checked = value;
    }

    @Override
    public void showError(String errorMessage) {
        this.errorMessage.innerHTML = this.errorMessage.innerHTML + errorMessage;
        this.errorMessage.innerHTML = this.errorMessage.innerHTML + "<br/>";
        this.error.hidden = false;
    }

    @Override
    public void hideError() {
        this.elemental2DomUtil.removeAllElementChildren((Node)this.errorMessage);
        this.error.hidden = true;
    }

    @Override
    public String getEmptyNameMessage() {
        return this.translationService.format("EmptyFieldValidation", new Object[]{this.translationService.getTranslation("Name")});
    }

    @Override
    public String getInvalidNameMessage() {
        return this.translationService.format("InvalidFieldValidation", new Object[]{this.translationService.getTranslation("Name")});
    }

    @Override
    public String getEmptyGroupIdMessage() {
        return this.translationService.format("EmptyFieldValidation", new Object[]{this.translationService.getTranslation("GroupId")});
    }

    @Override
    public String getInvalidGroupIdMessage() {
        return this.translationService.format("InvalidFieldValidation", new Object[]{this.translationService.getTranslation("GroupId")});
    }

    @Override
    public String getEmptyArtifactIdMessage() {
        return this.translationService.format("EmptyFieldValidation", new Object[]{this.translationService.getTranslation("ArtifactId")});
    }

    @Override
    public String getInvalidArtifactIdMessage() {
        return this.translationService.format("InvalidFieldValidation", new Object[]{this.translationService.getTranslation("ArtifactId")});
    }

    @Override
    public String getEmptyVersionMessage() {
        return this.translationService.format("EmptyFieldValidation", new Object[]{this.translationService.getTranslation("Version")});
    }

    @Override
    public String getInvalidVersionMessage() {
        return this.translationService.format("InvalidFieldValidation", new Object[]{this.translationService.getTranslation("Version")});
    }

    @Override
    public String getTitle() {
        return this.title.textContent;
    }
}

