/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.library.client.settings.knowledgebases;

import elemental2.dom.Element;
import elemental2.promise.Promise;
import java.util.Comparator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.kie.workbench.common.screens.library.client.settings.SettingsPresenter;
import org.kie.workbench.common.screens.library.client.settings.SettingsSectionChange;
import org.kie.workbench.common.screens.library.client.settings.knowledgebases.item.KnowledgeBaseItemPresenter;
import org.kie.workbench.common.screens.library.client.settings.util.ListPresenter;
import org.kie.workbench.common.screens.library.client.settings.util.modal.single.AddSingleValueModal;
import org.kie.workbench.common.screens.projecteditor.model.ProjectScreenModel;
import org.kie.workbench.common.services.shared.kmodule.KBaseModel;
import org.kie.workbench.common.services.shared.kmodule.KModuleModel;
import org.uberfire.client.promise.Promises;

public class KnowledgeBasesPresenter
extends SettingsPresenter.Section {
    private final AddSingleValueModal addKnowledgeBaseModal;
    private final KnowledgeBaseListPresenter knowledgeBaseListPresenter;
    private final View view;
    KModuleModel kModuleModel;

    @Inject
    public KnowledgeBasesPresenter(View view, Event<SettingsSectionChange> settingsSectionChangeEvent, Promises promises, SettingsPresenter.MenuItem menuItem, AddSingleValueModal addKnowledgeBaseModal, KnowledgeBaseListPresenter knowledgeBaseListPresenter) {
        super(settingsSectionChangeEvent, menuItem, promises);
        this.addKnowledgeBaseModal = addKnowledgeBaseModal;
        this.knowledgeBaseListPresenter = knowledgeBaseListPresenter;
        this.view = view;
    }

    @Override
    public Promise<Void> setup(ProjectScreenModel model) {
        this.kModuleModel = model.getKModule();
        this.view.init(this);
        this.addKnowledgeBaseModal.setup("AddKnowledgeBase", "Name");
        this.knowledgeBaseListPresenter.setup(this.view.getKnowledgeBasesTable(), model.getKModule().getKBases().values().stream().sorted(Comparator.comparing(KBaseModel::getName)).collect(Collectors.toList()), (kbase, presenter) -> presenter.setup((KBaseModel)kbase, this));
        return this.promises.resolve();
    }

    @Override
    public Promise<Void> save(String comment, Supplier<Promise<Void>> chain) {
        this.kModuleModel.getKBases().clear();
        this.kModuleModel.getKBases().putAll(this.knowledgeBaseListPresenter.getObjectsList().stream().collect(Collectors.toMap(KBaseModel::getName, Function.identity())));
        return this.promises.resolve();
    }

    void openAddKnowledgeBaseModal() {
        this.addKnowledgeBaseModal.show(knowledgeBaseName -> {
            this.knowledgeBaseListPresenter.add(this.newKBaseModel((String)knowledgeBaseName));
            this.fireChangeEvent();
        });
    }

    KBaseModel newKBaseModel(String knowledgeBaseName) {
        KBaseModel kBaseModel = new KBaseModel();
        kBaseModel.setName(knowledgeBaseName);
        kBaseModel.setDefault(this.knowledgeBaseListPresenter.getObjectsList().isEmpty());
        return kBaseModel;
    }

    @Override
    public SettingsPresenter.View.Section getView() {
        return this.view;
    }

    @Override
    public int currentHashCode() {
        return this.knowledgeBaseListPresenter.hashCode();
    }

    @Dependent
    public static class KnowledgeBaseListPresenter
    extends ListPresenter<KBaseModel, KnowledgeBaseItemPresenter> {
        @Inject
        public KnowledgeBaseListPresenter(ManagedInstance<KnowledgeBaseItemPresenter> itemPresenters) {
            super(itemPresenters);
        }
    }

    public static interface View
    extends SettingsPresenter.View.Section<KnowledgeBasesPresenter> {
        public Element getKnowledgeBasesTable();
    }
}

