/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.library.client.settings.persistence;

import elemental2.dom.Element;
import elemental2.promise.Promise;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.guvnor.common.services.project.client.context.WorkspaceProjectContext;
import org.guvnor.common.services.project.model.Module;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.kie.workbench.common.screens.datamodeller.model.persistence.PersistenceDescriptorEditorContent;
import org.kie.workbench.common.screens.datamodeller.model.persistence.PersistenceUnitModel;
import org.kie.workbench.common.screens.datamodeller.model.persistence.Property;
import org.kie.workbench.common.screens.datamodeller.service.DataModelerService;
import org.kie.workbench.common.screens.datamodeller.service.PersistenceDescriptorEditorService;
import org.kie.workbench.common.screens.library.client.settings.SettingsPresenter;
import org.kie.workbench.common.screens.library.client.settings.SettingsSectionChange;
import org.kie.workbench.common.screens.library.client.settings.persistence.persistabledataobjects.PersistableDataObjectsItemPresenter;
import org.kie.workbench.common.screens.library.client.settings.persistence.properties.PropertiesItemPresenter;
import org.kie.workbench.common.screens.library.client.settings.util.ListPresenter;
import org.kie.workbench.common.screens.library.client.settings.util.modal.doublevalue.AddDoubleValueModal;
import org.kie.workbench.common.screens.library.client.settings.util.modal.single.AddSingleValueModal;
import org.kie.workbench.common.screens.projecteditor.model.ProjectScreenModel;
import org.uberfire.backend.vfs.ObservablePath;
import org.uberfire.backend.vfs.Path;
import org.uberfire.backend.vfs.PathFactory;
import org.uberfire.client.promise.Promises;
import org.uberfire.workbench.events.NotificationEvent;

public class PersistencePresenter
extends SettingsPresenter.Section {
    private final View view;
    private final WorkspaceProjectContext projectContext;
    private final Event<NotificationEvent> notificationEvent;
    private final ManagedInstance<ObservablePath> observablePaths;
    private final AddDoubleValueModal newPropertyModal;
    private final AddSingleValueModal newPersistableDataObjectModal;
    private final Caller<PersistenceDescriptorEditorService> editorService;
    private final Caller<DataModelerService> dataModelerService;
    private final PropertiesListPresenter propertiesListPresenter;
    private final PersistableDataObjectsListPresenter persistableDataObjectsListPresenter;
    private ObservablePath pathToPersistenceXml;
    PersistenceDescriptorEditorContent persistenceDescriptorEditorContent;
    ObservablePath.OnConcurrentUpdateEvent concurrentPersistenceXmlUpdateInfo;

    @Inject
    public PersistencePresenter(View view, WorkspaceProjectContext projectContext, Promises promises, SettingsPresenter.MenuItem menuItem, Event<NotificationEvent> notificationEvent, Event<SettingsSectionChange> settingsSectionChangeEvent, ManagedInstance<ObservablePath> observablePaths, AddDoubleValueModal newPropertyModal, AddSingleValueModal newPersistableDataObjectModal, Caller<PersistenceDescriptorEditorService> editorService, Caller<DataModelerService> dataModelerService, PropertiesListPresenter propertiesListPresenter, PersistableDataObjectsListPresenter persistableDataObjectsListPresenter) {
        super(settingsSectionChangeEvent, menuItem, promises);
        this.view = view;
        this.projectContext = projectContext;
        this.notificationEvent = notificationEvent;
        this.observablePaths = observablePaths;
        this.newPropertyModal = newPropertyModal;
        this.newPersistableDataObjectModal = newPersistableDataObjectModal;
        this.editorService = editorService;
        this.dataModelerService = dataModelerService;
        this.propertiesListPresenter = propertiesListPresenter;
        this.persistableDataObjectsListPresenter = persistableDataObjectsListPresenter;
    }

    @Override
    public Promise<Void> setup(ProjectScreenModel model) {
        return this.setup();
    }

    Promise<Void> setup() {
        this.view.init(this);
        String persistenceXmlUri = ((Module)this.projectContext.getActiveModule().orElseThrow(() -> new IllegalStateException("Cannot get root path because there is no active module"))).getRootPath().toURI() + "src/main/resources/META-INF/persistence.xml";
        this.pathToPersistenceXml = ((ObservablePath)this.observablePaths.get()).wrap(PathFactory.newPath((String)"persistence.xml", (String)persistenceXmlUri, (Map)new HashMap<String, Object>(){
            {
                this.put(PathFactory.VERSION_PROPERTY, true);
            }
        }));
        this.concurrentPersistenceXmlUpdateInfo = null;
        this.pathToPersistenceXml.onConcurrentUpdate(info -> {
            this.concurrentPersistenceXmlUpdateInfo = info;
        });
        return this.promises.promisify(this.editorService, s -> s.loadContent((Path)this.pathToPersistenceXml, true)).then(m -> {
            this.persistenceDescriptorEditorContent = m;
            this.view.setPersistenceUnit(this.getPersistenceUnitModel().getName());
            this.view.setPersistenceProvider(this.getPersistenceUnitModel().getProvider());
            this.view.setDataSource(this.getPersistenceUnitModel().getJtaDataSource());
            this.setupPropertiesTable();
            this.setupPersistableDataObjectsTable();
            return this.promises.resolve();
        });
    }

    private void setupPropertiesTable() {
        this.newPropertyModal.setup("AddProperty", "Name", "Value");
        this.propertiesListPresenter.setup(this.view.getPropertiesTable(), this.getPersistenceUnitModel().getProperties(), (property, presenter) -> presenter.setup((Property)property, this));
    }

    private void setupPersistableDataObjectsTable() {
        this.newPersistableDataObjectModal.setup("AddPersistableDataObject", "Class");
        this.persistableDataObjectsListPresenter.setup(this.view.getPersistableDataObjectsTable(), this.getPersistenceUnitModel().getClasses(), (className, presenter) -> presenter.setup((String)className, this));
    }

    @Override
    public Promise<Void> save(String comment, Supplier<Promise<Void>> chain) {
        if (this.concurrentPersistenceXmlUpdateInfo == null) {
            return this.save(comment);
        }
        this.notificationEvent.fire((Object)new NotificationEvent(this.view.getConcurrentUpdateMessage(), NotificationEvent.NotificationType.WARNING));
        return this.setup();
    }

    Promise<Void> save(String comment) {
        return this.promises.promisify(this.editorService, s -> s.save((Path)this.pathToPersistenceXml, (Object)this.persistenceDescriptorEditorContent, (Object)this.persistenceDescriptorEditorContent.getOverview().getMetadata(), comment));
    }

    public void add(String className) {
        this.persistableDataObjectsListPresenter.add(className);
        this.fireChangeEvent();
    }

    public void add(Property property) {
        this.propertiesListPresenter.add(property);
        this.fireChangeEvent();
    }

    public void addAllProjectsPersistableDataObjects() {
        this.promises.promisify(this.dataModelerService, s -> s.findPersistableClasses((Path)this.pathToPersistenceXml)).then(classes -> {
            classes.stream().filter(clazz -> !this.getPersistenceUnitModel().getClasses().contains(clazz)).forEach(this::add);
            return this.promises.resolve();
        });
    }

    public void setDataSource(String dataSource) {
        this.getPersistenceUnitModel().setJtaDataSource(dataSource);
        this.fireChangeEvent();
    }

    public void setPersistenceUnit(String persistenceUnit) {
        this.getPersistenceUnitModel().setName(persistenceUnit);
        this.fireChangeEvent();
    }

    public void setPersistenceProvider(String persistenceProvider) {
        this.getPersistenceUnitModel().setProvider(persistenceProvider);
        this.fireChangeEvent();
    }

    private PersistenceUnitModel getPersistenceUnitModel() {
        return this.persistenceDescriptorEditorContent.getDescriptorModel().getPersistenceUnit();
    }

    public void showNewPropertyModal() {
        this.newPropertyModal.show((name, value) -> {
            this.add(new Property(name, value));
            this.fireChangeEvent();
        });
    }

    public void showNewPersistableDataObjectModal() {
        this.newPersistableDataObjectModal.show(className -> {
            this.add((String)className);
            this.fireChangeEvent();
        });
    }

    @Override
    public int currentHashCode() {
        return this.getPersistenceUnitModel().hashCode();
    }

    @Override
    public SettingsPresenter.View.Section getView() {
        return this.view;
    }

    @Dependent
    public static class PropertiesListPresenter
    extends ListPresenter<Property, PropertiesItemPresenter> {
        @Inject
        public PropertiesListPresenter(ManagedInstance<PropertiesItemPresenter> itemPresenters) {
            super(itemPresenters);
        }
    }

    @Dependent
    public static class PersistableDataObjectsListPresenter
    extends ListPresenter<String, PersistableDataObjectsItemPresenter> {
        @Inject
        public PersistableDataObjectsListPresenter(ManagedInstance<PersistableDataObjectsItemPresenter> itemPresenters) {
            super(itemPresenters);
        }
    }

    public static interface View
    extends SettingsPresenter.View.Section<PersistencePresenter> {
        public void setPersistenceUnit(String var1);

        public void setPersistenceProvider(String var1);

        public void setDataSource(String var1);

        public String getConcurrentUpdateMessage();

        public Element getPropertiesTable();

        public Element getPersistableDataObjectsTable();
    }
}

