/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.library.client.settings.persistence;

import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ClickEvent;
import elemental2.dom.Element;
import elemental2.dom.HTMLButtonElement;
import elemental2.dom.HTMLHeadingElement;
import elemental2.dom.HTMLInputElement;
import elemental2.dom.HTMLTableSectionElement;
import javax.inject.Inject;
import javax.inject.Named;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.EventHandler;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.kie.workbench.common.screens.library.client.settings.persistence.PersistencePresenter;

@Templated
public class PersistenceView
implements PersistencePresenter.View {
    @Inject
    @DataField(value="persistence-unit")
    private HTMLInputElement persistenceUnit;
    @Inject
    @DataField(value="persistence-provider")
    private HTMLInputElement persistenceProvider;
    @Inject
    @DataField(value="data-source")
    private HTMLInputElement dataSource;
    @Inject
    @DataField(value="add-property-button")
    private HTMLButtonElement addPropertyButton;
    @Inject
    @DataField(value="add-persistable-data-object-button")
    private HTMLButtonElement addPersistableDataObjectButton;
    @Inject
    @DataField(value="add-all-projects-persistable-data-objects-button")
    private HTMLButtonElement addAllProjectsPersistableDataObjectsButton;
    @Inject
    @Named(value="tbody")
    @DataField(value="properties-table")
    private HTMLTableSectionElement propertiesTable;
    @Inject
    @Named(value="tbody")
    @DataField(value="persistable-data-objects-table")
    private HTMLTableSectionElement persistableDataObjectsTable;
    @Inject
    @Named(value="h3")
    @DataField(value="title")
    private HTMLHeadingElement title;
    @Inject
    private TranslationService translationService;
    private PersistencePresenter presenter;

    public void init(PersistencePresenter presenter) {
        this.presenter = presenter;
    }

    @EventHandler(value={"data-source"})
    public void onDataSourceChanged(ChangeEvent ignore) {
        this.presenter.setDataSource(this.dataSource.value);
    }

    @EventHandler(value={"persistence-unit"})
    public void onPersistenceUnitChanged(ChangeEvent ignore) {
        this.presenter.setPersistenceUnit(this.persistenceUnit.value);
    }

    @EventHandler(value={"persistence-provider"})
    public void onPersistenceProviderChanged(ChangeEvent ignore) {
        this.presenter.setPersistenceProvider(this.persistenceProvider.value);
    }

    @EventHandler(value={"add-property-button"})
    public void onAddPropertyButtonClicked(ClickEvent ignore) {
        this.presenter.showNewPropertyModal();
    }

    @EventHandler(value={"add-persistable-data-object-button"})
    public void onAddPersistableDataObjectButtonClicked(ClickEvent ignore) {
        this.presenter.showNewPersistableDataObjectModal();
    }

    @EventHandler(value={"add-all-projects-persistable-data-objects-button"})
    public void onAddAllProjectsPersistableDataObjectsButtonClicked(ClickEvent ignore) {
        this.presenter.addAllProjectsPersistableDataObjects();
    }

    @Override
    public void setPersistenceUnit(String persistenceUnit) {
        this.persistenceUnit.value = persistenceUnit;
    }

    @Override
    public void setPersistenceProvider(String persistenceProvider) {
        this.persistenceProvider.value = persistenceProvider;
    }

    @Override
    public void setDataSource(String dataSource) {
        this.dataSource.value = dataSource;
    }

    @Override
    public String getConcurrentUpdateMessage() {
        return this.translationService.format("PersistenceXmlConcurrentUpdate", new Object[0]);
    }

    @Override
    public Element getPropertiesTable() {
        return this.propertiesTable;
    }

    @Override
    public Element getPersistableDataObjectsTable() {
        return this.persistableDataObjectsTable;
    }

    @Override
    public String getTitle() {
        return this.title.textContent;
    }
}

