/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.library.client.settings.util;

import elemental2.dom.Element;
import elemental2.dom.Node;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.jboss.errai.common.client.dom.elemental2.Elemental2DomUtil;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.kie.workbench.common.screens.library.client.settings.util.ListItemPresenter;

public abstract class ListPresenter<T, P extends ListItemPresenter<T, ?, ?>> {
    private static final Elemental2DomUtil elemental2DomUtil = new Elemental2DomUtil();
    private final ManagedInstance<P> itemPresenters;
    private List<T> objects;
    private List<P> presenters;
    private Element listElement;
    private BiConsumer<T, P> itemPresenterConfigurator;

    public ListPresenter(ManagedInstance<P> itemPresenters) {
        this.itemPresenters = itemPresenters;
    }

    public void setup(Element listElement, List<T> objects, BiConsumer<T, P> itemPresenterConfigurator) {
        this.objects = objects;
        this.presenters = new ArrayList<P>();
        this.listElement = listElement;
        this.itemPresenterConfigurator = itemPresenterConfigurator;
        elemental2DomUtil.removeAllElementChildren((Node)this.listElement);
        this.objects.forEach(this::addToListElement);
    }

    public void setupWithPresenters(Element listElement, List<P> presenters, BiConsumer<T, P> itemPresenterConfigurator) {
        this.objects = presenters.stream().map(p -> p.getObject()).collect(Collectors.toList());
        this.presenters = presenters;
        this.listElement = listElement;
        this.itemPresenterConfigurator = itemPresenterConfigurator;
        elemental2DomUtil.removeAllElementChildren((Node)this.listElement);
        presenters.forEach(this::addPresenter);
    }

    public void add(T o) {
        this.addToListElement(o);
        this.objects.add(o);
    }

    protected void addToListElement(T o) {
        this.addPresenter(this.newPresenterFor(o));
    }

    protected void addPresenter(P presenter) {
        this.presenters.add(presenter);
        this.listElement.appendChild((Node)((ListItemPresenter)presenter).getView().getElement());
    }

    protected P newPresenterFor(T o) {
        ListItemPresenter listItemPresenter = (ListItemPresenter)this.itemPresenters.get();
        listItemPresenter.setListPresenter(this);
        this.itemPresenterConfigurator.accept(o, listItemPresenter);
        return (P)listItemPresenter;
    }

    public void remove(ListItemPresenter<T, ?, ?> listItemPresenter) {
        this.objects.remove(listItemPresenter.getObject());
        this.listElement.removeChild((Node)listItemPresenter.getView().getElement());
    }

    public List<T> getObjectsList() {
        return this.objects;
    }

    public List<P> getPresenters() {
        return this.presenters;
    }

    public int hashCode() {
        return this.objects.hashCode();
    }
}

