/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.library.client.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.ext.uberfire.social.activities.model.ExtendedTypes;
import org.ext.uberfire.social.activities.model.SocialFileSelectedEvent;
import org.guvnor.common.services.project.client.context.WorkspaceProjectContext;
import org.guvnor.common.services.project.client.preferences.ProjectScopedResolutionStrategySupplier;
import org.guvnor.common.services.project.context.WorkspaceProjectContextChangeEvent;
import org.guvnor.common.services.project.context.WorkspaceProjectContextChangeHandler;
import org.guvnor.common.services.project.events.RenameModuleEvent;
import org.guvnor.common.services.project.model.Module;
import org.guvnor.common.services.project.model.Package;
import org.guvnor.common.services.project.model.WorkspaceProject;
import org.guvnor.common.services.project.service.WorkspaceProjectService;
import org.guvnor.common.services.project.social.ModuleEventType;
import org.guvnor.structure.organizationalunit.OrganizationalUnit;
import org.guvnor.structure.organizationalunit.RemoveOrganizationalUnitEvent;
import org.guvnor.structure.repositories.Repository;
import org.guvnor.structure.repositories.RepositoryRemovedEvent;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.jboss.errai.common.client.dom.Element;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.kie.soup.commons.validation.PortablePreconditions;
import org.kie.workbench.common.screens.library.api.LibraryService;
import org.kie.workbench.common.screens.library.api.ProjectAssetListUpdated;
import org.kie.workbench.common.screens.library.api.Remote;
import org.kie.workbench.common.screens.library.api.Routed;
import org.kie.workbench.common.screens.library.client.events.AssetDetailEvent;
import org.kie.workbench.common.screens.library.client.events.WorkbenchProjectMetricsEvent;
import org.kie.workbench.common.screens.library.client.perspective.LibraryPerspective;
import org.kie.workbench.common.screens.library.client.screens.importrepository.ImportRepositoryPopUpPresenter;
import org.kie.workbench.common.screens.library.client.util.ResourceUtils;
import org.kie.workbench.common.screens.library.client.util.TranslationUtils;
import org.kie.workbench.common.screens.library.client.widgets.library.LibraryToolbarPresenter;
import org.kie.workbench.common.services.shared.project.KieModuleService;
import org.kie.workbench.common.widgets.client.handlers.NewResourceSuccessEvent;
import org.kie.workbench.common.workbench.client.docks.AuthoringWorkbenchDocks;
import org.uberfire.backend.vfs.ObservablePath;
import org.uberfire.backend.vfs.Path;
import org.uberfire.backend.vfs.VFSService;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.client.mvp.PlaceStatus;
import org.uberfire.client.workbench.events.PlaceGainFocusEvent;
import org.uberfire.ext.editor.commons.client.event.ConcurrentRenameAcceptedEvent;
import org.uberfire.ext.preferences.client.event.PreferencesCentralInitializationEvent;
import org.uberfire.ext.preferences.client.event.PreferencesCentralSaveEvent;
import org.uberfire.ext.preferences.client.event.PreferencesCentralUndoChangesEvent;
import org.uberfire.ext.widgets.common.client.breadcrumbs.UberfireBreadcrumbs;
import org.uberfire.mvp.Command;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.mvp.impl.DefaultPlaceRequest;
import org.uberfire.mvp.impl.PathPlaceRequest;
import org.uberfire.preferences.shared.impl.PreferenceScopeResolutionStrategyInfo;
import org.uberfire.workbench.events.NotificationEvent;
import org.uberfire.workbench.model.PartDefinition;
import org.uberfire.workbench.model.impl.PartDefinitionImpl;

@ApplicationScoped
public class LibraryPlaces
implements WorkspaceProjectContextChangeHandler {
    public static final String LIBRARY_PERSPECTIVE = "LibraryPerspective";
    public static final String LIBRARY_SCREEN = "LibraryScreen";
    public static final String PROJECT_SCREEN = "ProjectScreen";
    public static final String IMPORT_SAMPLE_PROJECTS_SCREEN = "TrySamplesScreen";
    public static final String PROJECT_DETAIL_SCREEN = "ProjectsDetailScreen";
    public static final String ORG_UNITS_METRICS_SCREEN = "OrgUnitsMetricsScreen";
    public static final String PROJECT_METRICS_SCREEN = "ProjectMetricsScreen";
    public static final String ORGANIZATIONAL_UNITS_SCREEN = "LibraryOrganizationalUnitsScreen";
    public static final String PROJECT_SETTINGS = "ProjectSettings";
    public static final String PROJECT_EXPLORER = "org.kie.guvnor.explorer";
    public static final String ALERTS = "org.kie.workbench.common.screens.messageconsole.MessageConsole";
    public static final String REPOSITORY_STRUCTURE_SCREEN = "repositoryStructureScreen";
    public static final String ADD_ASSET_SCREEN = "AddAssetsScreen";
    public static final List<String> LIBRARY_PLACES = Collections.unmodifiableList(new ArrayList<String>(7){
        {
            this.add(LibraryPlaces.LIBRARY_SCREEN);
            this.add(LibraryPlaces.ORG_UNITS_METRICS_SCREEN);
            this.add(LibraryPlaces.PROJECT_SCREEN);
            this.add(LibraryPlaces.PROJECT_METRICS_SCREEN);
            this.add(LibraryPlaces.PROJECT_DETAIL_SCREEN);
            this.add(LibraryPlaces.ORGANIZATIONAL_UNITS_SCREEN);
            this.add(LibraryPlaces.PROJECT_SETTINGS);
            this.add(LibraryPlaces.ADD_ASSET_SCREEN);
            this.add(LibraryPlaces.IMPORT_SAMPLE_PROJECTS_SCREEN);
            this.add("PreferencesRootScreen");
        }
    });
    private UberfireBreadcrumbs breadcrumbs;
    private TranslationService ts;
    private Event<WorkbenchProjectMetricsEvent> projectMetricsEvent;
    private Event<AssetDetailEvent> assetDetailEvent;
    private ResourceUtils resourceUtils;
    private Caller<LibraryService> libraryService;
    private Caller<WorkspaceProjectService> projectService;
    private Caller<KieModuleService> moduleService;
    private PlaceManager placeManager;
    private LibraryPerspective libraryPerspective;
    private WorkspaceProjectContext projectContext;
    private LibraryToolbarPresenter libraryToolbar;
    private AuthoringWorkbenchDocks docks;
    private Event<WorkspaceProjectContextChangeEvent> projectContextChangeEvent;
    private Event<NotificationEvent> notificationEvent;
    private TranslationUtils translationUtils;
    private Caller<VFSService> vfsService;
    private ProjectScopedResolutionStrategySupplier projectScopedResolutionStrategySupplier;
    private Event<PreferencesCentralInitializationEvent> preferencesCentralInitializationEvent;
    private ManagedInstance<ImportRepositoryPopUpPresenter> importRepositoryPopUpPresenters;
    private Event<ProjectAssetListUpdated> assetListUpdatedEvent;
    private boolean docksReady = false;
    private boolean docksHidden = true;
    private boolean closingLibraryPlaces = false;

    public LibraryPlaces() {
    }

    @Inject
    public LibraryPlaces(UberfireBreadcrumbs breadcrumbs, TranslationService ts, Event<WorkbenchProjectMetricsEvent> projectMetricsEvent, Event<AssetDetailEvent> assetDetailEvent, ResourceUtils resourceUtils, Caller<LibraryService> libraryService, Caller<WorkspaceProjectService> projectService, Caller<KieModuleService> moduleService, PlaceManager placeManager, WorkspaceProjectContext projectContext, LibraryToolbarPresenter libraryToolbar, AuthoringWorkbenchDocks docks, Event<WorkspaceProjectContextChangeEvent> projectContextChangeEvent, Event<NotificationEvent> notificationEvent, TranslationUtils translationUtils, Caller<VFSService> vfsService, ProjectScopedResolutionStrategySupplier projectScopedResolutionStrategySupplier, Event<PreferencesCentralInitializationEvent> preferencesCentralInitializationEvent, ManagedInstance<ImportRepositoryPopUpPresenter> importRepositoryPopUpPresenters, @Routed Event<ProjectAssetListUpdated> assetListUpdatedEvent) {
        this.breadcrumbs = breadcrumbs;
        this.ts = ts;
        this.projectMetricsEvent = projectMetricsEvent;
        this.assetDetailEvent = assetDetailEvent;
        this.resourceUtils = resourceUtils;
        this.libraryService = libraryService;
        this.projectService = projectService;
        this.moduleService = moduleService;
        this.placeManager = placeManager;
        this.projectContext = projectContext;
        this.libraryToolbar = libraryToolbar;
        this.docks = docks;
        this.projectContextChangeEvent = projectContextChangeEvent;
        this.notificationEvent = notificationEvent;
        this.translationUtils = translationUtils;
        this.vfsService = vfsService;
        this.projectScopedResolutionStrategySupplier = projectScopedResolutionStrategySupplier;
        this.preferencesCentralInitializationEvent = preferencesCentralInitializationEvent;
        this.importRepositoryPopUpPresenters = importRepositoryPopUpPresenters;
        this.assetListUpdatedEvent = assetListUpdatedEvent;
    }

    @PostConstruct
    public void setup() {
        this.projectContext.addChangeHandler((WorkspaceProjectContextChangeHandler)this);
        this.breadcrumbs.addToolbar(LIBRARY_PERSPECTIVE, (Element)this.libraryToolbar.getView().getElement());
    }

    public void onSelectPlaceEvent(@Observes PlaceGainFocusEvent placeGainFocusEvent) {
        if (this.isLibraryPerspectiveOpen() && !this.closingLibraryPlaces) {
            PlaceRequest place = placeGainFocusEvent.getPlace();
            if (place instanceof PathPlaceRequest) {
                PathPlaceRequest pathPlaceRequest = (PathPlaceRequest)place;
                this.setupLibraryBreadCrumbsForAsset((Path)pathPlaceRequest.getPath());
                this.showDocks();
            } else if (!place.getIdentifier().equals(ALERTS) && this.isLibraryPlace(place)) {
                this.hideDocks();
                if (place.getIdentifier().equals(PROJECT_SETTINGS)) {
                    this.setupLibraryBreadCrumbsForAsset(null);
                } else if (this.projectContext.getActiveWorkspaceProject().isPresent() && place.getIdentifier().equals(PROJECT_SCREEN)) {
                    this.setupLibraryBreadCrumbs();
                } else if (place.getIdentifier().equals(LIBRARY_SCREEN)) {
                    this.setupLibraryBreadCrumbsWithoutProject();
                }
            }
        }
    }

    public void onAssetListUpdateEvent(@Observes @Remote ProjectAssetListUpdated event) {
        this.assetListUpdatedEvent.fire((Object)event);
    }

    public void hideDocks() {
        if (!this.docksHidden) {
            this.docks.hide();
            this.docksHidden = true;
        }
    }

    public void showDocks() {
        if (this.docksHidden) {
            if (!this.docksReady) {
                this.docks.setup(LIBRARY_PERSPECTIVE, (PlaceRequest)new DefaultPlaceRequest(PROJECT_EXPLORER));
                this.docksReady = true;
            }
            this.docks.show();
            this.docksHidden = false;
        }
    }

    private boolean isLibraryPlace(PlaceRequest place) {
        return LIBRARY_PLACES.contains(place.getIdentifier());
    }

    public void onNewResourceCreated(@Observes NewResourceSuccessEvent newResourceSuccessEvent) {
        if (this.isLibraryPerspectiveOpen()) {
            this.assetDetailEvent.fire((Object)new AssetDetailEvent((WorkspaceProject)this.projectContext.getActiveWorkspaceProject().orElseThrow(() -> new IllegalStateException("Cannot fire asset detail event without an active project.")), newResourceSuccessEvent.getPath()));
            this.placeManager.closePlace(ADD_ASSET_SCREEN);
        }
    }

    public void onAssetRenamedAccepted(@Observes ConcurrentRenameAcceptedEvent concurrentRenameAcceptedEvent) {
        if (this.isLibraryPerspectiveOpen()) {
            ObservablePath path = concurrentRenameAcceptedEvent.getPath();
            this.goToAsset((Path)path);
            this.setupLibraryBreadCrumbsForAsset((Path)path);
        }
    }

    public void onProjectDeleted(@Observes RepositoryRemovedEvent repositoryRemovedEvent) {
        if (this.isLibraryPerspectiveOpen() && this.isRepoForActiveProject(repositoryRemovedEvent)) {
            this.closeAllPlaces();
            WorkspaceProjectContextChangeEvent contextChangeEvent = this.projectContext.getActiveOrganizationalUnit().map(ou -> new WorkspaceProjectContextChangeEvent(ou)).orElseGet(() -> new WorkspaceProjectContextChangeEvent());
            this.projectContextChangeEvent.fire((Object)contextChangeEvent);
            this.goToLibrary();
            this.notificationEvent.fire((Object)new NotificationEvent(this.ts.getTranslation("ProjectDeleted"), NotificationEvent.NotificationType.DEFAULT));
        }
    }

    private boolean isRepoForActiveProject(RepositoryRemovedEvent repositoryRemovedEvent) {
        return this.projectContext.getActiveWorkspaceProject().filter(project -> {
            Repository activeRepo = project.getRepository();
            Repository eventRepo = repositoryRemovedEvent.getRepository();
            return activeRepo.getIdentifier().equals(eventRepo.getIdentifier());
        }).isPresent();
    }

    public void onOrganizationalUnitRemoved(@Observes RemoveOrganizationalUnitEvent removedOrganizationalUnitEvent) {
        if (this.isLibraryPerspectiveOpen()) {
            this.projectContext.getActiveOrganizationalUnit().filter(active -> active.equals(removedOrganizationalUnitEvent.getOrganizationalUnit())).ifPresent(active -> this.projectContextChangeEvent.fire((Object)new WorkspaceProjectContextChangeEvent()));
        }
    }

    public void onProjectRenamed(@Observes RenameModuleEvent renameModuleEvent) {
        if (this.isLibraryPerspectiveOpen()) {
            this.projectContext.getActiveWorkspaceProject().map(proj -> proj.getMainModule()).filter(module -> renameModuleEvent.getOldModule().equals(module)).ifPresent(module -> this.refresh(null));
        }
    }

    public void onAssetSelected(@Observes AssetDetailEvent assetDetails) {
        this.goToAsset(assetDetails.getPath());
    }

    public void setUpBranches() {
        this.libraryToolbar.setUpBranches();
    }

    private boolean isLibraryPerspectiveOpen() {
        return this.placeManager.getStatus(LIBRARY_PERSPECTIVE).equals((Object)PlaceStatus.OPEN) || this.placeManager.getStatus(this.getLibraryPlaceRequestWithoutRefresh()).equals((Object)PlaceStatus.OPEN);
    }

    public void onPreferencesSave(@Observes PreferencesCentralSaveEvent event) {
        if (this.isLibraryPerspectiveOpen()) {
            this.goToProject();
        }
    }

    public void onPreferencesCancel(@Observes PreferencesCentralUndoChangesEvent event) {
        if (this.isLibraryPerspectiveOpen()) {
            this.goToProject();
        }
    }

    public void onSocialFileSelected(final @Observes SocialFileSelectedEvent event) {
        ((VFSService)this.vfsService.call((RemoteCallback)new RemoteCallback<Path>(){

            public void callback(final Path path) {
                ((WorkspaceProjectService)LibraryPlaces.this.projectService.call((RemoteCallback)new RemoteCallback<WorkspaceProject>(){

                    public void callback(WorkspaceProject project) {
                        LibraryPlaces.this.openBestSuitedScreen(event.getEventType(), path, project);
                    }
                })).resolveProject(path);
            }
        })).get(event.getUri());
    }

    private void openBestSuitedScreen(String eventType, Path path, WorkspaceProject project) {
        if (!this.projectContext.getActiveWorkspaceProject().map(active -> active.equals((Object)project)).orElse(false).booleanValue()) {
            this.projectContextChangeEvent.fire((Object)new WorkspaceProjectContextChangeEvent(project, project.getMainModule()));
        }
        PlaceRequest libraryPerspectivePlace = this.getLibraryPlaceRequestWithoutRefresh();
        if (this.isRepositoryEvent(eventType)) {
            this.placeManager.goTo(REPOSITORY_STRUCTURE_SCREEN);
        } else if (this.isModuleEvent(eventType)) {
            this.placeManager.goTo(libraryPerspectivePlace);
            this.goToProject();
        } else if (path != null) {
            this.placeManager.goTo(libraryPerspectivePlace);
            this.goToProject(() -> this.goToAsset(path));
        }
    }

    PlaceRequest getLibraryPlaceRequestWithoutRefresh() {
        return this.getPlaceRequestWithoutRefresh(LIBRARY_PERSPECTIVE);
    }

    PlaceRequest getProjectScreenRequestWithoutRefresh() {
        return this.getPlaceRequestWithoutRefresh(PROJECT_SCREEN);
    }

    private PlaceRequest getPlaceRequestWithoutRefresh(String placeId) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("refresh", "false");
        return new DefaultPlaceRequest(placeId, params);
    }

    private boolean isRepositoryEvent(String eventType) {
        if (eventType == null || eventType.isEmpty()) {
            return false;
        }
        return ExtendedTypes.NEW_REPOSITORY_EVENT.name().equals(eventType);
    }

    private boolean isModuleEvent(String eventType) {
        return ModuleEventType.NEW_MODULE.name().equals(eventType);
    }

    public void setupLibraryBreadCrumbs() {
        this.setupLibraryBreadCrumbs(this.projectContext.getActiveWorkspaceProject().orElse(null));
    }

    public void setupLibraryBreadCrumbsWithoutProject() {
        this.setupLibraryBreadCrumbs(null);
    }

    public void setupLibraryBreadCrumbs(WorkspaceProject project) {
        this.breadcrumbs.clearBreadcrumbs(LIBRARY_PERSPECTIVE);
        this.breadcrumbs.addBreadCrumb(LIBRARY_PERSPECTIVE, this.translationUtils.getOrganizationalUnitAliasInPlural(), () -> this.goToOrganizationalUnits());
        this.projectContext.getActiveOrganizationalUnit().ifPresent(ou -> this.breadcrumbs.addBreadCrumb(LIBRARY_PERSPECTIVE, ou.getName(), () -> this.goToLibrary()));
        if (project != null) {
            this.breadcrumbs.addBreadCrumb(LIBRARY_PERSPECTIVE, project.getName(), () -> this.goToProject());
        }
        this.libraryToolbar.setUpBranches();
    }

    public void setupLibraryBreadCrumbsForTrySamples() {
        this.breadcrumbs.clearBreadcrumbs(LIBRARY_PERSPECTIVE);
        this.breadcrumbs.addBreadCrumb(LIBRARY_PERSPECTIVE, this.translationUtils.getOrganizationalUnitAliasInPlural(), () -> this.goToOrganizationalUnits());
        this.breadcrumbs.addBreadCrumb(LIBRARY_PERSPECTIVE, ((OrganizationalUnit)this.projectContext.getActiveOrganizationalUnit().orElseThrow(() -> new IllegalStateException("Cannot create library breadcrumb without active space."))).getName(), () -> this.goToLibrary());
        this.breadcrumbs.addBreadCrumb(LIBRARY_PERSPECTIVE, this.ts.getTranslation("TrySamples"), () -> this.goToTrySamples());
    }

    public void setupLibraryBreadCrumbsForProjectMetrics() {
        this.setupLibraryBreadCrumbs();
        this.breadcrumbs.addBreadCrumb(LIBRARY_PERSPECTIVE, this.translationUtils.getProjectMetrics(), () -> this.goToProjectMetrics());
    }

    public void setupLibraryBreadCrumbsForOrgUnitsMetrics() {
        this.setupLibraryBreadCrumbs();
        this.breadcrumbs.addBreadCrumb(LIBRARY_PERSPECTIVE, this.translationUtils.getOrgUnitsMetrics(), () -> this.goToOrgUnitsMetrics());
    }

    public void setupLibraryBreadCrumbsForAsset(Path path) {
        this.setupLibraryBreadCrumbs();
        this.breadcrumbs.addBreadCrumb(LIBRARY_PERSPECTIVE, this.getAssetName(path), () -> this.goToAsset(path));
    }

    private String getAssetName(Path path) {
        if (path != null) {
            return this.resourceUtils.getBaseFileName(path);
        }
        return this.ts.format("Settings", new Object[0]);
    }

    public void setupLibraryBreadCrumbsForPreferences() {
        this.setupLibraryBreadCrumbs();
        this.breadcrumbs.addBreadCrumb(LIBRARY_PERSPECTIVE, this.ts.getTranslation("Preferences"), () -> this.goToPreferences());
    }

    public void refresh(Command callback) {
        this.breadcrumbs.clearBreadcrumbs(LIBRARY_PERSPECTIVE);
        this.translationUtils.refresh(() -> this.libraryToolbar.init(() -> {
            if (callback != null) {
                callback.execute();
            }
        }));
    }

    public void goToOrganizationalUnits() {
        if (this.closeAllPlacesOrNothing()) {
            PortablePreconditions.checkNotNull((String)"libraryPerspective.closeAllPlacesOrNothing", (Object)this.libraryPerspective);
            this.projectContextChangeEvent.fire((Object)new WorkspaceProjectContextChangeEvent());
            DefaultPlaceRequest placeRequest = new DefaultPlaceRequest(ORGANIZATIONAL_UNITS_SCREEN);
            PartDefinitionImpl part = new PartDefinitionImpl((PlaceRequest)placeRequest);
            part.setSelectable(false);
            this.placeManager.goTo((PartDefinition)part, this.libraryPerspective.getRootPanel());
            this.setupLibraryBreadCrumbs();
        }
    }

    public void goToLibrary() {
        if (!this.projectContext.getActiveOrganizationalUnit().isPresent()) {
            ((LibraryService)this.libraryService.call((RemoteCallback)new RemoteCallback<OrganizationalUnit>(){

                public void callback(OrganizationalUnit organizationalUnit) {
                    LibraryPlaces.this.projectContextChangeEvent.fire((Object)new WorkspaceProjectContextChangeEvent(organizationalUnit));
                    LibraryPlaces.this.setupLibraryPerspective();
                }
            })).getDefaultOrganizationalUnit();
        } else {
            this.setupLibraryPerspective();
        }
    }

    private void setupLibraryPerspective() {
        OrganizationalUnit activeOu = (OrganizationalUnit)this.projectContext.getActiveOrganizationalUnit().orElseThrow(() -> new IllegalStateException("Cannot setup library perspective without active space."));
        PortablePreconditions.checkNotNull((String)"libraryPerspective", (Object)this.libraryPerspective);
        DefaultPlaceRequest placeRequest = new DefaultPlaceRequest(LIBRARY_SCREEN);
        PartDefinitionImpl part = new PartDefinitionImpl((PlaceRequest)placeRequest);
        part.setSelectable(false);
        if (!this.projectContext.getActiveWorkspaceProject().isPresent()) {
            this.projectContextChangeEvent.fire((Object)new WorkspaceProjectContextChangeEvent(activeOu));
        }
        this.closeLibraryPlaces();
        this.placeManager.goTo((PartDefinition)part, this.libraryPerspective.getRootPanel());
        this.setupLibraryBreadCrumbsWithoutProject();
        this.hideDocks();
    }

    public void goToProject(WorkspaceProject project) {
        if (this.projectContext.getActiveWorkspaceProject().map(activeProject -> !activeProject.equals((Object)project)).orElse(true).booleanValue()) {
            if (this.closeAllPlacesOrNothing()) {
                this.projectContextChangeEvent.fire((Object)new WorkspaceProjectContextChangeEvent(project, project.getMainModule()));
                this.goToProject();
            }
        } else {
            this.goToProject();
        }
    }

    void goToProject() {
        this.goToProject(() -> {});
    }

    private void goToProject(Command callback) {
        this.setupLibraryBreadCrumbs((WorkspaceProject)this.projectContext.getActiveWorkspaceProject().orElseThrow(() -> new IllegalStateException("Cannot go to project when no project is active.")));
        PartDefinitionImpl part = new PartDefinitionImpl((PlaceRequest)new DefaultPlaceRequest(PROJECT_SCREEN));
        part.setSelectable(false);
        this.placeManager.goTo((PartDefinition)part, this.libraryPerspective.getRootPanel());
        if (callback != null) {
            callback.execute();
        }
    }

    public void goToOrgUnitsMetrics() {
        DefaultPlaceRequest metricsScreen = new DefaultPlaceRequest(ORG_UNITS_METRICS_SCREEN);
        PartDefinitionImpl part = new PartDefinitionImpl((PlaceRequest)metricsScreen);
        part.setSelectable(false);
        this.placeManager.goTo((PartDefinition)part, this.libraryPerspective.getRootPanel());
        this.setupLibraryBreadCrumbsForOrgUnitsMetrics();
    }

    public void goToProjectMetrics() {
        DefaultPlaceRequest metricsScreen = new DefaultPlaceRequest(PROJECT_METRICS_SCREEN);
        PartDefinitionImpl part = new PartDefinitionImpl((PlaceRequest)metricsScreen);
        part.setSelectable(false);
        this.placeManager.goTo((PartDefinition)part, this.libraryPerspective.getRootPanel());
        this.setupLibraryBreadCrumbsForProjectMetrics();
        this.projectMetricsEvent.fire((Object)new WorkbenchProjectMetricsEvent((WorkspaceProject)this.projectContext.getActiveWorkspaceProject().orElseThrow(() -> new IllegalStateException("Cannot fire event for project metrics without an active project."))));
    }

    public void goToAsset(final Path path) {
        ((KieModuleService)this.moduleService.call((RemoteCallback)new RemoteCallback<Package>(){

            public void callback(Package response) {
                LibraryPlaces.this.projectContextChangeEvent.fire((Object)new WorkspaceProjectContextChangeEvent((WorkspaceProject)LibraryPlaces.this.projectContext.getActiveWorkspaceProject().orElse(null), (Module)LibraryPlaces.this.projectContext.getActiveModule().orElse(null), response));
                PlaceRequest placeRequest = LibraryPlaces.this.generatePlaceRequest(path);
                LibraryPlaces.this.placeManager.goTo(placeRequest);
                if (path != null) {
                    ObservablePath observablePath = ((PathPlaceRequest)placeRequest).getPath();
                    observablePath.onRename(() -> LibraryPlaces.this.setupLibraryBreadCrumbsForAsset((Path)observablePath));
                }
            }
        })).resolvePackage(path);
    }

    public void goToAddAsset() {
        DefaultPlaceRequest addAssetScreen = new DefaultPlaceRequest(ADD_ASSET_SCREEN);
        PartDefinitionImpl part = new PartDefinitionImpl((PlaceRequest)addAssetScreen);
        part.setSelectable(false);
        this.placeManager.goTo((PartDefinition)part, this.libraryPerspective.getRootPanel());
    }

    public void goToTrySamples() {
        if (this.closeAllPlacesOrNothing()) {
            DefaultPlaceRequest placeRequest = new DefaultPlaceRequest(IMPORT_SAMPLE_PROJECTS_SCREEN);
            PartDefinitionImpl part = new PartDefinitionImpl((PlaceRequest)placeRequest);
            part.setSelectable(false);
            this.placeManager.goTo((PartDefinition)part, this.libraryPerspective.getRootPanel());
            this.setupLibraryBreadCrumbsForTrySamples();
        }
    }

    public void goToImportRepositoryPopUp() {
        ImportRepositoryPopUpPresenter importRepositoryPopUpPresenter = (ImportRepositoryPopUpPresenter)this.importRepositoryPopUpPresenters.get();
        importRepositoryPopUpPresenter.show();
    }

    public void goToSettings() {
        DefaultPlaceRequest placeRequest = new DefaultPlaceRequest(PROJECT_SETTINGS);
        PartDefinitionImpl part = new PartDefinitionImpl((PlaceRequest)placeRequest);
        part.setSelectable(false);
        this.closeLibraryPlaces();
        this.placeManager.goTo((PartDefinition)part, this.libraryPerspective.getRootPanel());
    }

    public void goToPreferences() {
        PreferenceScopeResolutionStrategyInfo customScopeResolutionStrategy = this.projectScopedResolutionStrategySupplier.get();
        PreferencesCentralInitializationEvent initEvent = new PreferencesCentralInitializationEvent("ProjectPreferences", customScopeResolutionStrategy, null);
        DefaultPlaceRequest placeRequest = new DefaultPlaceRequest("PreferencesRootScreen");
        PartDefinitionImpl part = new PartDefinitionImpl((PlaceRequest)placeRequest);
        part.setSelectable(false);
        this.placeManager.goTo((PartDefinition)part, this.libraryPerspective.getRootPanel());
        this.preferencesCentralInitializationEvent.fire((Object)initEvent);
        this.setupLibraryBreadCrumbsForPreferences();
    }

    PlaceRequest generatePlaceRequest(Path path) {
        if (path == null) {
            return new DefaultPlaceRequest(PROJECT_SETTINGS);
        }
        return this.createPathPlaceRequest(path);
    }

    PathPlaceRequest createPathPlaceRequest(Path path) {
        return new PathPlaceRequest(path);
    }

    void closeLibraryPlaces() {
        this.closingLibraryPlaces = true;
        LIBRARY_PLACES.forEach(place -> this.placeManager.closePlace(place));
        this.closingLibraryPlaces = false;
    }

    public boolean closeAllPlacesOrNothing() {
        this.closingLibraryPlaces = true;
        boolean placesClosed = this.placeManager.closeAllPlacesOrNothing();
        this.closingLibraryPlaces = false;
        return placesClosed;
    }

    void closeAllPlaces() {
        this.closingLibraryPlaces = true;
        this.placeManager.closeAllPlaces();
        this.closingLibraryPlaces = false;
    }

    public WorkspaceProject getActiveWorkspaceContext() {
        return (WorkspaceProject)this.projectContext.getActiveWorkspaceProject().orElseThrow(() -> new IllegalStateException("No active workspace project found"));
    }

    public void init(LibraryPerspective libraryPerspective) {
        this.libraryPerspective = libraryPerspective;
    }

    public void onChange(WorkspaceProjectContextChangeEvent previous, WorkspaceProjectContextChangeEvent current) {
        if (current.getWorkspaceProject() != null && !current.getWorkspaceProject().equals((Object)previous.getWorkspaceProject()) && this.closeAllPlacesOrNothing()) {
            this.goToProject();
        }
    }
}

