/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.library.client.util;

import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.dashbuilder.dataset.date.DayOfWeek;
import org.dashbuilder.dataset.filter.ColumnFilter;
import org.dashbuilder.dataset.filter.FilterFactory;
import org.dashbuilder.dataset.group.AggregateFunctionType;
import org.dashbuilder.dataset.group.DateIntervalType;
import org.dashbuilder.dataset.sort.SortOrder;
import org.dashbuilder.displayer.DisplayerSettings;
import org.dashbuilder.displayer.DisplayerSettingsFactory;
import org.dashbuilder.displayer.DisplayerSubType;
import org.dashbuilder.displayer.Position;
import org.dashbuilder.displayer.client.Displayer;
import org.dashbuilder.displayer.client.DisplayerLocator;
import org.dashbuilder.displayer.impl.AreaChartSettingsBuilderImpl;
import org.dashbuilder.displayer.impl.BarChartSettingsBuilderImpl;
import org.dashbuilder.displayer.impl.BubbleChartSettingsBuilderImpl;
import org.dashbuilder.displayer.impl.PieChartSettingsBuilderImpl;
import org.dashbuilder.displayer.impl.SelectorDisplayerSettingsBuilderImpl;
import org.dashbuilder.displayer.impl.TableDisplayerSettingsBuilderImpl;
import org.guvnor.common.services.project.model.WorkspaceProject;
import org.jboss.errai.ui.client.local.spi.TranslationService;

@ApplicationScoped
public class ProjectMetricsFactory {
    private TranslationService translationService;
    private DisplayerLocator displayerLocator;

    @Inject
    public ProjectMetricsFactory(TranslationService translationService, DisplayerLocator displayerLocator) {
        this.translationService = translationService;
        this.displayerLocator = displayerLocator;
    }

    public Displayer lookupCommitsOverTimeDisplayer(WorkspaceProject project) {
        DisplayerSettings settings = this.buildCommitsOverTimeSettings(project);
        return this.displayerLocator.lookupDisplayer(settings);
    }

    public Displayer lookupCommitsOverTimeDisplayer_small(WorkspaceProject project) {
        DisplayerSettings settings = this.buildCommitsOverTimeSettings(project);
        settings.setChartWidth(300);
        settings.setChartHeight(80);
        settings.setChartMarginTop(5);
        settings.setChartMarginBottom(5);
        settings.setTitleVisible(false);
        settings.setYAxisTitle(null);
        return this.displayerLocator.lookupDisplayer(settings);
    }

    public Displayer lookupCommitsPerAuthorDisplayer(WorkspaceProject project) {
        DisplayerSettings settings = this.buildCommitsPerAuthorSettings(project);
        return this.displayerLocator.lookupDisplayer(settings);
    }

    public Displayer lookupCommitsByYearDisplayer(WorkspaceProject project) {
        DisplayerSettings settings = this.buildCommitsByYearSettings(project);
        return this.displayerLocator.lookupDisplayer(settings);
    }

    public Displayer lookupCommitsByQuarterDisplayer(WorkspaceProject project) {
        DisplayerSettings settings = this.buildCommitsByQuarterSettings(project);
        return this.displayerLocator.lookupDisplayer(settings);
    }

    public Displayer lookupCommitsByDayOfWeekDisplayer(WorkspaceProject project) {
        DisplayerSettings settings = this.buildCommitsByDayOfWeekSettings(project);
        return this.displayerLocator.lookupDisplayer(settings);
    }

    public Displayer lookupTopContributorSelectorDisplayer(WorkspaceProject project) {
        DisplayerSettings settings = this.buildTopContributorSelectorSettings(project);
        return this.displayerLocator.lookupDisplayer(settings);
    }

    public Displayer lookupDateSelectorDisplayer(WorkspaceProject project) {
        DisplayerSettings settings = this.buildDateSelectorSettings(project);
        return this.displayerLocator.lookupDisplayer(settings);
    }

    public Displayer lookupAllCommitsDisplayer(WorkspaceProject project) {
        DisplayerSettings settings = this.buildAllCommitsSettings(project);
        return this.displayerLocator.lookupDisplayer(settings);
    }

    protected ColumnFilter createProjectFilter(WorkspaceProject project) {
        String repoAlias = project.getRepository().getAlias();
        String projectName = project.getName();
        return FilterFactory.AND((ColumnFilter[])new ColumnFilter[]{FilterFactory.equalsTo((String)"repository", (Comparable)((Object)repoAlias)), FilterFactory.equalsTo((String)"project", (Comparable)((Object)projectName))});
    }

    public DisplayerSettings buildCommitsPerAuthorSettings(WorkspaceProject project) {
        return ((BubbleChartSettingsBuilderImpl)((BubbleChartSettingsBuilderImpl)((BubbleChartSettingsBuilderImpl)((BubbleChartSettingsBuilderImpl)((BubbleChartSettingsBuilderImpl)((BubbleChartSettingsBuilderImpl)((BubbleChartSettingsBuilderImpl)((BubbleChartSettingsBuilderImpl)((BubbleChartSettingsBuilderImpl)((BubbleChartSettingsBuilderImpl)((BubbleChartSettingsBuilderImpl)((BubbleChartSettingsBuilderImpl)((BubbleChartSettingsBuilderImpl)((BubbleChartSettingsBuilderImpl)((BubbleChartSettingsBuilderImpl)((BubbleChartSettingsBuilderImpl)((BubbleChartSettingsBuilderImpl)((BubbleChartSettingsBuilderImpl)DisplayerSettingsFactory.newBubbleChartSettings().dataset("gitContributors")).filter(new ColumnFilter[]{this.createProjectFilter(project)})).group("author")).column("author", this.translationService.getTranslation("Author"))).column(AggregateFunctionType.COUNT, "#commits")).format(this.translationService.getTranslation("NumberOfCommits"), "#,##0")).column(AggregateFunctionType.COUNT, "#commits")).format(this.translationService.getTranslation("NumberOfCommits"), "#,##0")).column("author", this.translationService.getTranslation("Author"))).column("author", AggregateFunctionType.DISTINCT)).format(this.translationService.getTranslation("Author"), "#,##0")).titleVisible(false)).width(450)).height(200)).margins(10, 40, 40, 0)).xAxisTitle(this.translationService.getTranslation("NumberOfCommits"))).yAxisTitle(this.translationService.getTranslation("NumberOfCommits"))).filterOff(true)).buildSettings();
    }

    public DisplayerSettings buildCommitsOverTimeSettings(WorkspaceProject project) {
        return ((AreaChartSettingsBuilderImpl)((AreaChartSettingsBuilderImpl)((AreaChartSettingsBuilderImpl)((AreaChartSettingsBuilderImpl)((AreaChartSettingsBuilderImpl)((AreaChartSettingsBuilderImpl)((AreaChartSettingsBuilderImpl)((AreaChartSettingsBuilderImpl)((AreaChartSettingsBuilderImpl)((AreaChartSettingsBuilderImpl)((AreaChartSettingsBuilderImpl)((AreaChartSettingsBuilderImpl)((AreaChartSettingsBuilderImpl)DisplayerSettingsFactory.newAreaChartSettings().dataset("gitContributors")).filter(new ColumnFilter[]{this.createProjectFilter(project)})).group("date")).dynamic(80, DateIntervalType.MONTH, true)).column("date", this.translationService.getTranslation("Date"))).column(AggregateFunctionType.COUNT, "#commits")).format(this.translationService.getTranslation("NumberOfCommits"), "#,##0")).titleVisible(false)).width(450)).height(145)).margins(10, 5, 40, 0)).yAxisTitle(this.translationService.getTranslation("NumberOfCommits"))).filterOff(true)).buildSettings();
    }

    public DisplayerSettings buildCommitsByYearSettings(WorkspaceProject project) {
        return ((PieChartSettingsBuilderImpl)((PieChartSettingsBuilderImpl)((PieChartSettingsBuilderImpl)((PieChartSettingsBuilderImpl)((PieChartSettingsBuilderImpl)((PieChartSettingsBuilderImpl)((PieChartSettingsBuilderImpl)((PieChartSettingsBuilderImpl)((PieChartSettingsBuilderImpl)((PieChartSettingsBuilderImpl)((PieChartSettingsBuilderImpl)((PieChartSettingsBuilderImpl)((PieChartSettingsBuilderImpl)((PieChartSettingsBuilderImpl)((PieChartSettingsBuilderImpl)((PieChartSettingsBuilderImpl)DisplayerSettingsFactory.newPieChartSettings().dataset("gitContributors")).filter("date", new ColumnFilter[]{FilterFactory.notNull()})).filter(new ColumnFilter[]{this.createProjectFilter(project)})).group("date")).dynamic(DateIntervalType.YEAR, false)).column("date")).column(AggregateFunctionType.COUNT, "#commits")).format(this.translationService.getTranslation("NumberOfCommits"), "#,##0")).sort("date", SortOrder.ASCENDING)).title(this.translationService.getTranslation("Years"))).titleVisible(false)).width(250)).height(170)).margins(10, 0, 10, 5)).legendOn(Position.RIGHT)).filterOn(false, true, true)).buildSettings();
    }

    public DisplayerSettings buildCommitsByQuarterSettings(WorkspaceProject project) {
        return ((PieChartSettingsBuilderImpl)((PieChartSettingsBuilderImpl)((PieChartSettingsBuilderImpl)((PieChartSettingsBuilderImpl)((PieChartSettingsBuilderImpl)((PieChartSettingsBuilderImpl)((PieChartSettingsBuilderImpl)((PieChartSettingsBuilderImpl)((PieChartSettingsBuilderImpl)((PieChartSettingsBuilderImpl)((PieChartSettingsBuilderImpl)((PieChartSettingsBuilderImpl)((PieChartSettingsBuilderImpl)((PieChartSettingsBuilderImpl)((PieChartSettingsBuilderImpl)DisplayerSettingsFactory.newPieChartSettings().dataset("gitContributors")).filter("date", new ColumnFilter[]{FilterFactory.notNull()})).filter(new ColumnFilter[]{this.createProjectFilter(project)})).group("date")).fixed(DateIntervalType.QUARTER, false)).column("date")).column(AggregateFunctionType.COUNT, "#commits")).format(this.translationService.getTranslation("NumberOfCommits"), "#,##0")).title(this.translationService.getTranslation("Quarters"))).titleVisible(false)).width(250)).height(170)).margins(10, 0, 5, 5)).legendOn(Position.RIGHT)).filterOn(false, true, true)).buildSettings();
    }

    public DisplayerSettings buildCommitsByDayOfWeekSettings(WorkspaceProject project) {
        return ((BarChartSettingsBuilderImpl)((BarChartSettingsBuilderImpl)((BarChartSettingsBuilderImpl)((BarChartSettingsBuilderImpl)((BarChartSettingsBuilderImpl)((BarChartSettingsBuilderImpl)((BarChartSettingsBuilderImpl)((BarChartSettingsBuilderImpl)((BarChartSettingsBuilderImpl)((BarChartSettingsBuilderImpl)((BarChartSettingsBuilderImpl)((BarChartSettingsBuilderImpl)((BarChartSettingsBuilderImpl)((BarChartSettingsBuilderImpl)((BarChartSettingsBuilderImpl)((BarChartSettingsBuilderImpl)DisplayerSettingsFactory.newBarChartSettings().dataset("gitContributors")).filter("date", new ColumnFilter[]{FilterFactory.notNull()})).filter(new ColumnFilter[]{this.createProjectFilter(project)})).group("date")).fixed(DateIntervalType.DAY_OF_WEEK, true)).firstDay(DayOfWeek.SUNDAY)).column("date")).column(AggregateFunctionType.COUNT, "#commits")).format(this.translationService.getTranslation("NumberOfCommits"), "#,##0")).title(this.translationService.getTranslation("DayOfWeek"))).titleVisible(false)).width(250)).height(170)).margins(10, 40, 70, 0)).subType_Bar().xAxisTitle(this.translationService.getTranslation("NumberOfCommits"))).filterOn(false, true, true)).buildSettings();
    }

    public DisplayerSettings buildTopContributorSelectorSettings(WorkspaceProject project) {
        return ((SelectorDisplayerSettingsBuilderImpl)((SelectorDisplayerSettingsBuilderImpl)((SelectorDisplayerSettingsBuilderImpl)((SelectorDisplayerSettingsBuilderImpl)((SelectorDisplayerSettingsBuilderImpl)((SelectorDisplayerSettingsBuilderImpl)((SelectorDisplayerSettingsBuilderImpl)((SelectorDisplayerSettingsBuilderImpl)((SelectorDisplayerSettingsBuilderImpl)((SelectorDisplayerSettingsBuilderImpl)((SelectorDisplayerSettingsBuilderImpl)((SelectorDisplayerSettingsBuilderImpl)((SelectorDisplayerSettingsBuilderImpl)DisplayerSettingsFactory.newSelectorSettings().dataset("gitContributors")).filter(new ColumnFilter[]{this.createProjectFilter(project)})).group("author")).column("author", this.translationService.getTranslation("TopContributor"))).column(AggregateFunctionType.COUNT, "#commits")).format(this.translationService.getTranslation("NumberOfCommits"), "#,##0")).sort("#commits", SortOrder.DESCENDING)).subtype(DisplayerSubType.SELECTOR_DROPDOWN)).multiple(true)).titleVisible(false)).margins(0, 0, 10, 0)).width(200)).filterOn(false, true, true)).buildSettings();
    }

    public DisplayerSettings buildDateSelectorSettings(WorkspaceProject project) {
        return ((SelectorDisplayerSettingsBuilderImpl)((SelectorDisplayerSettingsBuilderImpl)((SelectorDisplayerSettingsBuilderImpl)((SelectorDisplayerSettingsBuilderImpl)((SelectorDisplayerSettingsBuilderImpl)((SelectorDisplayerSettingsBuilderImpl)((SelectorDisplayerSettingsBuilderImpl)((SelectorDisplayerSettingsBuilderImpl)((SelectorDisplayerSettingsBuilderImpl)DisplayerSettingsFactory.newSelectorSettings().dataset("gitContributors")).filter(new ColumnFilter[]{this.createProjectFilter(project)})).column("date")).format(this.translationService.getTranslation("Date"), "dd MMM, yyyy HH:mm")).subtype(DisplayerSubType.SELECTOR_SLIDER)).titleVisible(false)).width(420)).margins(0, 0, 20, 10)).filterOn(false, true, true)).buildSettings();
    }

    public DisplayerSettings buildAllCommitsSettings(WorkspaceProject project) {
        return ((TableDisplayerSettingsBuilderImpl)((TableDisplayerSettingsBuilderImpl)((TableDisplayerSettingsBuilderImpl)((TableDisplayerSettingsBuilderImpl)((TableDisplayerSettingsBuilderImpl)((TableDisplayerSettingsBuilderImpl)((TableDisplayerSettingsBuilderImpl)((TableDisplayerSettingsBuilderImpl)((TableDisplayerSettingsBuilderImpl)DisplayerSettingsFactory.newTableSettings().dataset("gitContributors")).filter(new ColumnFilter[]{this.createProjectFilter(project)})).column("author", this.translationService.getTranslation("Author"))).column("date", this.translationService.getTranslation("Date"))).column("message", this.translationService.getTranslation("Message"))).sort("date", SortOrder.DESCENDING)).tablePageSize(5).tableWidth(950).tableOrderEnabled(true).tableColumnPickerEnabled(true).allowExcelExport(true)).allowCsvExport(true)).filterOff(true)).buildSettings();
    }
}

