/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.library.client.util;

import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import org.kie.workbench.common.widgets.client.handlers.NewResourceHandler;

@ApplicationScoped
public class ResourceHandlerManager {
    private List<NewResourceHandler> newResourceHandlers;

    public ResourceHandlerManager() {
    }

    @Inject
    public ResourceHandlerManager(Instance<NewResourceHandler> newResourceHandlers) {
        this.newResourceHandlers = this.toList(newResourceHandlers);
    }

    private <T> List<T> toList(Instance<T> instances) {
        return StreamSupport.stream(instances.spliterator(), false).collect(Collectors.toList());
    }

    public List<NewResourceHandler> getResourceHandlers(Function<NewResourceHandler, Boolean> isBlacklisted) {
        return this.getNewResourceHandlers().stream().filter(resourceHandler -> (Boolean)isBlacklisted.apply((NewResourceHandler)resourceHandler) == false).collect(Collectors.toList());
    }

    protected List<NewResourceHandler> getNewResourceHandlers() {
        return this.newResourceHandlers;
    }
}

