/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.library.client.widgets.library;

import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.guvnor.common.services.project.client.security.ProjectController;
import org.guvnor.common.services.project.model.WorkspaceProject;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.kie.workbench.common.screens.library.client.screens.project.AddProjectPopUpPresenter;
import org.kie.workbench.common.screens.library.client.util.LibraryPlaces;
import org.kie.workbench.common.screens.library.client.util.ResourceUtils;
import org.kie.workbench.common.screens.library.client.widgets.common.MenuResourceHandlerWidget;
import org.kie.workbench.common.widgets.client.handlers.NewResourceHandler;
import org.kie.workbench.common.widgets.client.handlers.NewResourcePresenter;
import org.kie.workbench.common.widgets.client.handlers.NewWorkspaceProjectHandler;
import org.uberfire.client.mvp.UberElement;

public class AddProjectButtonPresenter {
    private View view;
    private ManagedInstance<AddProjectPopUpPresenter> addProjectPopUpPresenters;
    private ManagedInstance<MenuResourceHandlerWidget> menuResourceHandlerWidgets;
    private ManagedInstance<NewWorkspaceProjectHandler> newProjectHandlers;
    private org.kie.workbench.common.screens.projecteditor.client.handlers.NewWorkspaceProjectHandler newDefaultProjectHandler;
    private NewResourcePresenter newResourcePresenter;
    private ProjectController projectController;
    private LibraryPlaces libraryPlaces;

    @Inject
    public AddProjectButtonPresenter(View view, ManagedInstance<AddProjectPopUpPresenter> addProjectPopUpPresenters, ManagedInstance<MenuResourceHandlerWidget> menuResourceHandlerWidgets, ManagedInstance<NewWorkspaceProjectHandler> newProjectHandlers, org.kie.workbench.common.screens.projecteditor.client.handlers.NewWorkspaceProjectHandler newDefaultProjectHandler, NewResourcePresenter newResourcePresenter, ProjectController projectController, LibraryPlaces libraryPlaces) {
        this.view = view;
        this.addProjectPopUpPresenters = addProjectPopUpPresenters;
        this.menuResourceHandlerWidgets = menuResourceHandlerWidgets;
        this.newProjectHandlers = newProjectHandlers;
        this.newDefaultProjectHandler = newDefaultProjectHandler;
        this.newResourcePresenter = newResourcePresenter;
        this.projectController = projectController;
        this.libraryPlaces = libraryPlaces;
    }

    @PostConstruct
    public void init() {
        this.view.init(this);
        this.setupOtherProjects();
    }

    private void setupOtherProjects() {
        if (this.userCanCreateProjects()) {
            boolean hasOtherProjects = false;
            for (NewWorkspaceProjectHandler newWorkspaceProjectHandler : this.getNewProjectHandlers()) {
                if (ResourceUtils.isDefaultProjectHandler((NewResourceHandler)newWorkspaceProjectHandler) || !newWorkspaceProjectHandler.canCreate()) continue;
                this.addNewProjectHandler(newWorkspaceProjectHandler);
                hasOtherProjects = true;
            }
            if (!hasOtherProjects) {
                this.view.hideOtherProjects();
            }
        }
    }

    void addNewProjectHandler(NewWorkspaceProjectHandler newWorkspaceProjectHandler) {
        newWorkspaceProjectHandler.setOpenEditorOnCreation(false);
        newWorkspaceProjectHandler.setCreationSuccessCallback(project -> {
            if (project != null) {
                this.libraryPlaces.goToProject((WorkspaceProject)project);
            }
        });
        MenuResourceHandlerWidget menuResourceHandlerWidget = (MenuResourceHandlerWidget)this.menuResourceHandlerWidgets.get();
        menuResourceHandlerWidget.init(newWorkspaceProjectHandler.getDescription(), newWorkspaceProjectHandler.getCommand(this.newResourcePresenter));
        this.view.addOtherProject(menuResourceHandlerWidget);
    }

    public void addProject() {
        if (this.userCanCreateProjects()) {
            AddProjectPopUpPresenter addProjectPopUpPresenter = (AddProjectPopUpPresenter)this.addProjectPopUpPresenters.get();
            addProjectPopUpPresenter.show();
        }
    }

    public boolean userCanCreateProjects() {
        return this.projectController.canCreateProjects();
    }

    public View getView() {
        return this.view;
    }

    Iterable<NewWorkspaceProjectHandler> getNewProjectHandlers() {
        return this.newProjectHandlers;
    }

    public static interface View
    extends UberElement<AddProjectButtonPresenter> {
        public void addOtherProject(MenuResourceHandlerWidget var1);

        public void hideOtherProjects();
    }
}

