/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.library.client.widgets.library;

import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.guvnor.common.services.project.client.context.WorkspaceProjectContext;
import org.guvnor.common.services.project.model.WorkspaceProject;
import org.guvnor.common.services.project.service.WorkspaceProjectService;
import org.guvnor.structure.repositories.Branch;
import org.guvnor.structure.repositories.Repository;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.kie.workbench.common.screens.library.client.util.LibraryPlaces;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.client.mvp.UberElement;
import org.uberfire.mvp.Command;

@ApplicationScoped
public class LibraryToolbarPresenter {
    private WorkspaceProjectContext projectContext;
    private Caller<WorkspaceProjectService> projectService;
    private LibraryPlaces libraryPlaces;
    private View view;
    private PlaceManager placeManager;

    public LibraryToolbarPresenter() {
    }

    @Inject
    public LibraryToolbarPresenter(WorkspaceProjectContext projectContext, Caller<WorkspaceProjectService> projectService, LibraryPlaces libraryPlaces, View view, PlaceManager placeManager) {
        this.projectContext = projectContext;
        this.projectService = projectService;
        this.libraryPlaces = libraryPlaces;
        this.view = view;
        this.placeManager = placeManager;
        view.init(this);
    }

    public void init(Command callback) {
        this.view.setBranchSelectorVisibility(false);
        callback.execute();
    }

    public void setUpBranches() {
        this.view.clearBranches();
        this.projectContext.getActiveWorkspaceProject().ifPresent(proj -> {
            for (Branch branch : proj.getRepository().getBranches()) {
                this.view.addBranch(branch.getName());
            }
            this.view.setSelectedBranch(proj.getBranch().getName());
        });
        this.setBranchSelectorVisibility();
    }

    void onUpdateSelectedBranch() {
        if (this.placeManager.closeAllPlacesOrNothing()) {
            Repository repository = this.projectContext.getActiveWorkspaceProject().map(workspaceProject -> workspaceProject.getRepository()).orElseThrow(() -> new IllegalStateException("Cannot get repository without an active workspace project"));
            ((WorkspaceProjectService)this.projectService.call((RemoteCallback)new RemoteCallback<WorkspaceProject>(){

                public void callback(WorkspaceProject project) {
                    LibraryToolbarPresenter.this.libraryPlaces.goToProject(project);
                    LibraryToolbarPresenter.this.setBranchSelectorVisibility();
                }
            })).resolveProject(repository.getSpace(), (Branch)repository.getBranch(this.view.getSelectedBranch()).get());
        } else {
            this.setUpBranches();
        }
    }

    private void setBranchSelectorVisibility() {
        this.view.setBranchSelectorVisibility(this.isBranchVisible());
    }

    private boolean isBranchVisible() {
        return this.projectContext.getActiveWorkspaceProject().isPresent() && ((WorkspaceProject)this.projectContext.getActiveWorkspaceProject().get()).getRepository().getBranches().size() > 1;
    }

    public UberElement<LibraryToolbarPresenter> getView() {
        return this.view;
    }

    public static interface View
    extends UberElement<LibraryToolbarPresenter> {
        public void clearBranches();

        public void addBranch(String var1);

        public String getSelectedBranch();

        public void setSelectedBranch(String var1);

        public void setBranchSelectorVisibility(boolean var1);
    }
}

