/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.library.client.widgets.library;

import javax.inject.Inject;
import org.jboss.errai.common.client.dom.DOMUtil;
import org.jboss.errai.common.client.dom.Document;
import org.jboss.errai.common.client.dom.HTMLElement;
import org.jboss.errai.common.client.dom.Label;
import org.jboss.errai.common.client.dom.Node;
import org.jboss.errai.common.client.dom.Option;
import org.jboss.errai.common.client.dom.Select;
import org.jboss.errai.ui.client.local.api.IsElement;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.kie.workbench.common.screens.library.client.widgets.library.LibraryToolbarPresenter;

@Templated
public class LibraryToolbarView
implements LibraryToolbarPresenter.View,
IsElement {
    @Inject
    Document document;
    @Inject
    TranslationService ts;
    @Inject
    @DataField(value="branches-label")
    Label branchesLabel;
    @Inject
    @DataField
    Select branches;

    public void init(LibraryToolbarPresenter presenter) {
        this.branches.setOnchange(event -> presenter.onUpdateSelectedBranch());
    }

    @Override
    public void clearBranches() {
        DOMUtil.removeAllChildren((Node)this.branches);
    }

    @Override
    public void addBranch(String branchName) {
        this.branches.add((HTMLElement)this.createOption(branchName));
    }

    @Override
    public String getSelectedBranch() {
        return this.branches.getValue();
    }

    @Override
    public void setSelectedBranch(String branchName) {
        this.branches.setValue(branchName);
    }

    @Override
    public void setBranchSelectorVisibility(boolean visible) {
        this.branches.setHidden(!visible);
        this.branchesLabel.setHidden(!visible);
    }

    Option createOption(String ou) {
        Option option = (Option)this.document.createElement("option");
        option.setText(ou);
        option.setValue(ou);
        return option;
    }
}

