/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.search.client;

import com.github.gwtbootstrap.client.ui.AccordionGroup;
import com.github.gwtbootstrap.client.ui.Alert;
import com.github.gwtbootstrap.client.ui.ControlGroup;
import com.github.gwtbootstrap.client.ui.TextBox;
import com.github.gwtbootstrap.client.ui.Typeahead;
import com.github.gwtbootstrap.client.ui.constants.AlertType;
import com.github.gwtbootstrap.client.ui.constants.ControlGroupType;
import com.github.gwtbootstrap.datepicker.client.ui.DateBox;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.uibinder.client.UiHandler;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.MultiWordSuggestOracle;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.HashMap;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.kie.workbench.common.screens.search.client.resources.i18n.Constants;
import org.kie.workbench.common.screens.search.client.widgets.SearchResultTable;
import org.kie.workbench.common.screens.search.model.QueryMetadataPageRequest;
import org.uberfire.client.annotations.WorkbenchPartTitle;
import org.uberfire.client.annotations.WorkbenchScreen;
import org.uberfire.client.workbench.type.ClientResourceType;
import org.uberfire.client.workbench.type.ClientTypeRegistry;

@Dependent
@WorkbenchScreen(identifier="FindForm")
public class FindForm
extends Composite {
    private static FindFormBinder uiBinder = (FindFormBinder)GWT.create(FindFormBinder.class);
    @Inject
    private ClientTypeRegistry clientTypeRegistry;
    @UiField
    SimplePanel errorPanel;
    @UiField
    ControlGroup form;
    @UiField
    TextBox sourceTextBox;
    @UiField
    TextBox createdByTextBox;
    @UiField
    TextBox descriptionByTextBox;
    @UiField
    Typeahead formatTypeahead;
    @UiField
    TextBox formatTextBox;
    @UiField
    TextBox subjectTextBox;
    @UiField
    TextBox typeTextBox;
    @UiField
    TextBox lastModifiedByTextBox;
    @UiField
    TextBox externalLinkTextBox;
    @UiField
    TextBox checkinCommentTextBox;
    @UiField(provided=true)
    DateBox createdAfter;
    @UiField(provided=true)
    DateBox createdBefore;
    @UiField(provided=true)
    DateBox lastModifiedAfter;
    @UiField(provided=true)
    DateBox lastModifiedBefore;
    @UiField
    AccordionGroup formAccordion;
    @UiField
    AccordionGroup resultAccordion;
    @UiField
    SimplePanel simplePanel;

    @PostConstruct
    public void init() {
        this.createdAfter = new DateBox();
        this.createdAfter.setValue(null);
        this.createdAfter.setAutoClose(true);
        this.createdBefore = new DateBox();
        this.createdBefore.setValue(null);
        this.createdBefore.setAutoClose(true);
        this.lastModifiedAfter = new DateBox();
        this.lastModifiedAfter.setValue(null);
        this.lastModifiedAfter.setAutoClose(true);
        this.lastModifiedBefore = new DateBox();
        this.lastModifiedBefore.setValue(null);
        this.lastModifiedBefore.setAutoClose(true);
        this.initWidget((Widget)uiBinder.createAndBindUi((Object)this));
        MultiWordSuggestOracle oracle = (MultiWordSuggestOracle)this.formatTypeahead.getSuggestOracle();
        for (ClientResourceType resourceType : this.clientTypeRegistry.getRegisteredTypes()) {
            oracle.add(resourceType.getShortName());
        }
    }

    @UiHandler(value={"search"})
    public void onSearchClick(ClickEvent e) {
        this.errorPanel.clear();
        this.form.setType(ControlGroupType.NONE);
        HashMap<String, String> metadata = new HashMap<String, String>();
        if (!this.sourceTextBox.getText().trim().isEmpty()) {
            metadata.put("dcore.source[0]", this.sourceTextBox.getText().trim());
        }
        if (!this.createdByTextBox.getText().trim().isEmpty()) {
            metadata.put("createdBy", this.createdByTextBox.getText().trim());
        }
        if (!this.descriptionByTextBox.getText().trim().isEmpty()) {
            metadata.put("dcore.description[0]", this.descriptionByTextBox.getText().trim());
        }
        if (!this.formatTextBox.getText().trim().isEmpty()) {
            String pattern = this.clientTypeRegistry.resolveWildcardPattern(this.formatTextBox.getText().trim());
            metadata.put("filename", pattern);
        }
        if (!this.subjectTextBox.getText().trim().isEmpty()) {
            metadata.put("dcore.subject[0]", this.subjectTextBox.getText().trim());
        }
        if (!this.typeTextBox.getText().trim().isEmpty()) {
            metadata.put("dcore.type[0]", this.typeTextBox.getText().trim());
        }
        if (!this.lastModifiedByTextBox.getText().trim().isEmpty()) {
            metadata.put("lastModifiedBy", this.lastModifiedByTextBox.getText().trim());
        }
        if (!this.externalLinkTextBox.getText().trim().isEmpty()) {
            metadata.put("dcore.relation[0]", this.externalLinkTextBox.getText().trim());
        }
        if (!this.checkinCommentTextBox.getText().trim().isEmpty()) {
            metadata.put("checkinComment", this.checkinCommentTextBox.getText().trim());
        }
        boolean hasSomeDateValue = false;
        if (this.createdAfter.getValue() != null) {
            hasSomeDateValue = true;
        }
        if (this.createdBefore.getValue() != null) {
            hasSomeDateValue = true;
        }
        if (this.lastModifiedAfter.getValue() != null) {
            hasSomeDateValue = true;
        }
        if (this.lastModifiedBefore.getValue() != null) {
            hasSomeDateValue = true;
        }
        if (metadata.size() == 0 && !hasSomeDateValue) {
            this.form.setType(ControlGroupType.ERROR);
            Alert alert = new Alert(Constants.INSTANCE.AtLeastOneFieldMustBeSet(), AlertType.ERROR);
            alert.setVisible(true);
            alert.setClose(true);
            this.errorPanel.add((Widget)alert);
            return;
        }
        SearchResultTable queryTable = new SearchResultTable(new QueryMetadataPageRequest(metadata, this.createdAfter.getValue(), this.createdBefore.getValue(), this.lastModifiedAfter.getValue(), this.lastModifiedBefore.getValue(), 0, null));
        this.simplePanel.clear();
        this.simplePanel.add((Widget)queryTable);
        this.formAccordion.hide();
        this.resultAccordion.show();
    }

    @WorkbenchPartTitle
    public String getTitle() {
        return Constants.INSTANCE.FindTitle();
    }

    static interface FindFormBinder
    extends UiBinder<Widget, FindForm> {
    }
}

