/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.search.client.widgets;

import com.google.gwt.cell.client.Cell;
import com.google.gwt.cell.client.DateCell;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.i18n.shared.DateTimeFormat;
import com.google.gwt.user.cellview.client.Column;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.view.client.AsyncDataProvider;
import com.google.gwt.view.client.HasData;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.Date;
import org.jboss.errai.bus.client.api.base.MessageBuilder;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.jboss.errai.ioc.client.container.IOC;
import org.kie.workbench.common.screens.search.client.resources.i18n.Constants;
import org.kie.workbench.common.screens.search.client.resources.images.ImageResources;
import org.kie.workbench.common.screens.search.model.QueryMetadataPageRequest;
import org.kie.workbench.common.screens.search.model.SearchPageRow;
import org.kie.workbench.common.screens.search.model.SearchTermPageRequest;
import org.kie.workbench.common.screens.search.service.SearchService;
import org.kie.workbench.common.widgets.client.tables.AbstractPathPagedTable;
import org.uberfire.client.workbench.type.ClientResourceType;
import org.uberfire.client.workbench.type.ClientTypeRegistry;
import org.uberfire.ext.widgets.common.client.common.CheckboxCellImpl;
import org.uberfire.ext.widgets.common.client.tables.ComparableImageResource;
import org.uberfire.ext.widgets.common.client.tables.ComparableImageResourceCell;
import org.uberfire.ext.widgets.common.client.tables.TitledTextCell;
import org.uberfire.ext.widgets.common.client.tables.TitledTextColumn;
import org.uberfire.paging.PageResponse;

public class SearchResultTable
extends AbstractPathPagedTable<SearchPageRow> {
    private static final int PAGE_SIZE = 10;
    private ClientTypeRegistry clientTypeRegistry = null;

    public SearchResultTable() {
        super(10);
        this.setDataProvider((AsyncDataProvider)new AsyncDataProvider<SearchPageRow>(){

            protected void onRangeChanged(HasData<SearchPageRow> display) {
                this.updateRowCount(0, true);
                this.updateRowData(0, Collections.emptyList());
            }
        });
    }

    public SearchResultTable(final QueryMetadataPageRequest queryRequest) {
        super(10);
        if (queryRequest.getPageSize() == null) {
            queryRequest.setPageSize(Integer.valueOf(10));
        }
        this.setDataProvider((AsyncDataProvider)new AsyncDataProvider<SearchPageRow>(){

            protected void onRangeChanged(HasData<SearchPageRow> display) {
                queryRequest.setStartRowIndex(SearchResultTable.this.dataGrid.getPageStart());
                queryRequest.setPageSize(Integer.valueOf(SearchResultTable.this.dataGrid.getPageSize()));
                ((SearchService)MessageBuilder.createCall((RemoteCallback)new RemoteCallback<PageResponse<SearchPageRow>>(){

                    public void callback(PageResponse<SearchPageRow> response) {
                        this.updateRowCount(response.getTotalRowSize(), response.isTotalRowSizeExact());
                        this.updateRowData(response.getStartRowIndex(), response.getPageRowList());
                    }
                }, SearchService.class)).queryMetadata(queryRequest);
            }
        });
    }

    public SearchResultTable(final SearchTermPageRequest searchRequest) {
        super(10);
        if (searchRequest.getPageSize() == null) {
            searchRequest.setPageSize(Integer.valueOf(10));
        }
        this.setDataProvider((AsyncDataProvider)new AsyncDataProvider<SearchPageRow>(){

            protected void onRangeChanged(HasData<SearchPageRow> display) {
                searchRequest.setStartRowIndex(SearchResultTable.this.dataGrid.getPageStart());
                searchRequest.setPageSize(Integer.valueOf(SearchResultTable.this.dataGrid.getPageSize()));
                ((SearchService)MessageBuilder.createCall((RemoteCallback)new RemoteCallback<PageResponse<SearchPageRow>>(){

                    public void callback(PageResponse<SearchPageRow> response) {
                        this.updateRowCount(response.getTotalRowSize(), response.isTotalRowSizeExact());
                        this.updateRowData(response.getStartRowIndex(), response.getPageRowList());
                    }
                }, SearchService.class)).fullTextSearch(searchRequest);
            }
        });
    }

    protected void addAncillaryColumns() {
        Column<SearchPageRow, ComparableImageResource> formatColumn = new Column<SearchPageRow, ComparableImageResource>((Cell)new ComparableImageResourceCell()){

            public ComparableImageResource getValue(SearchPageRow row) {
                ClientResourceType associatedType = SearchResultTable.this.getClientTypeRegistry().resolve(row.getPath());
                Image icon = associatedType.getIcon() == null || !(associatedType.getIcon() instanceof Image) ? new Image(ImageResources.INSTANCE.file()) : (Image)associatedType.getIcon();
                return new ComparableImageResource(associatedType.getShortName(), icon);
            }
        };
        this.dataGrid.addColumn((Column)formatColumn, Constants.INSTANCE.Format());
        TitledTextColumn<SearchPageRow> titleColumn = new TitledTextColumn<SearchPageRow>(){

            public TitledTextCell.TitledText getValue(SearchPageRow row) {
                return new TitledTextCell.TitledText(row.getPath().getFileName(), row.getAbbreviatedDescription());
            }
        };
        this.dataGrid.addColumn((Column)titleColumn, Constants.INSTANCE.Name());
        Column<SearchPageRow, Date> createdDateColumn = new Column<SearchPageRow, Date>((Cell)new DateCell((DateTimeFormat)com.google.gwt.i18n.client.DateTimeFormat.getFormat((DateTimeFormat.PredefinedFormat)DateTimeFormat.PredefinedFormat.DATE_TIME_MEDIUM))){

            public Date getValue(SearchPageRow row) {
                return row.getCreatedDate();
            }
        };
        this.dataGrid.addColumn((Column)createdDateColumn, Constants.INSTANCE.CreatedDate(), false);
        Column<SearchPageRow, Date> lastModifiedColumn = new Column<SearchPageRow, Date>((Cell)new DateCell((DateTimeFormat)com.google.gwt.i18n.client.DateTimeFormat.getFormat((DateTimeFormat.PredefinedFormat)DateTimeFormat.PredefinedFormat.DATE_TIME_MEDIUM))){

            public Date getValue(SearchPageRow row) {
                return row.getLastModified();
            }
        };
        this.dataGrid.addColumn((Column)lastModifiedColumn, Constants.INSTANCE.LastModified());
        Column<SearchPageRow, Boolean> isDisabledColumn = new Column<SearchPageRow, Boolean>((Cell)new CheckboxCellImpl(true)){

            public Boolean getValue(SearchPageRow row) {
                return row.isDisabled();
            }
        };
        this.dataGrid.addColumn((Column)isDisabledColumn, Constants.INSTANCE.Disabled(), false);
    }

    private ClientTypeRegistry getClientTypeRegistry() {
        if (this.clientTypeRegistry == null) {
            this.clientTypeRegistry = (ClientTypeRegistry)IOC.getBeanManager().lookupBean(ClientTypeRegistry.class, new Annotation[0]).getInstance();
        }
        return this.clientTypeRegistry;
    }
}

