/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.search.client.menu;

import org.apache.commons.lang3.RandomStringUtils;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.screens.search.client.menu.SearchMenuPresenter;
import org.kie.workbench.common.widgets.client.search.ClearSearchEvent;
import org.kie.workbench.common.widgets.client.search.ContextualSearch;
import org.kie.workbench.common.widgets.client.search.SearchBehavior;
import org.kie.workbench.common.widgets.client.search.SetSearchTextEvent;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class SearchMenuPresenterTest {
    @Mock
    private ContextualSearch contextualSearch;
    @Mock
    private SearchMenuPresenter.View view;
    @InjectMocks
    private SearchMenuPresenter presenter;

    @Test
    public void testClearEvent() {
        this.presenter.onClearSearchBox((ClearSearchEvent)Mockito.mock(ClearSearchEvent.class));
        ((SearchMenuPresenter.View)Mockito.verify((Object)this.view)).setText("");
    }

    @Test
    public void testSetSearchText() {
        SetSearchTextEvent setSearchText = (SetSearchTextEvent)Mockito.mock(SetSearchTextEvent.class);
        String text = RandomStringUtils.random((int)10);
        Mockito.when((Object)setSearchText.getSearchText()).thenReturn((Object)text);
        this.presenter.onSetSearchText(setSearchText);
        ((SearchMenuPresenter.View)Mockito.verify((Object)this.view)).setText(text);
    }

    @Test
    public void testSearch() {
        SearchBehavior searchBehavior = (SearchBehavior)Mockito.mock(SearchBehavior.class);
        Mockito.when((Object)this.contextualSearch.getSearchBehavior()).thenReturn((Object)searchBehavior);
        String text = RandomStringUtils.random((int)10);
        this.presenter.search(text);
        ((SearchBehavior)Mockito.verify((Object)searchBehavior)).execute(text);
    }
}

